/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * SnapshotDialog.h: A dialog for capturing snapshots of displays
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/SnapshotDialog.h,v 1.4 1994/02/25 04:31:28 aydt Exp $
 */

#ifndef SnapshotDialog_h
#define SnapshotDialog_h

#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrolledW.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>

#include "Obj.h"
#include "FUClassification.h"
#include "VoidPtrList.h"


#define   STRING_MAX_LEN    80
typedef enum { SS_OFF, SS_ADD, SS_DELETE, SS_SUPER } SnapshotMode;
typedef enum { SEL_WHOLE, SEL_PIECE } SnapshotSelectOption;

typedef struct {
      Widget widgetID;
      int **data;
      int dataCount, dataDimension;
      Pixel *baseColors, *dataColors;
      int numBaseColors, numDataColors;
      Dimension width, height;
      int *minValue, *maxValue;
      int topPosition, bottomPosition, leftPosition, rightPosition;
      int fractionBase;
      void *next;
} SnapshotWidgetInfo;


typedef struct {
      Widget wholeSelectOption, pieceSelectOption;
} SnapshotOptionInfo;


class SnapshotDialog : public Obj {
/*
 *
 * A SnapshotDialog allows the user manual or automatic control over the
 * capture of display functional unit data during execution.
 *
 */
private:
       static const char *const MY_CLASS;   // Our class name
       static Widget snapshotDialog, snapshotModeTextWidget,
                     actionWorkWindow;
       static Widget superButton;
       static Widget optionWindow;

       // Define a structure for static callback data
       struct SnapshotDialogCBInfo {
	    SnapshotDialog *myObject;
	    void           *data;
       } ;

       SnapshotDialogCBInfo        callbackData;
       static SnapshotMode         snapshotMode;
       static SnapshotSelectOption snapshotSelectOption;
       static VoidPtrList *snapshotDataList,
                          *snapshotIconList, *snapshotIconLabelList,
                          *snapshotViewWindowList, *snapshotViewDismissList;

protected:
       /* Method _activatePictureCallback: 	Activates picture
	*					callback		*/
       void _activatePictureCallback( int snapshotIndex );

	/* Method _addCallback:		Adds picture callback		*/
       void _addCallback();

	/* Method _deleteCallback:	Deletes picture callback	*/
       void _deleteCallback();

	/* Method _dismissCallback:	Dismisses dialog		*/
       void _dismissCallback();

	/* Method _optionDismissCallback: Dismisses option dialog	*/
       void _optionDismissCallback();

	/* Method _optionCallback:	Invokes option callback		*/
       void _optionCallback( SnapshotOptionInfo *optionInfo );

	/* Method _optionsCallback:	Invokes configuration options
	*				callback			*/
       void _optionsCallback();

	/* Method _superCallback:	Invokes superposition callback	*/
       void _superCallback();

	/* Method _viewDismissCallback:	Dismisses view window		*/
       void _viewDismissCallback( int whichView );

       /* Method _generatePicture: Create an icon for this picture */
       Widget _generatePicture( const char *fuClass, const char *fuName );

       /* Method _packageWidget: 	Create snapshot image for a single 
	                          	widget within a functional unit	*/
       SnapshotWidgetInfo * _packageWidget( Widget subjectWidget,
					    Widget headWidget );

       /* Method _setCursor: Uses a special cursor to give the user a cue
	    about the state of snapshot operations */
       void _setCursor( int cursor );

       /* Method _setSnapshotMode:  Write a mode-specific string to the
	    user interface */
       void _setSnapshotMode( char *modeString );

       /* Method _staticActivateCallback: Callback for the activate-
	                                   snapshot feature */
       static void _staticActivateCallback( Widget w, 
					    XtPointer ptr1, XtPointer ptr2 );

       /* Method _staticAddCallback: Callback for the add-a-snapshot feature */
       static void _staticAddCallback(Widget w,XtPointer ptr1,XtPointer ptr2 );

       /* Method _staticDeleteCallback: Callback for the delete-a-snapshot
	    feature */
       static void _staticDeleteCallback( Widget w, XtPointer ptr1,
					  XtPointer ptr2);

       /* Method _staticSuperCallback: Callback for the superimpose-snapshots
            feature */
       static void _staticSuperCallback( Widget w, XtPointer ptr1,
					 XtPointer ptr2 );

       /* Method _staticOptionCallback: Callback for the snapshot 
	                                 individual option selection feature */
       static void _staticOptionCallback( Widget w, XtPointer ptr1,
					  XtPointer ptr2 );

       /* Method _staticOptionsCallback: Callback for the snapshot 
	                                       configuration options feature */
       static void _staticOptionsCallback(Widget w, XtPointer ptr1, 
					  XtPointer ptr2);

       /* Method _staticDismissCallback: Callback for the snapshot dialog
            dismiss button */
       static void _staticDismissCallback(Widget w, XtPointer ptr1,
					  XtPointer ptr2);

       /* Method _staticOptionDismissCallback: Callback the option dialog */
       static void _staticOptionDismissCallback( Widget w, XtPointer ptr1,
						 XtPointer ptr2 );

       /* Method _staticViewDismissCallback: Callback for the snapshot
	                                      viewing window */
       static void _staticViewDismissCallback( Widget w, XtPointer ptr1,
					       XtPointer ptr2 );

public:
       /* Method SnapshotDialog: The SnapshotDialog constructor */
       SnapshotDialog();

       /* Method ~SnapshotDialog: The SnapshotDialog destructor */
       ~SnapshotDialog();

       /* Method isCameraOn: Returns True if snapshot capability is 
	    ready; False otherwise */
       Boolean_ isCameraOn();

       /* Method realize: Makes visible the snapshot window */
       void realize();

       /* Method takeSnapshot: Captures the state of the given widget */
       void takeSnapshot( Widget subjectWidget, const char *fuClass,
			  const char *fuName );
};

#endif SnapshotDialog_h
