/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *               University of Illinois at Urbana-Champaign
 *               Department of Computer Science
 *               1304 W. Springfield Avenue
 *               Urbana, IL     61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *      All Rights Reserved.
 *
 * Author: Keith A. Shields (shields@cs.uiuc.edu)
 * 
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * RecordBindingDialog.h: Implements dialog for
 *                         binding input record fields to ports
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/RecordBindingDialog.h,v 1.9 1994/02/25 04:29:21 aydt Exp $
 */

#ifndef RecordBindingDialog_h
#define RecordBindingDialog_h

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Form.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/Frame.h>  
#include <Xm/ScrolledW.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>

#include "InterfaceClass.h"
#include "ConfigBoard.h"
#include "Callback.h"
#include "Pablo.h"
#include "Obj.h"
#include "ActionRecord.h"

#define NONE_SELECTED  -1
#define MODULE_RESULT  -1


typedef struct FieldEntry {char *fieldName; Boolean *isBoundToPort;
			   Boolean *isBoundToOutput;} FieldEntry;

typedef struct OutputPortEntry {char *outputPortName; 
				Boolean *isBoundToOutput;} OutputPortEntry;

typedef struct RecordEntry {char *recordName; ActionType status; 
			    int numFields; FieldEntry *fieldList;} RecordEntry;

typedef struct PortEntry {char *portName;} PortEntry;

typedef struct OutputEntry {char *outputName;} OutputEntry;

typedef struct PipeEntry {char *pipeName; int numRecords; 
			  RecordEntry *recordList;  int numPortsBoundTo;
			  PortEntry *portList; int numOutputsBoundTo;
			  OutputEntry *outputList;} PipeEntry;

typedef struct ModuleResultEntry {int numOutputPorts; 
				  OutputPortEntry *outputPortList;
				  int numOutputFieldsBoundTo;
				  OutputEntry *outputFieldList;} 
                                  ModuleResultEntry;

typedef struct RecordDisplayElements {Widget widgetContainer;
				      Widget copyThruLabel; 
				      Widget fieldExtractLabel;
				      Widget recordButton;} 
                                      RecordDisplayElements;
        

class RecordBindingDialog : public Obj, public virtual Callback {
/*
 * RecordBindingDialog implements a custom dialog for binding
 * input record fields to input ports and output record fields
 */

private:

  static const char *const MY_CLASS;  // my class name

  Boolean ModuleResultSelected,  DoneRunning;

  Colormap UnboundPortColorMap, UnboundOutputColorMap;

  ConfigBoard *StatusBoard;

  int CurrentFieldNum, CurrentPortNum, CurrentOutputNum, CurrentRecordIdx,
      CurrentPipeIdx;

  InterfaceClass *PabloInterface;

  ModuleResultEntry ModuleResult;

  PipeEntry *Pipes, *CurrentPipe; 

  Pixel UnboundPortBackground, UnboundOutputBackground;

  RecordDisplayElements *RecordWidgets;

  RecordEntry *CurrentRecord;

  Widget DialogShell, BindingClear, BindingDone, PipeFrame, RecordFrame,
         CopyDiscardFrame, FieldFrame, RecordContainer, FieldContainer, 
         PortContainer, OutputContainer, CurrentPipeNameLabel, 
         CurrentRecordNameLabel, ModuleResultButton, ContinueButton,
         *FieldButtons, *PortButtons, *OutputButtons;


  /* Method _allOutputsSatisfied: returns boolean value indicating if all 
  *    the output record fields that the given pipe is supposed to satisfy have
  *    been satisifed by the given record */
  Boolean _allOutputsSatisfied(int, int);

  /* Method _allPortsSatisfied: returns boolean value indicating if all 
  *    the input ports that the given pipe is supposed to satisfy have
  *    been satisifed by the given record */
  Boolean _allPortsSatisfied(int, int);

  /* Method _bindFieldToOutput: bind currently selected input record field 
  *            to the currently selected output record field */
  void _bindFieldToOutput(int, int);

  /* Method _bindFieldToPort: bind currently selected input record field to 
  *            the currently selected port */
  void _bindFieldToPort(int, int);

  /* Method _buildActionArea:  make action area of the dialog */
  void _buildActionArea(Widget);

  /* Method _buildBindingFrame:  setup area for scrolled region of
  *            of input ports and output fields that will be satisfied by the
  *            currently selected pipe */
  void _buildBindingFrame(Widget, Widget);

  /* Method _buildControlArea:  make control area of the dialog */
  void _buildControlArea(Widget);

  /* Method _buildCopyDiscardFrame:  setup area for copy through and 
               discard buttons */
  void _buildCopyDiscardFrame(Widget);

  /* Method _buildFieldFrame:  setup area for scrolled region of fields 
  *            that are on currently selected record */
  void _buildFieldFrame(Widget, Widget);

  /* Method _buildPipeFrame:  setup area for scrolled region of input pipes 
  *            that the current module has */
  void _buildPipeFrame(Widget, Widget);

  /* Method _buildRecordFrame:  setup area for scrolled region of records 
  *            that are on the currently selected pipe */
  void _buildRecordFrame(Widget, Widget);

  /* Method _checkForContinue: check to see if all ports and output fields
   *				have been satisfied so it is ok to allow the
   *				user to press Continue */
  void _checkForContinue();

  /* Method _clearAllBindingsForCurrentRecord: clear all bindings between
  *            fields of the current record and input ports/output record
  *       fields */
  void _clearAllBindingsForCurrentRecord();

  /* Method _clearFieldToOutputBinding: clear binding between the given input
  *            record field and output record field */
  void _clearFieldToOutputBinding(int, int);

  /* Method _clearFieldToPortBinding: clear binding between the given input
  *            record field and input port */
  void _clearFieldToPortBinding(int, int);

  /* Method _destroyChildren: destroy the children of the given parent
  *           widget */
  void _destroyChildren(Widget);

  /* Method _getUnboundOutputColors: get color properties of an unbound 
  *            output button so we know how to "clear" those buttons when 
  *       bindings are cleared */
  void _getUnboundOutputColors();

  /* Method _getUnboundPortColors: get color properties of an unbound port 
  *            button so we know how to "clear" those buttons when bindings are
  *       cleared */
  void _getUnboundPortColors();

  /* Method _makeFieldButton: make button for a specified field of the
  *            currently selected record */
  void _makeFieldButton(int, char*);

  /* Method _makeOutputButton: make button for a specified output record
  *            field that the currently selected pipe is bound to. */
  void _makeOutputButton(int, char*);

  /* Method _makePortButton: make button for a specified port that the
  *            currently selected pipe is bound to */
  void _makePortButton(int, char*);

  /* Method _makeRecordWidgets: make widgets for a specified record of the
  *            currently selected input pipe */
  void _makeRecordWidgets(int, char*, Widget);

  /* Method _setCurrentPipeLabel:  set the pipe name label to have the name
  *           of the currently selected pipe */
  void _setCurrentPipeLabel(char*);

  /* Method _setCurrentRecordLabel:  set the record name label to have the
  *           name of the currently selected record */
  void _setCurrentRecordLabel(char*);

  /* Method _setDialogTitle:  set the title for the dialog */
  void _setDialogTitle();

  /* Method _setupFieldBooleans:  initialize boolean arrays to indicate
  *            which input ports and output record fields satisfied by the
  *       given pipe are bound to the given field of the given record. */
  void _setupFieldBooleans(int, int, int);

  /* Method _setupFields:  make internal data structure entries for 
               the fields of the specified record on the specified pipe */
  void _setupFields(int, int);

  /* Method _setupModuleResultBindings:  make internal data structure 
               entries for  the output record fields bound to module results */
  void _setupModuleResultBindings();

  /* Method _setupOutputs:  make internal data structure entries for 
               the output record fields bound to the current pipe */
  void _setupOutputs(int);

  /* Method _setupPipes:  make buttons and internal data structure entries
               for the input pipes of this module */
  void _setupPipes(Widget);

  /* Method _setupPorts:  make internal data structure entries for 
               the input ports bound to the current pipe */
  void _setupPorts(int);

  /* Method _setupRecords: make internal data structure entries for 
               the input records of the specified pipe */
  void _setupRecords(int);

  /* Method _showAsBound: inidicate a binding by giving the destination
               widget the same color as the source widget */
  void _showAsBound(Widget, Widget);

  /* Method _showAsUnboundOutput: indicate a output field is unbound by
               giving the destination  widget the same color as an unbound 
	       output field */
  void _showAsUnboundOutput(Widget);

  /* Method _showAsUnboundPort: indicate a output field is unbound by
               giving the destination  widget the same color as an unbound 
	       output field */
  void _showAsUnboundPort(Widget);

  /* Method _updateRecordStatus: update the status of the given
               record */
  void _updateRecordStatus(int);

  /* Method _updateRecordStatusLabels: update the labels used to 
               display the status of the given record */
  void _updateRecordStatusLabels(int);


public:

  /* Method RecordBindingDialog:   the RecordBindingDialog 
              constructor */
  RecordBindingDialog(Widget, InterfaceClass*, ConfigBoard*);

  /* Method ~RecordBindingDialog:   the RecordBindingDialog 
               destructor */
  ~RecordBindingDialog();

  /* Method callback1: callback called when an input pipe button is pressed */
  virtual void callback1(Widget, XtPointer, XtPointer);

  /* Method callback2: callback called when an record button is selected */
  virtual void callback2(Widget, XtPointer, XtPointer);

  /* Method callback3: callback called when an input record field button is 
              selected */
  virtual void callback3(Widget, XtPointer, XtPointer);

  /* Method callback4: callback called when a port button is selected */
  virtual void callback4(Widget, XtPointer, XtPointer);

  /* Method callback5: callback called when an output field button is
             selected */
  virtual void callback5(Widget, XtPointer, XtPointer);

  /* Method callback6: callback called when binding done button is pressed */
  virtual void callback6(Widget, XtPointer, XtPointer);

  /* Method callback7: callback called when binding clear is selected */
  virtual void callback7(Widget, XtPointer, XtPointer);

 /* Method callback8: callback called when continue is selected */
  virtual void callback8(Widget, XtPointer, XtPointer);

  /* Method callback9: callback called when reset is selected */
  virtual void callback9(Widget, XtPointer, XtPointer);

  /* Method callback10: callback called when module result is selected */
  virtual void callback10(Widget, XtPointer, XtPointer);

  /* Method callback11: callback called when copy thru is selected */
  virtual void callback11(Widget, XtPointer, XtPointer);

  /* Method callback12: callback called when discard is selected */
  virtual void callback12(Widget, XtPointer, XtPointer);

  /* Method helpCallback: callback called when help is selected */
  virtual void helpCallback(Widget, XtPointer, XtPointer);

  /* Method run: popup an instance of this dialog */
  void run();
};

#endif










