/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#ifndef PabloResources_h
#define PabloResources_h

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

/***************************** R e s o u r c e s *****************************/

#define	XtNmoduleForeground "moduleForeground"
#define XtCModuleForeground "ModuleForeground"
#define XtNmoduleBackground "moduleBackground"
#define XtCModuleBackground "ModuleBackground"

#define XtNrunStepSize "runStepSize"
#define XtCRunStepSize "RunStepSize"

#define XtNdefaultConfigFileDir "defaultConfigFileDir"
#define XtCDefaultConfigFileDir "DefaultConfigFileDir"

#define XtNdefaultDataFileDir "defaultDataFileDir"
#define XtCDefaultDataFileDir "DefaultDataFileDir"

#define XtNdefaultHelpFileDir "defaultHelpFileDir"
#define XtCDefaultHelpFileDir "DefaultHelpFileDir"

#define XtNconsoleLog "consoleLog"
#define XtCConsoleLog "ConsoleLog"

#define XtNroundNodes "roundNodes"
#define XtCRoundNodes "RoundNodes"

#define	XtNeventInterval	"eventInterval"
#define XtCEventInterval        "EventInterval"

#define XtNtimeInterval        "timeInterval"
#define XtCTimeInterval        "TimeInterval"

#define XtNmaxTimeInterval	"maxTimeInterval"
#define XtCMaxTimeInterval      "MaxTimeInterval"

#define XtNmaxEventInterval	"maxEventInterval"
#define XtCMaxEventInterval     "MaxEventInterval"

#define XtNrestartReuseInfile	"restartReuseInfile"	
#define	XtCRestartReuseInfile	"RestartReuseInfile"

#define XtNrestartReuseOutfile	"restartReuseOutfile"	
#define	XtCRestartReuseOutfile	"RestartReuseOutfile"

#define XtNrestartClearModules	"restartClearModules"
#define	XtCRestartClearModules	"RestartClearModules"

#define XtNdisplayBytesProcessed	"displayBytesProcessed"
#define XtCDisplayBytesProcessed	"DisplayBytesProcessed"

#define XtNverifyDeleteGraph	"verifyDeleteGraph"
#define XtCVerifyDeleteGraph	"VerifyDeleteGraph"

#define XtNanimateGraph		"animateGraph"	
#define	XtCAnimateGraph		"AnimateGraph"

typedef struct {
	int runStepSize;
	String defaultConfigFileDir;
	String defaultDataFileDir;
	String defaultHelpFileDir;
	String consoleLog;
	Boolean roundNodes;
	int	eventInterval;
	int	maxEventInterval;
	int	timeInterval;
	int	maxTimeInterval;
	Boolean	restartReuseInfile;
	Boolean	restartReuseOutfile;
	Boolean	restartClearModules;
	Boolean	displayBytesProcessed;
	Boolean	verifyDeleteGraph;
	Boolean	animateGraph;
} PabloData, *PabloDataPtr;


extern PabloData pabloData;

static XtResource resources[] = {
{
	XtNrunStepSize,
	XtCRunStepSize,
	XtRInt,
	sizeof(int),
	XtOffset(PabloDataPtr, runStepSize),
	XtRImmediate,
	(caddr_t) 100,
},
{
	XtNdefaultConfigFileDir,
	XtCDefaultConfigFileDir,
	XtRString,
	sizeof(String),
	XtOffset(PabloDataPtr, defaultConfigFileDir),
	XtRString,
	(caddr_t) "",
},
{
	XtNdefaultDataFileDir,
	XtCDefaultDataFileDir,
	XtRString,
	sizeof(String),
	XtOffset(PabloDataPtr, defaultDataFileDir),
	XtRString,
	(caddr_t) "",
},
{
	XtNdefaultHelpFileDir,
	XtCDefaultHelpFileDir,
	XtRString,
	sizeof(String),
	XtOffset(PabloDataPtr, defaultHelpFileDir),
	XtRString,
	(caddr_t) "",
},
{
	XtNroundNodes,
	XtCRoundNodes,
	XtRBoolean,
	sizeof(Boolean),
	XtOffset(PabloDataPtr, roundNodes),
	XtRString,
	(caddr_t) "TRUE",
},
{
	XtNconsoleLog,
	XtCConsoleLog,
	XtRString,
	sizeof(String),
	XtOffset(PabloDataPtr, consoleLog),
	XtRString,
	(caddr_t) "",
},
{
	XtNeventInterval,
	XtCEventInterval,
        XtRInt,
        sizeof(int),
        XtOffset(PabloDataPtr, eventInterval),
        XtRImmediate,
        (caddr_t) 100,
},
{
        XtNtimeInterval,
        XtCTimeInterval,
        XtRInt,
        sizeof(int),
        XtOffset(PabloDataPtr, timeInterval),
        XtRImmediate,
        (caddr_t) 100,
},
{
        XtNmaxEventInterval,
        XtCMaxEventInterval,
        XtRInt,
        sizeof(int),
        XtOffset(PabloDataPtr, maxEventInterval),
        XtRImmediate,
        (caddr_t) 1000,
},
{
        XtNmaxTimeInterval,
        XtCMaxTimeInterval,
        XtRInt,
        sizeof(int),
        XtOffset(PabloDataPtr, maxTimeInterval),
        XtRImmediate,
        (caddr_t) 1000,
},
{
        XtNrestartReuseInfile,
        XtCRestartReuseInfile,
        XtRBoolean,
        sizeof(Boolean),
        XtOffset(PabloDataPtr, restartReuseInfile),
        XtRString,
        (caddr_t) "TRUE",
},
{
        XtNrestartReuseOutfile,
        XtCRestartReuseOutfile,
        XtRBoolean,
        sizeof(Boolean),
        XtOffset(PabloDataPtr, restartReuseOutfile),
        XtRString,
        (caddr_t) "TRUE",
},
{
        XtNrestartClearModules,
        XtCRestartClearModules,
        XtRBoolean,
        sizeof(Boolean),
        XtOffset(PabloDataPtr, restartClearModules),
        XtRString,
        (caddr_t) "TRUE",
},
{
        XtNdisplayBytesProcessed,
        XtCDisplayBytesProcessed,
        XtRBoolean,
        sizeof(Boolean),
        XtOffset(PabloDataPtr, displayBytesProcessed),
        XtRString,
        (caddr_t) "TRUE",
},
{
        XtNverifyDeleteGraph,
        XtCVerifyDeleteGraph,
        XtRBoolean,
        sizeof(Boolean),
        XtOffset(PabloDataPtr, verifyDeleteGraph),
        XtRString,
        (caddr_t) "TRUE",
},
{
        XtNanimateGraph,
        XtCAnimateGraph,
        XtRBoolean,
        sizeof(Boolean),
        XtOffset(PabloDataPtr, animateGraph),
        XtRString,
        (caddr_t) "FALSE",
},
};

static XrmOptionDescRec options[] = {
{ "-runStepSize", "*runStepSize", XrmoptionSepArg, NULL },
{ "-defaultConfigFileDir", "*defaultConfigFileDir", XrmoptionSepArg, NULL },
{ "-defaultDataFileDir", "*defaultDataFileDir", XrmoptionSepArg, NULL },
{ "-defaultHelpFileDir", "*defaultHelpFileDir", XrmoptionSepArg, NULL },
{ "-consoleLog", "*consoleLog", XrmoptionSepArg, NULL },
{ "-roundNodes", "*roundNodes", XrmoptionNoArg, "TRUE" },
{ "+roundNodes", "*roundNodes", XrmoptionNoArg, "FALSE" },
{ "-eventInterval", "*eventInterval", XrmoptionSepArg, NULL },
{ "-timeInterval", "*timeInterval", XrmoptionSepArg, NULL },
{ "-maxEventInterval", "*maxEventInterval", XrmoptionSepArg, NULL },
{ "-maxTimeInterval", "*maxTimeInterval", XrmoptionSepArg, NULL },
{ "-restartReuseInfile", "*restartReuseInfile", XrmoptionNoArg, "TRUE" },
{ "+restartReuseInfile", "*restartReuseInfile", XrmoptionNoArg, "FALSE" },
{ "-restartReuseOutfile", "*restartReuseOutfile", XrmoptionNoArg, "TRUE" },
{ "+restartReuseOutfile", "*restartReuseOutfile", XrmoptionNoArg, "FALSE" },
{ "-clearModules", "*clearModules", XrmoptionNoArg, "TRUE" },
{ "+clearModules", "*clearModules", XrmoptionNoArg, "FALSE" },
{ "-displayBytesProcessed", "*displayBytesProcessed", XrmoptionNoArg, "TRUE" },
{ "+displayBytesProcessed", "*displayBytesProcessed", XrmoptionNoArg, "FALSE" },
{ "-verifyDeleteGraph", "*verifyDeleteGraph", XrmoptionNoArg, "TRUE" },
{ "+verifyDeleteGraph", "*verifyDeleteGraph", XrmoptionNoArg, "FALSE" },
{ "-animate", "*animateGraph", XrmoptionNoArg, "TRUE" },
};

inline int
numPabloResources()
{
	return XtNumber( resources );
}

inline int
numPabloOptions()
{
	return XtNumber( options );
}

#endif
