/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *               University of Illinois at Urbana-Champaign
 *               Department of Computer Science
 *               1304 W. Springfield Avenue
 *               Urbana, IL     61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *      All Rights Reserved.
 *
 * Author: Keith A. Shields (shields@cs.uiuc.edu)
 * 
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * OutputSpecificationDialog.h: Implements a custom dialog for
 *                             specifiying output record fields and binding
 *                             them to input pipes
 * 
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/OutputSpecificationDialog.h,v 1.8 1994/02/25 04:29:20 aydt Exp $
 */

#ifndef OutputSpecificationDialog_h
#define OutputSpecificationDialog_h

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Form.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/List.h>
#include <Xm/Frame.h>  
#include <Xm/TextF.h>  
#include <Xm/Label.h>
#include <Xm/ScrolledW.h>
#include <Xm/RowColumn.h>

#include "InterfaceClass.h"
#include "ConfigBoard.h"
#include "Callback.h"
#include "Obj.h"
#include "Pablo.h"

typedef struct OutputFieldEntry {char *outputFieldName;} OutputFieldEntry;

typedef struct PipeBindingInfo {int numOutputFieldsSatisfied;
				OutputFieldEntry *outputFieldList;} 
                                PipeBindingInfo;

#define NONE_SELECTED  -1
#define MODULE_RESULT  -1

class OutputSpecificationDialog : public Obj, public virtual Callback {
/*
* OutputSpecificationDialog implements a custom dialog for
* specifiying output record fields and binding them to input pipes.
* This code is used during analysis graph configuration.
*/

private:  

  static const char *const MY_CLASS;  // my class name

  Boolean ModuleResultSelected, DoneRunning;

  ConfigBoard * StatusBoard;

  int CurrentPipeIndex, TotalNumOutputFields;

  InterfaceClass * PabloInterface;

  PipeBindingInfo * Pipes, ModuleResultBinding;

  Widget DialogShell, PipeFrame, OutputFrame, RecordNameEditingFrame,
         RecordNameTextField, FieldEditingFrame, FieldNameTextField, 
	 OutputList, PipeNameLabel, ContinueButton, ResetButton;


  /* Method _buildActionArea:  make action area of the dialog */
  void _buildActionArea( Widget );

  /* Method _buildControlArea:  make control area of the dialog */
  void _buildControlArea( Widget );

  /* Method _isFieldNameValid: determine if the given field name
  *    is a valid name for a output record field */
  Boolean _isFieldNameValid( char * );

  /* Method _isOutputFieldUnique: determine if the given output field name
  *    is already used in the output record */
  Boolean _isOutputFieldUnique( char * );

  /* Method _makeFieldEditingFrame:  setup area for output fields to
  *            be named, added, and deleted */
  void _makeFieldEditingFrame( Widget );

  /* Method _makeOutputFieldFrame:  setup area for scrolled list of output
  *            record fields bound to the currently selected pipe */
  void _makeOutputFieldFrame( Widget, Widget );

  /* Method _makePipeFrame:  setup area for scrolled list of input pipes,
  *            user input, and module result buttons */
  void _makePipeFrame( Widget );

  /* Method _makeRecordNameEditingFrame:  setup area for output record 
  *            name to be edited */
  void _makeRecordNameEditingFrame( Widget, Widget );

  /* Method _setDialogTitle:  set the title for the dialog */
  void _setDialogTitle();

  /* Method _setupModuleResultBindings:  initialize internal data structure
  *            representing module results and the module output record 
  *       fields bound to them */
  void _setupModuleResultBindings();

  /* Method _setupOutputFieldBindings:  initialize internal data structure
  *            representing pipes and the output record fields bound to them */
  void _setupOutputFieldBindings( int );

  /* Method _setupPipes:  create buttons for input pipes */
  void _setupPipes(Widget);


public:

  /* Method OutputSpecificationDialog:   the OutputSpecificationDialog 
  *           constructor */
  OutputSpecificationDialog(Widget, InterfaceClass*, ConfigBoard*);

  /* Method ~OutputSpecificationDialog:   the OutputSpecificationDialog 
  *            destructor */
  ~OutputSpecificationDialog();

  /* Method callback1: callback called when continue is selected */
  virtual void callback1(Widget, XtPointer, XtPointer);

  /* Method callback2: callback called when reset is selected */
  virtual void callback2(Widget, XtPointer, XtPointer);

  /* Method callback3: callback called when a pipe is selected */
  virtual void callback3(Widget, XtPointer, XtPointer);

  /* Method callback4: callback called when module result is selected */
  virtual void callback4(Widget, XtPointer, XtPointer);

  /* Method callback5: callback called when output list item is selected */
  virtual void callback5(Widget, XtPointer, XtPointer);

  /* Method callback6: callback called when add list item is selected */
  virtual void callback6(Widget, XtPointer, XtPointer);

  /* Method callback7: callback called when delete list item is selected */
  virtual void callback7(Widget, XtPointer, XtPointer);

  /* Method callback8: callback called when done w/ output field binding for a
  *           particular pipe is selected */
  virtual void callback8(Widget, XtPointer, XtPointer);

  /* Method callback9: callback called when reset output field binding for a
  *           particular pipe is selected */
  virtual void callback9(Widget, XtPointer, XtPointer);

  /* Method helpCallback: callback called when help is selected */
  virtual void helpCallback(Widget, XtPointer, XtPointer);

  /* Method run: popup an instance of this dialog */
  void run();
};

#endif










