/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * HistoryMathFU.h: A polymorphic functional unit for historical
 * mathematical operations (i.e., the output depends on earlier inputs).
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/HistoryMathFU.h,v 1.12 1994/03/15 16:25:40 aydt Exp $
 */

#ifndef HistoryMathFU_h
#define HistoryMathFU_h

#include "CStringObjList.h"
#include "FunctionalUnit.h"
#include "Value.h"

class MathOperation;
class InputPort;
class OutputPort;

class HistoryMathFU : public FunctionalUnit {
/*
* The History Math FU takes as input either array or scalar values and 
* produces a scalar output value which is the sum, minimum, maximum, or 
* count of all the values seen so far. If the input is an array, each cell is
* treated as a separate value when computing the sum, max, min, or count.
*/

enum HistoryMathOperations { ACCUMULATE, MINIMUM, MAXIMUM, COUNT };

private:
	static const char *const MY_CLASS;	// My class name
        static CStringObjList    BinaryOpNameList;

	InputPort	*operand;
	OutputPort	*result;

	Value		resultV;
	Value		oldV;

	MathOperation	*myOperator;
        int             myOperatorNumber;

        Boolean_        isReady;

        /* Method _setOperator:   	Set history operator to use      */
        virtual void _setOperator( const int opId );

public:
	/* Method HistoryMathFU: 	The HistoryMathFU constructor	 */
	HistoryMathFU();

	/* Method ~HistoryMathFU:	The HistoryMathFU destructor 	 */
	~HistoryMathFU();

        /* Method configureOperation:   Configure the operation          */
        virtual void configureOperation();

	/* Method copy:			Copy this functional unit	 */
	virtual FunctionalUnit * copy();

	/* Method init:			Initialize the functional unit	 */
	virtual void init();

	/* Method inputTraitsValid:	Verify that the input traits are
	*			  	acceptable and set the traits of
	*				the result.			 */
	virtual Boolean_ inputTraitsValid();

        /* Method loadConfigFromFile:   Load configuration from a file   */
        virtual Boolean_ loadConfigFromFile( const CString& fileName );

	/* Method ready: 		Returns TRUE_ if the functional
	*				unit is currently executable	 */
	virtual Boolean_ ready();

	/* Method run:			Execute the functional unit	 */
	virtual void run( Boolean_& errorFlag );

       /* Method saveConfigToFile:     	Save configuration to a file     */
        virtual Boolean_ saveConfigToFile( const CString& fileName ) const;

};

#endif HistoryMathFU_h
