/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613 DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * GraphNode.h: Maintains and displays a node on the execution graph.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/GraphNode.h,v 1.13 1994/02/25 04:29:07 aydt Exp $
 *	
 */
#ifndef GraphNode_h
#define GraphNode_h

#include "ShapedLabel.h"

class GraphEdge;
class GraphEdgePtrList;

class GraphNode : public ShapedLabel {
/*
 * Class to handle the creation and placement of nodes in the execution
 * graph.
 */

private:
	CString          nodeName;
	GraphEdgePtrList *incomingEdges;
	GraphEdgePtrList *outgoingEdges;
	
	/* Method _beginMotion:		Initiate a move of the node by 
	*				unmanaging edges                      */
	void _beginMotion();

	/* Method _endMotion:		Finish a move of the node by resetting
	*				edge locations and managing edges     */
	void _endMotion();

	/* Method _setupHandlers:	Set up our event handlers.            */
	void _setupHandlers();

protected:
	/* Method setupShape:		Overloads ShapedLabel setupShape      */
	virtual void setupShape();

public:
	/* Method GraphNode:		The constructor 		      */
	GraphNode( WidgetBase *par, const XArgs& args, const CString& name );

	/* Method ~GraphNode:		The destructor                        */
	~GraphNode();

	/* Method addIncomingEdge:	Add an edge coming into node          */
	void addIncomingEdge( GraphEdge *edge );

	/* Method addOutgoingEdge:	Add an edge leaving the node          */
	void addOutgoingEdge( GraphEdge *edge );

	/* Method deleteOutgoingEdge:	Delete the edge from the list of
	*				outgoing edges                        */
	void deleteOutgoingEdge( GraphEdge *edge );

	/* Method getBottomCenter:	Get position of node bottom center    */
	void getBottomCenter( Position *x, Position *y );

	/* Method getNodeName:		Return the name of the node	      */
	const CString& getNodeName() const;

	/* Method getTopCenter:		Get position of node top center       */
	void getTopCenter( Position *x, Position *y );

	/* Method moveTo:		Move the node to the specified (x,y)  */
	void moveTo( Position x, Position y);

	/* Method eventHandler1:	Overloaded handler for press events   */
	virtual void eventHandler1( Widget w, XtPointer clientData, 
				    XEvent *event, Boolean *continueToDisptch );

	/* Method eventHandler2:	Overloaded handler for motion events  */
	virtual void eventHandler2( Widget w, XtPointer clientData, 
				    XEvent *event, Boolean *continueToDisptch );

	/* Method eventHandler3:	Overloaded handler for release events */
	virtual void eventHandler3( Widget w, XtPointer clientData, 
				    XEvent *event, Boolean *continueToDisptch );

};

inline const CString&
GraphNode::getNodeName() const
{
	return nodeName;
}

#endif
