/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613 DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * GraphDisplay.h: Implements display of nodes and edges. 
 *	
 */
#ifndef GraphDisplay_h
#define GraphDisplay_h

#include <stdio.h>

#include "GraphNodePtrList.h"
#include "WidgetBase.h"

class GraphNode;
class InfrastructureManager;

class GraphDisplay : public WidgetBase {
/*
 * GraphDisplay manages the analysis module palette that shows
 * all the interconnected analysis modules.
 */

private:
	int xLoc;
	int yLoc;

	WidgetBase 		*backdrop;
	GraphNodePtrList 	*nodes;

public:
        /* Method GraphDisplay: 	The GraphDisplay constructor.         */
	GraphDisplay( WidgetBase *par );

        /* Method ~GraphDisplay: 	The GraphDisplay destructor.          */
	~GraphDisplay();

	/* Method addEdge:		Add an edge connection the two nodes
	*				whose indices are given.              */
	void addEdge( int fromNode, int toNode );

	/* Method addNode:		Add a node with the given name. Return
	*				the index of the node in the list of
	*				nodes.                                */
	int addNode( const CString& name );

	/* Method containsNode:		Returns TRUE_ if the named node exists 
	*				in the graph.                         */
	Boolean_ containsNode( const CString& name ) const;

	/* Method deleteNode:		Delete the indicated node and any 
	*				incoming edges.                       */
	void deleteNode( int nodeIndex );

	/* Method getNodeIndex:		Return the index of the specified
	*				GraphNode in the list of nodes.       */
	int getNodeIndex( GraphNode *nodePtr ) const;

	/* Method moveNode:		Move the named node to the new (x,y)
	*				location.                             */
	void moveNode( const CString& name, int x, int y );

	/* Method nodeCount:		Returns the number of nodes in the 
	*				Graph.                                */
	int nodeCount() const;

	/* Method reset:		Delete any nodes and edges and reset
	*				the state to what it was just after
	*				the GraphDisplay was constructed.     */
	void reset();

	/* Method writeLayoutToFP:	Write the locations of the nodes to
	*				the specified file.                   */
	Boolean_ writeLayoutToFP( FILE *fp ) const;

};

inline int 
GraphDisplay::nodeCount() const
{
	return nodes->count();
}

#endif
