/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * Author: Robert Olson (olson@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * FileOutputWrapper.h: The class which handles writing SDDF output to files.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/FileOutputWrapper.h,v 1.16 1994/03/15 16:27:40 aydt Exp $
 */
#ifndef FileOutputWrapper_h
#define FileOutputWrapper_h

#include "Wrapper.h"

#include "PacketHeader.h"
#include "StreamPipe.h"

class BinaryPipeReader;
class OutputFileStreamPipe;
class PipeWriter;

class FileOutputWrapper : public Wrapper {
/*
 * This class is derived from Wrapper and handles the writing of output
 * seen on an input pipe to an output SDDF file.
 */
private:
	static const char *const MY_CLASS;      	// My class name

	CString 		 filename;		// file we are writing
	StreamPipe 		 *inputPipe;		// pipe we read from
	BinaryPipeReader	 *pipeReader;		// reader we use
	PabloSddfType 		 outputType;		// type of output file
	OutputFileStreamPipe 	 *outputPipeToFile;	// output pipe
	PipeWriter               *pipeWriter;		// writer we use
	ModuleId		 *sourceModule;		// what writes to us
	PacketHeader		 currentHeader;		// Current packet header

public:
//      ***** Constructors and Destructors *****

        /* Method FileOutputWrapper: 		The constructor.              */
	FileOutputWrapper( const CString& fileName ) ;

        /* Method ~FileOutputWrapper: 		The destructor.               */
	~FileOutputWrapper();

//      ***** Virtual Functions *****

	/* Method addInputPipe:			Connect an input pipe to the
	*					module and create a pipeReader.
	*					Only one allowed per module.  */
	virtual Boolean_ addInputPipe( StreamPipe *pipe, ModuleId *source );

	/* Method addOutputPipe:		No output pipes can be 
	*					connected to Wrappers of this 
	*					type. Always returns FAILURE_ */
	virtual Boolean_ addOutputPipe( StreamPipe *pipe ) ;

	/* Method deleteOutputPipe:		Do nothing - no output pipes  */
	virtual void deleteOutputPipe( StreamPipe * /* pipe */ ) {
		} ;

	/* Method configure:			Asks filename & opens file    */
	virtual void configure( Boolean_ singleModule ) ;

        /* Method getWrapperClass:              Returns the class of the
        *                                       Wrapper instance for which it
        *                                       is called.                    */
        virtual WrapperClass getWrapperClass() const {
                return FileOutputWrapperClass;
                } ;

	/* Method init:				Initialize Wrapper state.     
	*					inputPipe and pipeReader are 
	*					NOT reset.                    */
	virtual void init();

	/* Method loadConfigurationFromDir:	'dir' argument isn't actually
	*					used.  This calls the init() 
	*					and configure() methods.      */
	virtual Boolean_ loadConfigurationFromDir( const CString &dir,
						   int moduleIndex );

	/* Method ready:			Returns TRUE_ if there is data
	*					on the input pipe.            */
	virtual Boolean_ ready();

        /* Method restart:                      Closes and reopens the data file
        *                                       associated with the module.   */
        virtual void restart();

	/* Method run:				Processes all packets in the
	*					input pipe, writing them to
	*					the output file. errorFlag is
	*					set if an error is seen while
	*					running.                      */
	virtual void run( Boolean_& errorFlag );

	/* Method writeLayoutToFP:	        Write line for this module to
	*					Layout file.                  */
  	virtual void writeLayoutToFP( FILE *fp ) const;

//      ***** Functions Defined for all Classes *****

	/* Method printOn: Stream output function */
	void printOn( ostream& os = cout ) const;
};

//      ***** General Operators *****

inline ostream& operator<<( ostream& os, FileOutputWrapper& obj )
{
	obj.printOn( os );
	return os;
}

#endif
