/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Philip C. Roth (proth@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * EventNode.h: Nodes in list of busy processor time intervals
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/EventNode.h,v 1.9 1994/02/25 04:31:41 aydt Exp $
 */
#ifndef EventNode_h
#define EventNode_h

#include "Defines.h"
#include "ListNode.h"

enum BusyStatus { idleState, busyState };

class EventNode : public ListNode {
/*
 * EventNode represents lists of trigger trace events
 * waiting to be processed.
 */

private:
	double	beginTS;	// interval beginning timestamp
	double	endTS;		// interval ending timestamp
	BusyStatus *states;	// array of PE states


public:

	/* Method EventNode:		The class constructor		*/
	EventNode( EventNode*, int, int, BusyStatus = busyState );


	/* Method ~EventNode:		The class destructor		*/
	//
	~EventNode( void );


	/* Method getBeginTS:		Gets the beginning timestamp
	*				of this interval		*/
	double getBeginTS( void );

	/* Method setBeginTS:		Sets the beginning timestamp
	*				of this interval		*/
	void setBeginTS( double );


	/* Method getEndTS:		Gets the ending timestamp of
	*				this interval			*/
	double getEndTS( void );

        /* Method setEndTS:             Sets the ending timestamp of
        *                               this interval                   */
	void setEndTS( double );


	/* Method getRange:		Returns the range of time
	*				represnted by the interval	*/
	double getRange( void );


	/* Method getStates:		Gets array of states for
	*				this interval			*/
	BusyStatus * getStates( void );

       /* Method setStates:             Sets array of states for
        *                               this interval                   */
	void setStates( BusyStatus *s );

	/* Method insertAfter:		Insert ``this'' to the given list
	*				after the given node		*/
	void insertAfter( ListNode *node );
};

inline double
EventNode::getBeginTS( void )
{ 
	return beginTS;
}

inline double
EventNode::getEndTS( void )
{ 
	return endTS;
}

inline double
EventNode::getRange( void )
{ 
	if ( endTS >= 0 ) {
	        return( endTS - beginTS );
	} else {
		return -1;
	}
}

inline BusyStatus *
EventNode::getStates( void )
{ 
	return states;
}

inline void
EventNode::insertAfter( ListNode *node )
{ 
	next = node->getNextInList();
	node->setNextInList( this );
}

inline void
EventNode::setBeginTS( double b )
{ 
	beginTS = b;
}

inline void
EventNode::setEndTS( double e )
{ 
	endTS = e;
}

inline void
EventNode::setStates( BusyStatus *s )
{
	states = s;
}

#endif EventNode_h

