/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * DefaultsDialog.h: Implements a configuration dialog for Pablo defaults
 * 		     not related to graph execution.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/DefaultsDialog.h,v 1.10 1994/02/25 04:31:14 aydt Exp $	
 */

#ifndef DefaultsDialog_h
#define DefaultsDialog_h

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/PushBG.h>
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleBG.h>

#include "Obj.h"
#include "Pablo.h"
#include "PabloResources.h"

class DefaultsDialog : public Obj {
/*
 * 	The defaults dialog provides a simple, user configurable interface
 *	that allows users to specify defaults for the current execution
 *	of a Pablo graph.
 */
private:
	static const char *const MY_CLASS;
	static PabloMainInterface *pabloMainInterface;

	Boolean_ isManaged;

protected:
	Widget	defaultsDialog; 
	Widget	dialogPane;
	Widget	controlArea;
     	Widget	actionArea;

        Widget	cancelButton;
   	Widget	okButton;
   	Widget	helpButton;

	Widget	defaultBox;

        Widget	configText;
        Widget	dataText;
        Widget	logText;
	Widget  bytesProcessedButton;
	Widget  verifyDeleteGraphButton;

	Widget  infileButton;
	Widget  outfileButton;
	Widget  moduleClearButton;
        Widget	animateButton;

        /* Method _staticCancelCallback:	the static interface to the
        *                               	dynamic callback for the 
	*					"Cancel" button 	      */
        static void _staticCancelCallback( Widget w,
                                        XtPointer clData, XtPointer caData );

        /* Method _staticOkCallback:		the static interface to the
        *                               	dynamic callback for the "Ok"
        *                               	button in this dialog         */
        static void _staticOkCallback( Widget w,
                                        XtPointer clData, XtPointer caData );

        /* Method _staticHelpCallback:		the static interface to the
        *                               	dynamic callback for the "Help"
        *                               	button in this dialog         */
        static void _staticHelpCallback( Widget w,
                                        XtPointer clData, XtPointer caData );

	/* Method _cancelCallback:	invoked when the user wishes to
	*				exit the configuration process without
	*				changing any of the existing defaults */
        void _cancelCallback();

	/* Method _helpCallback:	invoked to provide help on the process
	*				of configuring default values	      */
        void _helpCallback( char* topic );

	/* Method _okCallback:		invoked when the user wishes to exit
	*				the configuration process and update
	*				the existing defaults		      */
        void _okCallback();

public:
	/* Method DefaultsDialog:	the dialog constructor		      */
	DefaultsDialog( PabloMainInterface *createdBy );

	/* Method ~DefaultsDialog:	the dialog destructor		      */
	~DefaultsDialog();

	/* Method raiseDialog:		Activates the dialog by managing it   */
	void raiseDialog();

	/* Method printOn:	stream output function			      */
	void printOn( ostream &os = cout ) const ;
};

inline ostream &operator<<( ostream &os, DefaultsDialog &obj )
{
	obj.printOn(os);
	return os;
}

#endif
