/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * ConfigBoard.h:   This module implements the configuration binding rule
 *                    "scoreboard"
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/ConfigBoardDetail.h,v 1.7 1994/02/25 04:29:15 aydt Exp $	
 */

#ifndef ConfigBoardDetail_h
#define ConfigBoardDetail_h

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/List.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/Separator.h>
#include <Xm/TextF.h>

#include "Callback.h"
class CString;
class VoidPtrList;
class IntList;
class InterfaceClass;

typedef enum { FE_INPUT_PORT, FE_OUTPUT_FIELD, FE_NOT } RecordBrowseState;


class ConfigBoardDetail : public virtual Callback {
/*
* ConfigBoardDetail shows detailed datatype information for the
* ports of a functional unit that have previously been bound.
*/

private:
        InterfaceClass *interfaceClass;
        Widget detailShell;
	Widget detailDescriptor;
	Widget detailScrolledList1, detailScrolledList2;
        Widget detailNameText, detailTypeText;
	
	int numberInputPipes;
	int numberInputPorts;
	int numberOutputFields;
	int currentlySelectedPipe,
            currentlySelectedPort, currentlySelectedField;

	VoidPtrList *boundRecordsForOutputField, *boundFieldsForOutputField;
        VoidPtrList *boundRecordsForInputPort, *boundFieldsForInputPort;
	RecordBrowseState recordBrowseState;

	/* Method _createListArea:   Build a scrolled list of text fields
	                             and associated annotations */
	Widget _createListArea( Widget scrolledListParent,
			        Widget scrolledListAttachment,
			        Widget& scrolledList,
			        CString widgetNamePrefix );

        /* Method _fillFieldScrollBasedOnPipeOnly:  Fill a field scroll
	             list for either input ports or output fields based
		     just on the input pipe that thing is bound to */
        void _fillFieldScrollBasedOnPipeOnly( int recordIndex );

	/* Method _fillRecordScrollBasedOnPipeOnly:  Fill a record scroll
	             list for either input ports or output fields based
		     just on the input pipe that thing is bound to */
	void _fillRecordScrollBasedOnPipeOnly( int inputPipeNumber );

	/* Method _fillScrolledListWithEntry:  Fill one of the two
	           detail scrolled windows with a list of strings stored
                   in a VoidPtrList */
        void _fillScrolledListWithEntry( Widget scrolledList,
					 char *fieldName, int index );

	/* Method _fillScrolledListWithEntryList:  Fill a detail scrolled
	           window with a list of strings */
	void _fillScrolledListWithEntryList( Widget scrolledList,
					     VoidPtrList *stringList );

	/* Method _isADuplicatePipePortRecordExtract:  Determines if the current
	           field extraction record has already been extracted */
	int _isADuplicatePipePortRecordExtract( int portNumber,
					        const char *recordName );

	/* Method _setupDetailControlArea:  Create the widgets associated
	                               with the detail control buttons */
	void _setupDetailControlArea( Widget detailMainWindow,
				      Widget topAttachmentWidget );

	/* Method _setupDetailHeader:  Create the widgets associated with
	                               the detail header information */
	Widget _setupDetailHeader( Widget detailMainWindow ); 	

	/* Method _setupDetailLineInformation:  Create the widgets associated
	              with the single-line header information fields */
	Widget _setupDetailLineInformation( Widget detailMainWindow,
					    Widget topAttachmentWidget );

	/* Method _setupDetailScrolledLists:  Create the widgets associated
	               with the dual scrolled lists */
	Widget _setupDetailScrolledLists( Widget detailMainWindow,
				        Widget topAttachmentWidget );


        /* Method _setupRecordFieldDatabase:  Initialize data structures 
	               used in record/field binding bookkeeping */
	void _setupRecordFieldDatabase();

public:
        /* Method ConfigBoardDetail:   The ConfigBoardDetail constructor */
        ConfigBoardDetail( Widget boardMainWindow, 
			   InterfaceClass *interfaceClassIn );

	/* Method ~ConfigBoardDetail:   The ConfigBoardDetail destructor */
        ~ConfigBoardDetail();

	/* Method callback1:  Scrolled List selection callback */
	virtual void callback1( Widget, XtPointer, XtPointer );

	/* Method callback2:  Dismiss button callback */
	virtual void callback2( Widget, XtPointer, XtPointer );

	/* Method helpCallback:  Help button callback */
	virtual void helpCallback( Widget, XtPointer, XtPointer );

	/* Method clearAllPipePortExtract:  Remove all field extractions
	        for the given input port */
	void clearAllPipePortExtract( int portNumber );

	/* Method clearAllPipeOutputExtract:  Remove all field extractions
	        for the given output field */
	void clearAllPipeOutputExtract( int fieldNumber );

	/* Method clearSinglePipePortExtract:  Removes a single
	                 record/field binding to an input port */
        void clearSinglePipePortExtract( int portNumber, 
					 const char *recordName );

	/* Method clearSinglePipeOutputExtract:  Removes a single
	                 record/field binding to an output field */
	void clearSinglePipeOutputExtract( int fieldNumber, 
					   const char *recordName);

	/* Method clearRecordScrollArea:  Remove all record entries from
                                            the record scolledList */
	void clearRecordScrollArea();

	/* Method fieldExtractPipeField:  Register a record name and field
	                    extracted from an input pipe to an output field */
	void fieldExtractPipeField( int fieldNumber, const char *recordName,
				    const char *fieldName );

	/* Method fieldExtractPipePort:  Register a record name and field 
	                      extracted from an input pipe to an input port */
	void fieldExtractPipePort( int portNumber, const char *recordName,
				   const char *fieldName );

	/* Method fillRecordScrollAreaFromOutputField:  Load record names 
	               on the given output field into the record scrollList */
	void fillRecordScrollAreaFromOutputField( int fieldNumber,
						  int inputPipeNumber,
						  Boolean isExtracted );

	/* Method fillRecordScrollAreaFromPipe:  Load record names on the
	                      given input pipe into the record scrollList */
	void fillRecordScrollAreaFromPipe( int pipeNumber );

	/* Method fillRecordScrollAreaFromPort:  Load record names on the
	                      given input port into the record scrollList */
	void fillRecordScrollAreaFromPort( int portNumber,
					   int inputPipeNumber,
					   Boolean isExtracted );

	/* Method realize:    make visible the detail window */
	void realize();

	/* Method registerNumberInputPipes:  Register the total number of
	       pipes added in the scoreboard with this class */
	void registerNumberInputPipes( int numberInputPipesIn );

	/* Method registerOutputFieldAddition:  Allocate field-extract-specific
	   data structures given the existence of this output record field */
	void registerOutputFieldAddition();

	/* Method registerOutputFieldDeletion:  Deallocate field-extract-
	      specific data structures given this output field was deleted */
	void registerOutputFieldDeletion( int fieldNumber );

	/* Method registerPort: Allocate field-extract-specific data
	         structures given the existence of the given input port */
	void registerPort( int portNumber );

	/* Method resetDetails:  Clear entries in the currently-visible
	         detail window, bringing it to an "unselected" state */
	void resetDetails();

	/* Method setDescriptor:  sets the label describing the detail
	                            window */
	void setDescriptor( char *label, Pixel background );

	/* Method setName:   sets the name field in the detail window */
	void setName( const char *name );

	/* Method setType:   sets the type field in the detail window */
	void setType( const char *type );

	/* Method unrealize:  pop down the detail window */
        void unrealize();
};

#endif
