/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * PlayerFU.cc - A polymorophic functional unit to play embedded sound
 *               directives
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/FunctionalUnits/RCS/PlayerFU.C,v 1.17 1994/04/07 20:22:57 aydt Exp $
 */

#ifdef __GNUG__
extern "C" {
unsigned usleep(unsigned microseconds);
}
#endif

#include "PlayerFU.h"

#include "InputPort.h"


PlayerFU::PlayerFU()
{
  isReady = FALSE_;
  FirstTimeRun = TRUE_;
}

PlayerFU::~PlayerFU()
{
	delete command;
	delete timestamp;
}


FunctionalUnit *PlayerFU::copy()
{
	PlayerFU *copy = new PlayerFU();

	return copy;
}

Boolean_ PlayerFU::ready()
{
	return isReady;
}

void PlayerFU::run( Boolean_& /* errorFlag */ )
{
	char *msgString;
	double ts;
	int sz;
	char host[128];
	char port[128];

	Assert( command -> valueAvailable() );
	Array a = ( Array ) command -> getValue();
	sz = a.getCellCount();
	msgString = new char[sz + 1];
	for(int i=0; i < sz; i++) {
	  msgString[i] = (char) a.getTheCellValue(i);
	}

	Assert( timestamp -> valueAvailable());
	ts = (double) (timestamp->getValue());
	// The first soundcommand (msgString) actually contains the host
	// and port for which this trace was written. 

	if (FirstTimeRun)	 {
	  FirstTimeRun = FALSE_;
	  sscanf(msgString, "%s %s", host, port);
	  if (SD.openConnection(host, port) == TRUE_) {
	    isReady = TRUE_;
	  }
	  oldtimestamp = ts;
	} else {
	  usleep( (unsigned) ((ts - oldtimestamp) *  1000000));
	  SD.executeMessage(msgString);
	  oldtimestamp = ts;
	}
	delete msgString;

}



void PlayerFU::init()
{
  timestamp = new InputPort( "Timestamp" );
  command = new InputPort( "Command" );

  command -> addTraits( CHARACTER, 1 );
  timestamp -> addTraits( DOUBLE );
  
  _addInputPort( command );
  _addInputPort( timestamp );
  
}

void PlayerFU::configure()
{
  char host[128];
  char port[128];
  
//  getHostandPort(host, port);
  
  
}


	
