/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

/*
 * util.cc:
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Motif/Misc/RCS/util.C,v 1.15 1994/03/08 21:29:24 aydt Exp $
 */

#include <stdio.h>
#include <stdarg.h>
#include "CString.h"
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/List.h>

#include "util.h"

#define SDECL(Num) Arg args[Num]; int n;
#define SINIT n = 0;
#define SARG(arg, val) XtSetArg(args[n], arg, (XtArgVal) val); n++;
#define SVAL(widget) XtSetValues(widget, args, n);
#define GVAL(widget) XtGetValues(widget, args, n);
	   
static int uniqueNumber = 0;

static void UtilError(char *fmt, ...)
{
	char buf[8192];

	va_list arglist;

	va_start(arglist, fmt);

	vsprintf(buf, fmt, arglist);

	cerr << form( "Util error: %s\n", buf );
}

void UtilSetValue(Widget w, String resource, XtArgVal value)
{
	Arg arg;

	XtSetArg(arg, resource, value);
	XtSetValues(w, &arg, 1);
}

void UtilSetXmStringValue(Widget w, String resource, char *str)
{
	XmString xmstr = getMotifStringFromCharString(str);
	UtilSetValue(w, resource, (XtArgVal) xmstr);
	XmStringFree(xmstr);
}

void UtilSetXmStringValue(Widget w, String resource, const CString &str)
{
	XmString xmstr = getMotifStringFromCString(str);
	UtilSetValue(w, resource, (XtArgVal) xmstr);
	XmStringFree(xmstr);
}

CString 
UtilGetXmStringValueAsCString(Widget w, String resource) 
{
	XmString xmstr;

	UtilGetValue(w, resource, (XtArgVal) &xmstr);
	CString s = getCStringFromMotifString(xmstr);
	XmStringFree(xmstr);
	return s;
}


void UtilGetValue(Widget w, String resource, XtArgVal value)
{
	Arg arg;

	XtSetArg(arg, resource, value);
	XtGetValues(w, &arg, 1);
}

void UtilSetLabelString(Widget w, char *lab)
{
	XmString xmstr = getMotifStringFromCharString(lab);

	UtilSetValue(w, XmNlabelString, (XtArgVal) xmstr);

	XmStringFree(xmstr);
}

void UtilSelectOptionMenuItem(Widget w, int item)
{
	Widget subMenu;
	Widget *kids;
	int nKids;
	Arg args[10];
	int n;

	if (w == NULL || !XmIsRowColumn(w))
	{
		UtilError("widget not a RowColumn in UtilSelectOptionMenuItem");
		return;
	}

	UtilGetValue(w, XmNsubMenuId, (XtArgVal) &subMenu);
	if (subMenu == NULL)
	{
		UtilError("UtilSelectOptionMenuItem: widget has no submenu");
		return;
	}


	n = 0;
	SARG(XmNchildren, &kids);
	SARG(XmNnumChildren, &nKids);
	GVAL(subMenu);

	if (item < 0 || item >= nKids)
	{
		UtilError("UtilSelectOptionMenuItem: invalid item %d\n(menu has %d children)", item, nKids);
		return;
	}

	n = 0;
	SARG(XmNmenuHistory, kids[item]);
	SVAL(w);
}

void UtilSelectRadioBoxItem(Widget w, int item)
{
	Widget *kids;
	int nKids;
	Arg args[10];
	int n;

	if (w == NULL || !XmIsRowColumn(w))
	{
		UtilError("widget not a RowColumn in UtilSelectOptionMenuItem");
		return;
	}

	n = 0;
	SARG(XmNchildren, &kids);
	SARG(XmNnumChildren, &nKids);
	GVAL(w);

	if (item < 0 || item >= nKids)
	{
		UtilError("UtilSelectOptionMenuItem: invalid item %d\n(menu has %d children)", item, nKids);
		return;
	}

	UtilSetValue(kids[item], XmNset, (XtArgVal) 1);

	n = 0;
	SARG(XmNmenuHistory, kids[item]);
	SVAL(w);
}

int UtilGetSelectedToggle(Widget w)
{
	Widget hist;
	Widget *kids;
	int nKids, i;
	Arg args[10];
	int n;

	if (w == NULL || !XmIsRowColumn(w))
	{
		UtilError("widget not a RowColumn in UtilSelectOptionMenuItem");
		return -1;
	}

	n = 0;
	SARG(XmNchildren, &kids);
	SARG(XmNnumChildren, &nKids);
	SARG(XmNmenuHistory, &hist);
	GVAL(w);

	for (i = 0; i < nKids; i++)
	{
		if (hist == kids[i])
			return i;
	}
	return -1;
}

void UtilDestroyChildren(Widget w)
{
	Widget *kids;
	int nKids, i;

	UtilGetChildrenInfo(w, &kids, &nKids);

	for (i = 0; i < nKids; i++)
		XtDestroyWidget(kids[i]);
}

void UtilClearList(Widget w)
{
	SDECL(3);
	
	if (w == NULL || !XmIsList(w))
	{
		UtilError("UtilClearList: Widget 0x%x not a list", w);
		return;
	}

	SINIT;
	SARG(XmNitemCount, 0);
	SARG(XmNitems, NULL);
	SVAL(w);
}

void UtilGetChildrenInfo(Widget w, Widget **kids, int *nKids)
{
	SDECL(2);
	SINIT;
	if (w == NULL)
	{
		*nKids = 0;
		*kids = NULL;
		return;
	}
	SARG(XmNnumChildren, nKids);
	SARG(XmNchildren, kids);
	GVAL(w);
}

CString getCStringFromMotifString(XmString xmstr)
{
	char *text;

	if ( XmStringGetLtoR(xmstr, XmSTRING_DEFAULT_CHARSET, &text) ) {
	    /* get rid of trailing blanks - they cause trouble later */
	    int sl = strlen( text );
	    sl--;
	    while( (text[sl] == ' ')  && (sl >= 0) ) {
		sl--;
	    }
	    text[sl+1] = '\0';
            return CString(text);
        } else {
            return CString() ;
        }
}

XmString 
getMotifStringFromCString( const CString& cstr )
{
	return ( XmStringCreateLtoR( (char *)cstr.getValue(), 
				     XmSTRING_DEFAULT_CHARSET) );
}

XmString getMotifStringFromCharString(const char *str)
{
	return (XmStringCreateLtoR((char *) str, 
				   (XmStringCharSet) XmSTRING_DEFAULT_CHARSET));
}

int getUniqueNumber()
{
    return uniqueNumber++;
}

char *getUniqueName(char *s)
{
    static char name[100];

    sprintf(name, "%s_%03d", s, uniqueNumber);
    uniqueNumber++;

    return name;
}

int AllocateColor(Display *display, Colormap cmap, char *color_name)
{
	XColor actual,requested;

	if (!XAllocNamedColor(display,cmap,color_name,&actual,&requested))
	{
		cerr << form( "Can't allocate color \"%s\"\n", color_name );
		return(0);
	}
	return(actual.pixel);
}

int AllocateRGBColor(Display *display, Colormap cmap,
		     int red, int green, int blue)
{
	XColor colors;

	colors.red = red;
	colors.green = green;
	colors.blue = blue;
	colors.flags = DoRed | DoGreen | DoBlue;
	if (!XAllocColor(display,cmap,&colors))
	{
		fprintf(stderr,"Can't allocate color\n");
		return(0);
	}
	return(colors.pixel);
}

    
