/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

/*
 * DisplayLabels.h: Display widget label handling.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Motif/Includes/RCS/DisplayLabels.h,v 1.10 1994/03/08 21:34:04 aydt Exp $
 */

#ifndef DisplayLabels_h
#define DisplayLabels_h

#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>

#include "Obj.h"

// Label codes
#define L_BOTTOM_HORIZ 	1
#define L_LEFT_VERT	2
#define L_TOP_HORIZ     3

#define FONT_MAX_LEN  		256
#define LABEL_MAX_LEN 		256
#define FORM_FRACTION_BASE	10000


class DisplayLabels : public Obj {
/* 
 *      A DisplayLabels object encapsulates all the details of display
 *      widget label handling
 */

private:
        Widget widgetLeftVertLabel,widgetBottomHorizLabel,widgetTopHorizLabel;
	XmFontList labelFont, minMaxFont;
        int pctTotal;
        int pctHtLeftVertLabel, pctHtBottomHorizLabel, pctHtTopHorizLabel;
        int lengLeftVertLabel, lengBottomHorizLabel, lengTopHorizLabel;
        char stringLeftVertLabel[LABEL_MAX_LEN];
        char stringBottomHorizLabel[LABEL_MAX_LEN];

protected:
	/* Method verticalizeLabel:	Generates a vertical text
	*				string from the input		      */
	XmString verticalizeLabel( const char *stringLabel );

public:     
        /* Method DisplayLabels:  	The class constructor		      */
        DisplayLabels();

        /* Method ~DisplayLabels:	The class descructor		      */
        ~DisplayLabels();

        /* Method loadLabelFont:        Loads the font data structure 
	*				specified 			      */
        void loadLabelFont( Widget displayGiver, char *newLabelFont );

	/* Method loadMinMaxFont:       Loads the font data for specifying 
	*			        minima and maxima		      */
        void loadMinMaxFont( Widget displayGiver, char *newLabelFont );
     
	/* method createMinMaxLabel:    Creates the label for minima and 
	*				maxima	                              */
	void createMinMaxLabel( Widget labelParent, char *labelName );

        /* Method getLabel:  		Sets *stringLabel to point to the 
	*				character string value of the given 
	*				type of label. Only BOTTOM and LEFT
	*			        types are supported.  TOP returns
	*				NULL character string                 */
        void getLabel( int whichLabel, const char **stringLabel ) const;

	/* Method getLabelHeight:	Returns the height of the specified 
	*				label			              */
        int getLabelHeight( int whichLabel );

	/* Method setLabel:  		Puts a character string to the 
	*				appropriate widget label.  Only
	*				BOTTOM and LEFT types are supported.  */
	Boolean_ setLabel( Widget labelParent, char *labelName,
		           int whichLabel, const char *stringLabel );

	/* Method setLabel:	        Sets the minimum and maximum values
	*				in the TOP label.                     */
        void setLabel( double fuMin, double fuMax );

        /* Method isALabel:  		Returns existence status for the given 
	*				label                                 */
        Boolean_ isALabel( int whichLabel );
};         

#endif
