/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * RadioButtonBox.cc: Implements RadioButtonBox.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Motif/Complex/RCS/RadioButtonBox.C,v 1.11 1994/03/08 21:32:23 aydt Exp $	
 */
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/RowColumn.h>

#include "RadioButtonBox.h"
#include "Defines.h"
#include "XArgs.h"
#include "util.h"

static void buttonCallback( Widget w, RadioButtonBox *obj, void *data );
static void entryCallback( Widget w, RadioButtonBox *box,
			   XmRowColumnCallbackStruct *rcData );

static void 
buttonCallback( Widget w, RadioButtonBox *obj, void * /* data */ )
{
	obj->gotCallback( w );
}

static void 
entryCallback( Widget /* w */, RadioButtonBox *box, 
	       XmRowColumnCallbackStruct *rcData )
{
	XmToggleButtonCallbackStruct *togData;

//	cout << "in entryCallback\n";

	togData = (XmToggleButtonCallbackStruct *) rcData->callbackstruct;

//	cout << "got entryCallback, togReason=" << togData->reason << NL;

	box->gotCallback( rcData->widget );
}

RadioButtonBox::RadioButtonBox( WidgetBase *par, const XArgs& xargs,
			        const CString& name )
	       : WidgetBase( par )
{
    	CString uniqueName;

    	if ( name.length() == 0 ) {
	    uniqueName = getUniqueName( "RadioButtonBox" );
    	} else {
	    uniqueName = name;
	}

        _setType( "RadioButtonBox" );
    
    	widget = XmCreateRadioBox( par->getWidget(), 
				   (char *)uniqueName.getValue(),
			      	   xargs.getArgs(), xargs.getNArgs() );

//    addCallback(XmNentryCallback, (XtCallbackProc) entryCallback,
//		(void *) this);

    	nButtons = 0;
    	activeButton = -1;
    	notifyProc = NULL;
}

RadioButtonBox::~RadioButtonBox()
{
}

void 
RadioButtonBox::addButton( const CString &name )
{
	names[nButtons] = name;
	buttons[nButtons] = XmCreateToggleButtonGadget( getWidget(),
						        (char *)name.getValue(),
						        NULL, 0 );

	XtManageChild( buttons[nButtons] );

	XtAddCallback( buttons[nButtons], XmNarmCallback,
		      (XtCallbackProc)buttonCallback, this );

//	cout << form("added button %d %x\n", nButtons, buttons[nButtons]);

	nButtons++;
}
	
void 
RadioButtonBox::addDisplayButton( const CString &name )
{
	names[nButtons] = name;
	buttons[nButtons] = XmCreateToggleButton( getWidget(),
						  (char *)name.getValue(),
						   NULL, 0 );
	XtUninstallTranslations( buttons[nButtons] );
	XtManageChild( buttons[nButtons] );

	nButtons++;
}

void 
RadioButtonBox::setNotifyProc( RBBNotifyProc proc, void *d )
{
	notifyProc = proc;
	notifyData = d;
}

void 
RadioButtonBox::selectButton( int b )
{
	if ( b < 0 || b >= nButtons ) {
	    warning( "Invalid button %d in RadioButtonBox::selectButton", b );
	    return;
	}

	Arg arg;
	if ( b != activeButton ) {
	    if ( activeButton != -1 ) {
		XtSetArg( arg, XmNset, FALSE );
		XtSetValues( buttons[activeButton], &arg, 1 );
	    }
		
	    XtSetArg( arg, XmNset, TRUE );
	    XtSetValues( buttons[b], &arg, 1 );
	}
	activeButton = b;
}


int 		/* virtual */
RadioButtonBox::getIntegerValue() const
{
	return activeButton;
}

void 
RadioButtonBox::gotCallback( Widget w )
{
	int i;

	for ( i = 0; i < nButtons; i++ ) {
	    if ( buttons[i] == w ) {
		break;
	    }
	}

	if ( i == nButtons ) {
	    activeButton = -1;
	} else {
	    activeButton = i;
	}

	if ( notifyProc ) {
	    (*notifyProc)( activeButton, (char *)names[activeButton].getValue(),
			   notifyData );
	}
}

void 
RadioButtonBox::printOn( ostream& os ) const
{
	os << "RadioButtonBox\n";
}
