/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

/*
 * XArgs.cc:
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Motif/Base/RCS/XArgs.C,v 1.10 1994/02/25 04:43:27 aydt Exp $
 *	
 */

#include <stdio.h>
#include <stdlib.h>

#include "XArgs.h"

static int initialSize;

XArgs::XArgs(int size)
{
	initialSize = size;
	if (initialSize > 0)
	{
		args = new Arg[initialSize];
	}
	else
		args = NULL;
	nArgsAlloced = initialSize;
	nArgs = 0;
}

XArgs::~XArgs()
{
	if (args != NULL)
	{
		delete [] args;
	}
}


XArgs::XArgs( const XArgs& xargs )
{
	int i;
	
	nArgsAlloced = xargs.nArgsAlloced;
	if (nArgsAlloced > 0)
		args = new Arg[nArgsAlloced];
	else
		args = NULL;
	nArgs = xargs.nArgs;
	for (i = 0; i < nArgs; i++)
		args[i] = xargs.args[i];
}

XArgs&
XArgs::operator=( const XArgs& xargs )
{
	int i;

	if (args)
	{
		if (nArgsAlloced < xargs.nArgsAlloced)
		{
			delete[] args;
			nArgsAlloced = xargs.nArgsAlloced;
			args = new Arg[nArgsAlloced];
		}
	}
	else
	{
		nArgsAlloced = xargs.nArgsAlloced;
		if (nArgsAlloced > 0)
			args = new Arg[nArgsAlloced];
		else
			args = NULL;
	}

	nArgs = xargs.nArgs;
	for (i = 0; i < nArgs; i++)
		args[i] = xargs.args[i];

	return *this;
}	

void XArgs::reset()
{
	nArgs = 0;
	if (args == NULL)
	{
		if (initialSize > 0)
		{
			args = new Arg[initialSize];
		}
		nArgsAlloced = initialSize;
	}
	if (nArgsAlloced > 0) {
		memset(args, 0, sizeof(Arg) * nArgsAlloced);
	}
}

void XArgs::addArg(char *name, XtArgVal value)
{
    if (nArgs == nArgsAlloced)
    {
	Arg *tmp;
	int i;
	int newAlloced;

	if (nArgsAlloced == 0)
		newAlloced = 3;
	else
		newAlloced = nArgsAlloced * 2;

	tmp = new Arg[newAlloced];
	for (i = 0; i < nArgs; i++)
	    tmp[i] = args[i];

	if (args != NULL)
		delete [] args;
	args = tmp;
	
	nArgsAlloced = newAlloced;
    }

    XtSetArg(args[nArgs], name, value);
    nArgs++;
}

const 
Arg& XArgs::getArg( int n ) const
{
    static Arg dummyArg;
    if ( (n < 0) || (n >= nArgs) ) {
	printf( "Ack! XArgs::getArg: invalid argument %d\n", n );
	return dummyArg;
    } else {
	return args[n];
    }
}

void XArgs::printOn(ostream & os) const
{
	int i;
	
	os << "XArgs: " << nArgs << " arguments:\n";
	for (i = 0; i < nArgs; i++)
	{
		os << form("    Arg %d: %s = 0x%x\n", i,
			   args[i].name, args[i].value);
	}
}
