/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#include <stdio.h>

#include "BooleanMenu.h"

void BooleanMenu::setValue(char *args, double value) {
  int op=0;

  if (strcmp(args, "constant") == 0) {
    constant = (float) value;
    return;
  } else {
    sscanf(args, "%*[^0-9]%d", &op);
    setOperation(op);
  }
}

void BooleanMenu::setOperation(int op) 
{
  if (op >= 0 && op < 6) {
    operation = op;
  } else {
    cerr << form("Warning: BooleanMenu::setValue(): invalid operation %d; \
                    ignoring\n",  op);
  }
}

void BooleanMenu::setValue(char *args, char *value) {
  if (strlen(value) == 0) {
    setValue(args, 0.0);
  } else {
    setValue(args, (double) atof(value));
  }

}

Bool_ BooleanMenu::readConfiguration(istream &is)
{
  char token[128];
  
  if (parser.getTok(is, token) != FIXED) {
    return ( False_ );
  } else {
    setOperation(atoi(token));
  }

  if (parser.getTok(is, token) != FIXED) {
    return ( False_ );
  } else {
    constant = atof(token);
  }
  return ( True_ );
}

char* BooleanMenu::printConfiguration(char *header)
{
  char *tmp = form("%s %d %d %3.2f", header, BooleanMenu_, operation, 
		   constant);
  char *s = new char[strlen(tmp) + 1];
  strcpy(s, tmp);
  return s;
}

double BooleanMenu::compute(double x)
{
  switch(operation) {
  case 0:
    return (x == constant);

  case 1:
    return(x < constant);

  case 2:
    return(x > constant);

  case 3:
    return(x <= constant);

  case 4:
    return(x >= constant);

  case 5:
    return(x != constant);

  default:
    cerr << form("Warning: BooleanMenu::compute(): invalid operation %d\n",
		 operation);
    return(0);

  }
}

void BooleanMenu::calculateValue(void *variable, void *result)
{
  ((Val *)result)->setValueFromDouble(compute(*((double *) variable)));
}

void BooleanMenu::printOn(ostream &os)
{
  os << "Boolean, DataValue  ";

  switch (operation) {
  case 0:
    os << "==";
    break;
  case 1:
    os << "<";
    break;
  case 2:
    os << ">";
    break;
  case 3:
    os << "<=";
    break;
  case 4:
    os << ">=";
    break;
  case 5:
    os << "!=";
    break;
  default:
    os << "unknown";
    break;
  }
  os << form(" %3.2f",  constant);
}

