/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#ifdef __GNUG__
extern "C" {
unsigned int usleep(unsigned microseconds);
}
#endif

#include <time.h>

	
#include "MIDISoundDevice.h"
	
MIDISoundDevice::MIDISoundDevice()
{
  InitMIDI();
}

MIDISoundDevice::~MIDISoundDevice()
{
  MIDIcloseDevice();
}

void
MIDISoundDevice::reinitialize(ValList &)
{
InitMIDI();
}

void
MIDISoundDevice::setKeyPressure(ValList &v)
{
  KeyPressure((char) (v.getArg(0)), (char) v.getArg(1));
}

void
MIDISoundDevice::noteOn(ValList &v)
{
  NoteOn((char) v.getArg(0), (char) v.getArg(1));
}

void
MIDISoundDevice::noteOff(ValList &v)
{
  NoteOff((char) v.getArg(0), (char) v.getArg(1));
}

// I thought that if a device only accepts 1 byte resolution, 
// lsb is zero... I think something is wrong here somewhere.
//
void
MIDISoundDevice::setPitchBend(ValList &v)
{
  char c = (char) (v.getArg(0));
  if (v.numberArgs() == 1) {
    cout << "Setting Pitch bend to " << (int) c << NL;
    PitchWheel((char) v.getArg(0), 0);
  } else {
    cout << "Setting Pitch bend to 2 args" << (int) c << NL;
    PitchWheel((char) v.getArg(0), (char) v.getArg(1));
  }
}

void
MIDISoundDevice::setChannelPressure(ValList &v)
{
  ChannelPressure((char) v.getArg(0));
}

void
MIDISoundDevice::setVolume(ValList &v)
{
  SetVolume((char) (v.getArg(0)));
}

void
MIDISoundDevice::setBalance(ValList &v)
{
  SetBalance((char) (v.getArg(0)));
}

void
MIDISoundDevice::playNote(ValList &v)
{
  char c = GetCurrentChannel();
  char pitch = v.getArg(0);
  char velocity = v.getArg(2);
  NoteOn(pitch, velocity);
  usleep((unsigned) ((float) v.getArg(1) * 1000000));
  SelectChannel(c);
  NoteOff(pitch, velocity);
}

void MIDISoundDevice::pause(ValList &v)
{
  usleep((unsigned) ((float) v.getArg(0) * 1000000));
}

void MIDISoundDevice::closeDevice()
{
  MIDIcloseDevice();
}

void MIDISoundDevice::selectInstrument(ValList &v)
{
  int i = (int) v.getArg(0);
  char c = (char) v.getArg(0);
  SelectProgram((char) v.getArg(0));
}
     
void MIDISoundDevice::selectChannel(ValList &v)
{
  char channel = v.getArg(0);
  if (channel >= 0 && channel < 16) {
    SelectChannel(channel);
  } else {
    cerr << form("Error: MIDISoundDevice::selectChannel: channel=%d out of range\n", 
		 channel);
  }
}

void MIDISoundDevice::setPortamento(ValList &v)
{
  if ((v.getArg(0)).type() == BOOLEAN) {
    if ((int) v.getArg(0)) {
      SetPortamento((char) 127);
    } else {
      SetPortamento((char) 0);
    }
  } else {
    SetPortamento((char) v.getArg(0));
  }
}

void MIDISoundDevice::setSustain(ValList &v)
{
  if ((v.getArg(0)).type() == BOOLEAN) {
    if ((int) v.getArg(0)) {
      SetSustain((char) 127);
    } else {
      SetSustain((char) 0);
    }
  } else {
    SetSustain((char) v.getArg(0));
  }
}

void MIDISoundDevice::setVibrato(ValList &v) 
{
  if ((v.getArg(0)).type() == BOOLEAN) {
    if ((int) v.getArg(0)) {
      SetVibrato((char) 127);
    } else {
      SetVibrato((char) 0);
    }
  } else {
    SetVibrato((char) v.getArg(0));
  }
}

void MIDISoundDevice::allNotesOff(ValList &)
{
  AllNotesOff();
}

void MIDISoundDevice::printOn(ostream &os)
{
        os << "MIDISoundDevice";
}

/*
 * Initialize static data
 */
ValList MIDISoundDevice::_dummyArg;
