; Orchestra File Skeleton for makegamme

sr=8192 
kr=512 
ksmps=16 

instr 1
; put your code here 
; note : code for a Scot score (ie p5 is pitch, etc)

;;;
;;; Flute
;;;

        icpsp   = cpspch(p5)

        if (p4 == int(p4/2) * 2) goto initslurs
                ihold

initslurs:
        iatttm  = 0.09
        idectm  = 0.1
        isustm  = p3 - iatttm - idectm
        idec    = p6
        ireinit = -1

        if (p4 > 1) goto checkafterslur
        ilast   = 0
checkafterslur:
        if (p4 == 1 || p4 == 3) goto doneslurs
        idec = 0
        ireinit = 0

doneslurs:
        if (isustm <= 0) goto simpleenv
        kamp    linseg ilast,iatttm,p6,isustm,p6,idectm,idec,0,idec
        goto doneenv

simpleenv:
        kamp    linseg ilast,p3 / 2,p6,p3 / 2,idec,0,idec

doneenv:
        ilast = p6

;;; Some vibrato.
        ivamp   = icpsp * 0.01
        ivfreq  = 6.0
        kvbra   oscil ivamp,ivfreq,1,ireinit
        kfreq   = icpsp + kvbra

;;; Noise for burst at beginning of note.
        knseenv expon p6 / 3,.3,1
        anoise1 rand knseenv
        anoise  tone anoise1,200

;;; The note.
        a1      oscili kamp,kfreq,5,ireinit

        a2      = a1 + anoise

        out a2
endin

