/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#include <time.h>

#ifdef __GNUG__
extern "C" {
unsigned int usleep(unsigned microseconds);
}
#endif


#include "TG33SoundDevice.h"

TG33SoundDevice::TG33SoundDevice()
{
}

TG33SoundDevice::~TG33SoundDevice()
{
}

void TG33SoundDevice::printOn(ostream &os)
{
	os << "TG33SoundDevice\n";
}

void TG33SoundDevice::playNoteOnChannel(ValList &v)
{
  char c = (char) v.getArg(3);
  SelectChannel(c);
  char pitch = v.getArg(0);
  char velocity = v.getArg(2);
  NoteOn(pitch, velocity);
  usleep((unsigned) ((float) v.getArg(1) * 1000000));
  SelectChannel(c);
  NoteOff(pitch, velocity);
}
  

void TG33SoundDevice::setPitchBendGranularity(ValList &v)
{
  char msg[3];
  msg[0] = (char) 0xf0;
  msg[1] = (char )0x43;
  msg[2] = (char) 0x10 | GetCurrentChannel();
  SysEx(msg,3);
  usleep(50);
  msg[0] = (char) 0x26;
  msg[1] = (char) 0x00;
  msg[2] = (char) 0x03;
  SysEx(msg,3);
  usleep(50);
  msg[0] = (char) 0x00;
  msg[1] = (char) 0x00;
  msg[2] = (char) 0x14;
  SysEx(msg,3);
  usleep(50);
  msg[0] = (char) 0x01;
  msg[1] = (char) 0x7f;
  msg[2] = (char) 0x00;
  SysEx(msg,3);
  usleep(50);
  msg[0] = (char) v.getArg(0);
  msg[1] = (char) 0xf7;
  SysEx(msg,2);
}

void TG33SoundDevice::setModulationWheel(ValList &v)
{
  Parameter((char) 1, (char) v.getArg(0));
}

void TG33SoundDevice::setVectorControlXaxis(ValList &v)
{
  Parameter((char) 16, (char) v.getArg(0));
}

void TG33SoundDevice::setVectorControlYaxis(ValList &v)
{
  Parameter((char) 17, (char) v.getArg(0));
}

void TG33SoundDevice::resetAllControllers(ValList &)
{
  Parameter((char) 121, (char) 0);
}

void TG33SoundDevice::setBalance(ValList &v)
{
  char c = (char) v.getArg(0);
//  cout <<"Setting Balance on channel " << (int) GetCurrentChannel() << " to " << (int) c << NL;
  // see p. 112 of TG33 manual
  char msg[3];
  msg[0] = (char) 0xf0;
  msg[1] = (char )0x43;
  msg[2] = (char) 0x10 | GetCurrentChannel();
  SysEx(msg,3);
  usleep(50);
  msg[0] = (char) 0x26;
  msg[1] = (char) 0x04;
  msg[2] = (char) 0x04; // ST
  SysEx(msg,3);
  usleep(50);
  msg[0] = (char) GetCurrentChannel();
  msg[1] = (char) 0x00; // F1
  msg[2] = (char) 0x06; // F2
  SysEx(msg,3);
  usleep(50);
  msg[0] = (char) 0x01; // B1
  msg[1] = (char) 0x7F; // B2
  msg[2] = (char) 0x0;
  SysEx(msg,3);
  usleep(50);
  msg[0] = (char) v.getArg(0);
  msg[1] = (char) 0xf7;
  SysEx(msg,2);

/*  char msg[7];
  msg[0] = (char) 0xf0;
  msg[1] = (char )0x43;
  msg[2] = (char) 0x10; // Device Number  | GetCurrentChannel();
  SysEx(msg,3);
  usleep(50);
  msg[0] = (char) 0x26;
  msg[1] = (char) 0x07;
  msg[2] = (char) 0x0c;
  SysEx(msg,3);
  usleep(50);
  msg[0] = (char) 0xf7;
  SysEx(msg, 1);
*/
}

void TG33SoundDevice::selectInstrument(ValList &v)
{
  int i = (int) v.getArg(0);

  if (i < 64) {
    selectVoiceBank(PRESET1);
    usleep(50); // delay is necessary here, don"t know why.
    SelectProgram((char) i);
  } else {
    selectVoiceBank(PRESET2);
    usleep(50);
    SelectProgram((char) (i-64));
  }
}

void TG33SoundDevice::selectVoiceBank(int vb)
{
  switch(vb) {
  case PRESET1:
//    Parameter((char) 0, (char) 0);
//    Parameter((char) 32, (char) 2);
    Parameter((char) 0, (char) 0);
    Parameter((char) 32, (char) 34);
    break;
  case PRESET2:
//    Parameter((char) 0, (char) 0);
//    Parameter((char) 32, (char) 5);
    Parameter((char) 0, (char) 0);
    Parameter((char) 32, (char) 37);
    break;
  default:
    break;
  }
}

void TG33SoundDevice::selectVoiceBank(ValList &v)
{
  int vb = (int) v.getArg(0);
  selectVoiceBank(vb);
}
