/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/* 
 * ValList.h: Implements a list of Vals.
 *
 */

#ifndef ValList_h
#define ValList_h

#include "Val.h"
#include "PtrList.h"

#ifdef __GNUG__
#include <stdio.h>
#include <string.h>
#endif

class ValList : public PtrList {
/*
 * ValList implements a list of Val objects.
 */


protected:
    
public:
  /* Method ValList: The ValList constructor */
  ValList(FILE *fp);
  ValList(int initialSize = 10) : PtrList(initialSize) { } ;

  /* Method ValList: The ValList destructor */
  ~ValList();

  /* Method printOn: Stream output function */
  void printOn(ostream &os = cout);
  
  /* Method binSend: Write a binary representation of ValList to sfd */
  void binSend(int sfd);
  
  /* Method binSendValues: Write a binary representation of Val values in *
   *                       ValList to sfd                                 */
  void binSendValues(int sfd);
  void binSendValues(int sfd, double dd);

  /* Method binReceive: Read a binary representation of ValList from sfd */
  void binReceive(int sfd);

  /* Method binReceiveValues: Read a binary representation of Val values in *
   *                          ValList from sfd                              */
	void binReceiveValues(int sfd);


  /* Method deleteArg: Delete an element of the list */
  Val&  deleteArg(int n) { return  *((Val *)(PtrList::deleteElement(n))); } ;
  
  /* Method getArg: Return an element of the list */
  Val&  getArg(int n) const  { return  *((Val *)(getElement(n))); } ;

  /* Method addArg: Add an element to the list */
  int addArg(Val* arg)  { return PtrList::addElement(arg); } ;
  int addArg(Val& arg)  { return PtrList::addElement(&arg); } ;
  int addArg(ValList& lookuptab, int idx) {
    return(addArg(lookuptab.getArg(idx)));
  } ;

  /* Method clear:     Deletes all Vals in a valList */
  void clear();

  /* Method setArg: Assign to a specific element of the list */
  int setArg(int n, Val* arg) { return PtrList::setElement(n, arg); } ;

  /* Method operator=: Val list assignment */
  ValList& operator=(ValList& vl);


};

inline ostream &operator<<(ostream &os, ValList &obj)
{
	obj.printOn(os);
	return os;
}

#endif
