# Perl script "ConfigureDeviceServer.perl"

$ARGV = shift;
open(SYSPARAMS, $ARGV);
$DEVICEPARAMS = $ARGV;
while(<SYSPARAMS>) {
	next line if /^#/;
	@tmp = split(' ');
	$sysparams{$tmp[0]} = $. - 1;
	print $tmp[0], " = ", $sysparams{$tmp[0]}, "\n";
}
close(SYSPARAMS);

$ARGV = shift;
$DEVICEDEFAULTS = $ARGV;
open(DEFAULTS, $ARGV);
open(DEFTAB, "> " . $DEVICEDEFAULTS . ".tab");
while(<DEFAULTS>) {
	next line if /^#/;
	@tmp = split(' ');
	$defaults{$tmp[0]} = $. - 1;
	print $tmp[0], " = ", $defaults{$tmp[0]}, "\n";
	if (defined($sysparams{$tmp[$#tmp]})) {
            s/($tmp[$#tmp])/$sysparams{$1}/;
        }
	if (defined($sysparams{$tmp[$#tmp -1]})) {
            s/($tmp[$#tmp -1])/$sysparams{$1}/;
        }
	print DEFTAB;
}
close(DEFTAB);
close(DEFAULTS);

$ARGV = shift;
open(MESSAGES, $ARGV);
$ARGV = shift;
$deviceclass = $ARGV;
print "Device class is: ", $deviceclass, "\n";

open(INIT, "> ./InitMessageList.C");
select(INIT);
print "#include \"SoundObj.h\"\n";
print "#include \"IndexList.h\"\n";
print "#include \"MessageList.h\"\n";
print "MessageList& InitMessageList() {\n";
print "MessageList *ml = new MessageList;\n\n";
print "PMF pmf;\n\n";
while(<MESSAGES>) {
	next line if /^#/;
	@str =  /(\".*\").*/io;
	@rest = /\".*\"(.*)/io;
	@msgs =  split(' ', $rest[0]);
	printf("pmf = &%s::%s;\n", $deviceclass, $msgs[0] );
	printf("ml->addArg(new Message(%s, (IndexList(%d", $str[0], $#msgs);
	for ($i=1; $i <= $#msgs; $i++) {
	   printf(", %d", $defaults{$msgs[$i]});
	}
	printf(")), pmf ));\n" );    
}
print "return(*ml);\n}\n";
close(INIT);

print STDERR $#msgs, "\n";
close(MESSAGES);

unless(open(DEFINES, "> ./DeviceSpecificDefs.h")) {
	print STDERR "Can't open DeviceSpecificDefs.h: $!\n";
	exit;
}
select(DEFINES);
print "/*\n";
print " * This file is part of the Pablo Performance Analysis Environment\n";
print " *\n";
print " * Developed by: The TAPESTRY Parallel Computing Laboratory\n";
print " *               University of Illinois at Urbana-Champaign\n";
print " *               Department of Computer Science\n";
print " *               1304 W. Springfield Avenue\n";
print " *               Urbana, IL     61801\n";
print " *\n";
print " * Copyright (c) 1987-1994\n";
print " * The University of Illinois Board of Trustees.\n";
print " *      All Rights Reserved.\n";
print " *\n";
print " * CONFIDENTIAL INFORMATION. Distribution\n";
print " * restricted under license agreement.\n";
print " *\n";
print " * Project Manager and Principal Investigator:\n";
print " *      Daniel A. Reed (reed@cs.uiuc.edu)\n";
print " *\n";
print " * Funded by: National Science Foundation grants NSF CCR86-57696,\n";
print " * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract\n";
print " * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant\n";
print " * from the Digital Equipment Corporation External Research Program,\n";
print " * and by a collaborative research agreement with the Intel Supercomputer\n";
print " * Systems Division.\n";
print " *\n";
print " */\n";

print "/* This file is automatically generated by a script */\n";
printf("#include \"%s.h\"\n", $deviceclass);
printf ("typedef void (%s::*PMF)(ValList &v);\n\n", $deviceclass);
print "typedef ", $deviceclass, " DEVICETYPE;\n";
printf("#define DEVICEPARAMS \"%s\"\n", $DEVICEPARAMS);
printf("#define DEVICEDEFAULTS \"%s\"\n", $DEVICEDEFAULTS . ".tab");
close(DEFINES);



