/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */


#include "SCFParsing.h"
#include <stdlib.h>


Tok SCFParsing::peekTok(istream &is)
{
  char buf[MAXID];
  int l;

  buf[0] = '\0';
  Tok currentTok = getTok(is, buf);
  l = strlen(buf);
  while (l) {
    is.putback(buf[--l]);
  }
  switch (currentTok) {
  case CONFIGURABLE:
    is.putback(CONFIG);
    break;
  case VARIABLE:
    is.putback(VAR);
    break;
  default:
    break;
  }
  return(currentTok);
}


Tok SCFParsing::getTok(istream &is, char *ret)
{
  char tmp, tmp2;
  char linebuf[MAXID*2];
 checktoken:

  if ((tmp = is.get()) != EOF) {

    if (isspace(tmp)) {
      goto checktoken;
    } else {
      switch(tmp) {
      case CONFIG:
	if (getId(is, ret) != IOERR) {
	  return(CONFIGURABLE);
	} else {
	  return (IOERR);
	}
	break;

      case VAR:
	if (getId(is, ret) != IOERR) {
	  return(VARIABLE);
	} else {
	  return (IOERR);
	}
	break;

      case SECTION:
	if ((tmp2 = is.peek()) != EOF && !isspace(tmp2)) { // then it is not by itself
	  return(getId(is, ret));
	} else {
	  strcpy(ret, form("%c ", SECTION));
	  return(SECTIONMARKER);
	}
	break;

      case '(':
	strcpy(ret, "(");
	return(LPAREN);

      case ')':
	strcpy(ret, ")");
	return(RPAREN);

      case '#':   // # until the end of the line, a la UNIX, is a comment
	is.get(linebuf, MAXID*2, '\n');
	goto checktoken;


      case '/':   // So are standard C style comments
	if ((tmp2 = is.peek()) != EOF  && tmp2 == '*') {
	  tmp2 = is.get(); 
	  eatComment(is);
	  goto checktoken;
	} else {
//	  is.putback(tmp2);
	  is.putback('/');
	  return(getId(is, ret));
	}
	break;

      default:
	is.putback(tmp);
	return(getId(is, ret));

      }
    }
  } else {
    return(IOERR);
  }
}

Tok SCFParsing::getId(istream &is, char *ret)
{
  char tmpid[MAXID];
  int length = 0;


  tmpid[MAXID -1] = '\0';

  
  while ((tmpid[length] = is.get()) != EOF && length < MAXID) { 
    if (!isalnum(tmpid[length]) && tmpid[length] != '-' && tmpid[length] != '/'
	&& tmpid[length] != '+' && tmpid[length] != '.') {
      is.putback(tmpid[length]);
      break;
    } else {
      length++;
    }
  }
  if (length > MAXID) {
    cerr << "Error: SCFParsing::getId(): Identifier \"" << tmpid << "\" too long.\n";
  return(IOERR);
  } else {
    tmpid[length] = '\0';
    strcpy(ret, tmpid);
    return(FIXED);
  }
}

  

Tok SCFParsing::getTok(istream &is, int &ret)
{
  char tmp[256];
  switch(getTok(is, tmp)) {
  case FIXED:
    ret = atoi(tmp);
    return(FIXED);

  case VARIABLE:
  case CONFIGURABLE:
  case LPAREN:
  case RPAREN:
    cerr << "Warning: SCFParsing::getTok: Unexpected token " << tmp << " where int expected (possible parse error)\n";
    ret = 0;
    return(IOERR);

  case SECTIONMARKER:
    return(SECTIONMARKER);

  case IOERR:
    return(IOERR);

  default:
    return(IOERR);

  }
}

Bool_ SCFParsing::eatComment(istream &is)
{
  char c;

  while(is>>c) {
    if (c == '*') {
      if (is>>c && c == '/') {
	return(True_);
      } else { 
	is.putback(c);
	continue;
      }
    }
  }
  cerr << "SCFParsing::eatComment(): Unterminated comment\n";
  return(False_);
}


void SCFParsing::printOn(ostream &os)
{
	os << "SCFParsing\n";
}

