/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */



#include "WclInterface.h"
#define  MAX_RADIOBOX_ENTRIES    12

extern "C" {
int putenv(const char*);
void WcRegisterCallback(XtAppContext, char*, XtCallbackProc, void *);
#include <X11/StringDefs.h>
void MriRegisterMotif(XtAppContext);
char *XmTextGetString(Widget);
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

int WcWidgetCreation(Widget);
void WcSetValueCB(Widget, char *, caddr_t );
};

#include <unistd.h>

static char _resourcefile[256];


// These are the Callback functions.

void SendMessageCB(Widget , char *data, void *)
{
  extern WclInterface *UI;

  int msgnum = atoi(data);
  UI->SendMessage(msgnum);
}

void SelectMessageCB(Widget , char *, XmListCallbackStruct *call_data)
{
  extern WclInterface *UI;

  int  messagenum = call_data->item_position - 1;

  UI->CurrentMessage = messagenum;
  UI->HighlightMessageArgs();
}

void UpdateDefaultCB(Widget w, char *data, void *call_data)
{

  extern WclInterface *UI;
  int whichdefault, v; 
  char *text, valuestring[128];

  XmString file;
  Arg arg[1];
  char *widgetclassname = (char *) (XtClass(w))->core_class.class_name;

  valuestring[0] = '\0';

  if (strcmp("XmText", widgetclassname) == 0) {
    (UI->getDefault(atoi(data))).setValueFromString((char *) XmTextGetString(w));
    return;
  }

  if (strcmp("XmScale", widgetclassname) == 0) {
    v = ((XmScaleCallbackStruct *) call_data)->value;
    (UI->getDefault(atoi(data))).setValueFromDouble((double)v);
    return;
  }
  if (strcmp("XmToggleButton", widgetclassname) == 0) {
    v = (int)(UI->getDefault(atoi(data)));
    (UI->getDefault(atoi(data))).setValueFromDouble((double)!v);
  }

  if (strcmp("XmList", widgetclassname) == 0 ) {
    v = ((XmListCallbackStruct *)call_data)->item_position - 1;      
    (UI->getDefault(atoi(data))).setValueFromDouble((double)v);
    return;
  }

  if (strcmp("XmFileSelectionBox", widgetclassname) == 0) {
    XtSetArg(arg[0], XmNdirSpec, (XtArgVal) &file);
    XtGetValues(w, arg, 1);
    XmStringGetLtoR(file, XmSTRING_DEFAULT_CHARSET, &text);
    (UI->getDefault(atoi(data))).setValueFromString(text);
    return;
  }

  /* otherwise */

  sscanf(data, "%d %s", &whichdefault, valuestring);

  if (strlen(valuestring) == 0) {
    cerr << form("Warning: WclInterface::UpdateDefaultCallback: unrecognized widget class name %s\n\t(do not know how to get argument value)\n", 
		 widgetclassname);
  } else {

  (UI->getDefault(whichdefault)).setValueFromString(valuestring);
}

}


/* static */
void WclInterface::onSignal() 
{
  if (strncmp(_resourcefile, "/tmp", 4) == 0) {
    unlink(_resourcefile);
  }
  exit(0);
}

WclInterface::WclInterface(char *appName, SoundDevice &sd, int argc, 
			   char **argv): SD(sd)
{ 

  XrmDatabase db;
  char *type;
  int status;
  XrmValue value;

  LabelNumber = 0;

  appClass = duplicateString(appName);

  if (islower(appClass[0]))
    appClass[0] = toupper(appClass[0]);
  else if (islower(appClass[1]))
    appClass[1] = toupper(appClass[1]);

  filebuf fb;
  char resourcefile[256], *appdir, *sdname;

  if ((appdir = getenv("XAPPLRESDIR")) == NULL) {
    cerr << form("Warning: XAPPLRESDIR is not set. Defaulting to %s\n",
		 DEFAULTXAPPLRESDIR);
    putenv((appdir = duplicateString(form("XAPPLRESDIR=%s",DEFAULTXAPPLRESDIR))));
  }

  sdname = SD.name();
  sprintf(resourcefile, "%s/%s", appdir, sdname);

  if (access(resourcefile, R_OK) < 0) { // an sdresource file does not exist

    if(fb.open(resourcefile,output) == 0) { 
      sprintf(resourcefile, "/tmp/%s%d", sdname, getpid());
      if(fb.open(resourcefile,output) == 0) {
	cerr << form("Error opening resource file %s\n", resourcefile);
	exit(1);
      }
      signal(SIGTERM,(SIG_PF) &WclInterface::onSignal);
      signal(SIGINT,(SIG_PF) &WclInterface::onSignal);
    }
  
    ostream resourceout(&fb);
    dumpWclResources(appClass, resourceout);
    resourceout.flush();
  }

  strcpy(_resourcefile, resourcefile);
  appShell = XtInitialize(appName, appClass, NULL, 0, &argc, argv);
  Display *dpy = XtDisplay(appShell);

  XrmPutLineResource(&(dpy->db), form("*rc.wcResFile:  %s", resourcefile));

  app = XtWidgetToApplicationContext(appShell);


  // figure out the foreground/background/highlight colors

  db = XtDatabase(dpy);
  
  status = XrmGetResource(db,
			  form("%s.background", appClass),
			  form("%s.background", appClass),
			  &type,
			  &value);
  if (!status) {
    strcpy(background,"white");
  } else {
    strcpy(background,value.addr);
  }
  
  status = XrmGetResource(db,
			  form("%s.foreground", appClass),
			  form("%s.foreground", appClass),
			  &type,
			  &value);
  if (!status) {
    strcpy(foreground,"black");
  } else {
    strcpy(foreground,value.addr);
  }
  
  status = XrmGetResource(db,
			  form("%s.highlightColor", appClass),
			  form("%s.highlightColor", appClass),
			  &type,
			  &value);
  if (!status) {
    strcpy(highlight, "");
  } else {
    strcpy(highlight,value.addr);
  }
  
  // register callbacks
  WcRegisterCallback(app, "UpdateDefaultCB",
		     (XtCallbackProc) &UpdateDefaultCB, (void *) NULL);

  WcRegisterCallback(app, "SelectMessageCB",
		     (XtCallbackProc) &SelectMessageCB, (void *) NULL);

  WcRegisterCallback(app, "SendMessageCB",
		     (XtCallbackProc) &SendMessageCB, "-1");
  

  MriRegisterMotif(app);
  WcWidgetCreation(appShell);

}

WclInterface::~WclInterface()
{
delete appClass;
}
  

Val& WclInterface::getDefault(int defaultnum)
{
  return (SD.DefaultsTable.getArg(defaultnum));
}


Message& WclInterface::getMessage(int messagenum)
{
  return(SD.Messages.getArg(messagenum));
}

void WclInterface::dumpWclResources(char *, ostream &os)
{
  char *childlist;
  char *messagename;

  childlist = dumpDefaultResources(os);
  messagename = dumpMessageListResources(os);
  os << "*rc.wcClassName:      XmRowColumn\n";
  os << "*rc.orientation:      horizontal\n";
  os << "*rc.numColumns:       3\n";
  os << form("*rc.wcChildren:\t%s, %s\n", childlist, messagename);
  delete childlist;
  delete messagename;
}

char* WclInterface::dumpMessageListResources(ostream &os)
{
  char *name = genName("messagelist");
  char *button = genName("execute");
  char *list = genName("list");
  char *title = genName("title");
  int i, numMessages;
  
  
  os << form("*%s.wcConstructor:\tXmCreateRowColumn\n", name);
  os << form("*%s.wcChildren:\t%s, %s, %s\n", name, title, button, list);
  os << form("*%s.entryAlignment:\tALIGNMENT_CENTER\n", name);

  os << form("*%s.wcClassName:\tXmLabel\n", title);
  os << form("*%s.labelString:\tSonic Messages\n", title);
  os << form("*%s.wcConstructor:\tXmCreatePushButton\n", button);
  os << form("*%s.activateCallback:\tSendMessageCB\n", button);
  os << form("*%s.labelString:\tEXECUTE\n", button);
  
  os << form("*%s.wcConstructor:\tXmCreateScrolledList\n", list);
  os << form("*%s.items:\t", list);
  
  numMessages = SD.Messages.numberArgs();

  if (numMessages > 0) {
    Message& m = SD.Messages.getArg(0);
    os <<  form("%s", m.getName());
  }

  for (i=1; i < numMessages; i++) {
    Message& m = SD.Messages.getArg(i);
    os <<  form(",\\\n%s", m.getName());
  }
  os << form("\n*%s.itemCount:\t%d\n", list, numMessages );
  os << form("*%s.visibleItemCount:\t%d\n", list,
             numMessages < 10 ? numMessages : 10);
  os << form("*%s.selectionPolicy:\tSINGLE_SELECT\n", list);
  
  os << form("*%s.singleSelectionCallback:\tSelectMessageCB\n", list);

  os << form("*%s.defaultActionCallback:\tSendMessageCB\n", list);
  delete button;
  delete list;
  delete title;

  return(name);
}


char* WclInterface::dumpDefaultResources(ostream &os)
{
  char *childlist = new char[256];
  char *childname = NULL;
  *childlist = '\0';
  
  int numchildren = SD.DefaultsTable.numberArgs();
  int i;
  
  for(i=0; i < numchildren; i++) {
    CurrentDefault= i;

    Val& v = SD.DefaultsTable.getArg(i);
    switch(v.type()) {

    case ENUMVAL:
    case REMOTEFILE:
      childname = doEnumList(v, os);
      break;
    case BOOLEAN:
      childname = doButton(v, os);
      break;
    case FLOAT:
    case DOUBLE:
    case ARRAY:
      childname = doText(v, os);
      break;
    case CHAR:
    case INTEGER:
     if (v.isbounded()) {
       childname = doSlider(v, os);
      } else {
	childname = doText(v, os);
      }
      break;
    default:
      cerr << "Error: WclInterface: unknown type val " << v.type() << NL;
      break;
    }

    if (strlen(childname) > 0) {
      if (strlen(childlist) == 0) {
	strcpy(childlist, childname);
      } else {
	strcat(childlist, ", ");
	strcat(childlist, childname);
      } 
      strcpy(childname, "");
    }

    
  }
  delete childname;
  return(childlist);
}

char* WclInterface::genName(char *s)
{
  char *ret = new char[strlen(s) + 5];
  sprintf(ret, "%s%d", s, LabelNumber++);
  return(ret);
}

// I gave up with option menus.
char* WclInterface::doEnumList(Val& v, ostream& os)
{
  int i, l, u;
  char *name = new char[12];
  sprintf(name, "default%d", CurrentDefault);
  
  char *label = genName("label");
  char *list = genName("list");
  
  char childlist[255], *childname;
  
  v.getbounds(l, u);
  Val& enumlist = SD.SystemParameters.getArg(l);
  u = (int) enumlist;
  if (u > MAX_RADIOBOX_ENTRIES) { // do a scrolled list widget
    
    os << form("*%s.wcConstructor:\tXmCreateRowColumn\n", name);
    os << form("*%s.wcChildren:\t%s, %s\n", name, label, list);
    os << form("*%s.entryAlignment:\tALIGNMENT_CENTER\n", name);
    
    os << form("*%s.wcClassName:\tXmLabel\n", label);
    os << form("*%s.labelString:\t%s\n", label, v.retname());
    os << form("*%s.wcConstructor:\tXmCreateScrolledList\n", list);
    os << form("*%s.items:\t", list);
    
    os <<  form("%s", enumlist.enumAsString(0));
    for (i=1; i < u; i++) {
      os <<  form(",\\\n%s", enumlist.enumAsString(i));
    }
    os << form("\n*%s.itemCount:\t%d\n", list, u );
    os << form("*%s.visibleItemCount:\t%d\n", list, MAX_RADIOBOX_ENTRIES);
    os << form("*%s.selectionPolicy:\tSINGLE_SELECT\n", list);
    os << form("*%s.singleSelectionCallback:\tUpdateDefaultCB(%d)\n", list, CurrentDefault);
    os << form("*%s.selectedItemCount:\t1\n", list);
    os << form("*%s.selectedItems:\t%s\n", list, enumlist.enumAsString((int) v));
    delete label;    delete list;
    return(name);
  } else { // do a radio box widget
    os << form("*%s.wcClassName:\tXmRowColumn\n", name);
    os << form("*%s.wcChildren:\tlabel, list\n", name);
    os << form("*%s.orientation:\tvertical\n", name);
    os << form("*%s.label.wcClassName:\tXmLabel\n", name);
    os << form("*%s.label.labelString:\t%s\n", name, v.retname());
    os << form("*%s.list.wcConstructor:\tXmCreateRadioBox\n", name);
    for(i=0; i < u; i++) {
      childname = genName("submenuent");
      os << form("*%s.list.%s.wcClassName:\tXmToggleButtonGadget\n", 
		 name, childname);
      os << form("*%s.list.%s.labelString:\t%s\n", name, childname, 
		 enumlist.enumAsString(i));
      os << form("*%s.list.%s.armCallback:\tUpdateDefaultCB(%d %d)\n", 
		 name, childname, CurrentDefault, i);
      if (((int) v) == i) {
	os << form("*%s.list.%s.set:\tTrue\n", name, childname);
      }
      if (i == 0) {
	strcpy(childlist, childname);
      } else {
	strcat(childlist, ", ");
	strcat(childlist, childname);
      }
      delete childname;
    }
    os << form("*%s.list.wcChildren:\t%s\n", name, childlist);
    delete label;    delete list;
    return(name);
  }
}


char* WclInterface::doText(Val& v, ostream& os)
{
  char *name = new char[12];
  sprintf(name, "default%d", CurrentDefault);

  os << form("*%s.wcClassName:\tXmRowColumn\n", name);
  os << form("*%s.wcChildren:\tlabel, textinput\n", name);
  os << form("*%s.orientation:\tvertical\n", name);
  os << form("*%s.label.wcClassName:\tXmLabel\n", name);
  os << form("*%s.label.labelString:\t%s\n", name, v.retname());
  os << form("*%s.textinput.wcClassName:\tXmText\n", name);
  os << form("*%s.textinput.value:\t%s\n", name, v.printVal());
  os << form("*%s.textinput.losingFocusCallback:\tUpdateDefaultCB(%d)\n", 
	     name, CurrentDefault );
  return name;
}
char* WclInterface::doSlider(Val& v, ostream& os)
{
  int l, u;
  char *name = new char[12];
  sprintf(name, "default%d", CurrentDefault);

  v.getbounds(l, u);
  os << form("*%s.wcClassName:\tXmScale\n", name);
  os << form("*%s.showValue:\tTrue\n", name);
  os << form("*%s.maximum:\t%s\n",name,
	     (SD.SystemParameters.getArg(u)).printVal());
  os << form("*%s.minimum:\t%s\n",name,
	     (SD.SystemParameters.getArg(l)).printVal());
  os << form("*%s.value:\t%s\n", name, v.printVal());
  os << form("*%s.titleString:\t%s\n", name, v.retname());
  os << form("*%s.valueChangedCallback:\tUpdateDefaultCB(%d)\n", 
	     name, CurrentDefault);
  return name;
}

char* WclInterface::doButton(Val& v,  ostream& os)
{
  char *name = new char[12];
  sprintf(name, "default%d", CurrentDefault);

  os << form("*%s.wcClass:\tXmToggleButtonWidgetClass\n", name);
  os << form("*%s.labelString:\t%s\n", name, v.retname());
  os << form("*%s.valueChangedCallback:\tUpdateDefaultCB(%d)\n", 
	     name, CurrentDefault);
  os << form("*%s.set:\t%s\n", name, ((int) v == 0) ? "False" : "True");

  return name;
}
    
void WclInterface::run()
{
  Display *dpy = XtDisplay(appShell);

  XtRealizeWidget(appShell);

  XtMainLoop();
}

void WclInterface::HighlightMessageArgs()
{
  
  int i, nargs;

  nargs = SD.DefaultsTable.numberArgs();
  /* reset all the arg backgrounds */
  for(i=0; i < nargs; i++) {
      // don"t ask about this one -- I couldn"t get XtSetValues to work
      WcSetValueCB(appShell, form("*default%d*background:  %s",i, background), 
		   NULL);
      WcSetValueCB(appShell, form("*default%d*foreground:  %s",i ,foreground), 
		   NULL);
  }
  
  IndexList& ilist = (getMessage(CurrentMessage)).getIndexList();
  
  nargs = ilist.numberArgs();  
  for(i=0; i < nargs; i++) {
      if (strcmp(highlight,"") == 0) {
	WcSetValueCB(appShell, form("*default%d*background: %s", ilist.getArg(i),foreground), 
		     NULL);
	WcSetValueCB(appShell, form("*default%d*foreground: %s", ilist.getArg(i),background),
		     NULL);
      } else {
	WcSetValueCB(appShell, 
		     form("*default%d*background: %s", ilist.getArg(i),
			  highlight), 
		     NULL);
      }
    }
}


void WclInterface::SendMessage(int msgnum)
{
  int i, nargs;
  if (msgnum < 0) {
    msgnum = CurrentMessage;
  } 
  Message myMsg;

  myMsg = getMessage(msgnum);
  myMsg.setNumber(msgnum);
  Val *v;
  IndexList& ilist = myMsg.getIndexList();
  nargs = ilist.numberArgs();
  for(i=0; i < nargs; i++) {
    int foobar = ilist.getArg(i);
    v = new Val;
    *v = SD.DefaultsTable.getArg(foobar);
//    Val &v = ilist.getArg(SD.DefaultsTable, i); // get the default val
    myMsg.addArgToValList(*v); // msg takes its arguments with it when it
                               // goes.
  }
  SD.executeMessage(myMsg);
}

void WclInterface::printOn(ostream &os)
{
	os << "WclInterface\n";
}
