/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

/*
 * SoundDevice.h: Implements a network sound device.
 *
 */


#ifndef SoundDevice_h
#define SoundDevice_h

#include "SoundObj.h"
#include "TCPSocket.h"
#include "SoundServer.h"
#include "MessageList.h"




class SoundDevice : public SoundObj {
/*
 * SoundDevice implements a network sound device.
 */
friend class UserInterface;
friend class WclInterface;
  


private:
  Bool_ synchronousMode, Connected;
  TCPSocket sock;
  ValList DefaultsTable, SystemParameters;
  MessageList Messages;
  char *SDName;
  
  int ackfd,fd;

public:
  /* Method SoundDevice: The SoundDevice constructor. */
  SoundDevice(char *RemoteHost, char *PortName, Bool_ ack = False_);
  SoundDevice(Bool_ ack = False_) { synchronousMode = ack; } ;

  /* Method ~SoundDevice: The SoundDevice destructor. */
  ~SoundDevice();
  
  /* Method setAcknowledge: Set flag to determine whether to block or not */
  void setAcknowledge(Bool_ ack) { synchronousMode = ack; } ;

  /* Method receive: Receive data */
  void receive(Data &v) { v.binReceive(fd); } ;

  /* Method openConnection: Open a connection to the host/port */
  Bool_ openConnection(char *RemoteHost, char *PortName);

  /* Method connected: Indicate whether we are connected or not */
  Bool_ connected() { return Connected; } ;

  /* Method defaults: Return the device defaults */
  ValList* defaults() { return &DefaultsTable; } ;

  /* Method sysparams: Return the device parameters */
  ValList* sysparams() { return &SystemParameters; } ;

  /* Method messages: Return the messages */
  MessageList* messages()  { return &Messages; } ;

  /* Method name: Return the device name */
  char* name() { return SDName; } ;

  /* Method getFd: Return the fd for the socket connection */
  int getFd() { return fd; } ;

  /* Method executeMessage: Execute a sonic message, or a message list */
  void executeMessage(MessageList &msglist);
  void executeMessage(Message &msg);
  void executeMessage(char *stringMessage);

  /* Method printOn: Stream output function */
  void printOn(ostream &os = cout);
};

inline ostream &operator<<(ostream &os, SoundDevice &obj)
{
	obj.printOn(os);
	return os;
}

#endif
