/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#include <stdlib.h>

#include "FileReader.h"


Bool_ FileReader::nextValue(double &d) 
{
  char s[256];

  if (fileSelected == False_) {
    cerr << "Error: FileReader::nextValue: attempt to read value when no file has been specified\n";
    return False_;
  }

  if (fgets(s, 256, fp) == NULL) {
    return False_;
  }

  sscanf(s, "%lf\n", &d);
  return True_;

}


Bool_ FileReader::nextValue(double *darray, int &length, const int maxsize) 
{
  char s[256];
  char *p;

  length=0;

  if (fileSelected == False_) {
    cerr << "Error: FileReader::nextValue: attempt to read value when no file has been specified\n";
    return False_;
  }

  if (fgets(s, 256, fp) == NULL) {
    return False_;
  }

  p = strtok(s, " \t");
  do {
    if (length < maxsize) {
      darray[length++] = atof(p);
    } else {
      cerr << form("Warning: FileReader::nextValue(): array length %d exceeded\n", maxsize);
      return True_;
    }
  } while ((p = strtok(NULL, " \t")) != NULL);
  return True_;
}

void FileReader::rewindFile()
{
  ::rewind(fp);
}

Bool_ FileReader::newFile(const char *filename) 
{
  FILE *newfp;

  if((newfp = fopen(filename, "r")) == NULL) {
    cerr << form("Error: FileReader::newFile: unable to open %s for input: %s\n",
	       filename, sys_errlist[errno]);
    return (False_);
  }
  
  if (fileSelected) {
    fclose(fp);
  } else {
    fileSelected = True_;
  }
  fp = newfp;
  return(True_);
}
  

void FileReader::printOn(ostream &os)
{
	os << "FileReader\n";
}

