/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */



#include "DemoInterface.h"



/* static */
void DemoInterface::generalXSWIMemberCallback(Widget w, 
							     void *rec, 
							     void *callData)
{
  struct XDemoInterfaceCBRec *foo = (XDemoInterfaceCBRec *) rec;
  DemoInterface *foobar = foo->userData;
  DemoInterfaceCallbackProc proc = foo->userProc;
  (foobar->*proc) (w, foo->userData, callData);
}



DemoInterface::DemoInterface(int argc, char **argv)
{ 


  running = False_;
  appName = duplicateString("demo");
  appClass = duplicateString("Demo");
  
  
  appShell = XtInitialize(appName, appClass, NULL, 0, &argc, argv);
  Display *dpy = XtDisplay(appShell);
}

void DemoInterface::registerCallbacks()
{
  registerMemberCallback( "MapToPitchCB", 
			  &DemoInterface::mapToPitchCallback, this );
  
  registerMemberCallback( "MapToVolumeCB", 
			  &DemoInterface::mapToVolumeCallback, this );

  registerMemberCallback( "MapToTimbreCB", 
			  &DemoInterface::mapToTimbreCallback, this );
  registerMemberCallback( "MapToDurationCB", 
			  &DemoInterface::mapToDurationCallback, this );

  registerMemberCallback( "TriggerAlarmsCB",
	 	          &DemoInterface::triggerAlarmsCallback, this );

  registerMemberCallback( "runCB",
	 	          &DemoInterface::runCallback, this );

  registerMemberCallback( "stopCB",
	 	          &DemoInterface::stopCallback, this );

}

void DemoInterface::create()
{
  registerCallbacks();

  app = XtWidgetToApplicationContext(appShell);

  MriRegisterMotif(app);
  WcWidgetCreation(appShell);

  if (filereader.newFile(DATAFILE) == False_) {
    cerr << form("Error: can't read %s\n", DATAFILE);
    cerr << "Try executing the runDemo script from ../../Demo\n";
    exit(1);
  }

  if ((PitchMapper = widgetReader.createWidget("MapToPitch.wcf")) == NULL) {
    cerr << "Try executing the runDemo script from ../../Demo\n";
    exit(1);
  }

  SW = PitchMapper;
  SW->setBlocking(1);
}

void DemoInterface::run()
{
  Display *dpy = XtDisplay(appShell);
  XtRealizeWidget(appShell);
  XtMainLoop();
}


DemoInterface::~DemoInterface()
{
  delete appName; 
  delete appClass; 
}
  
void DemoInterface::printOn(ostream &os)
{
	os << "DemoInterface\n";
}

void DemoInterface::runLoop()
{
  running = True_;
  double d;
  XEvent event;

  while(running) {
    if (filereader.nextValue(d)) {
      SW->execute(d);
      while(XtPending()) {
	XtNextEvent(&event);
	XtDispatchEvent(&event);
      }
    } else {
      filereader.rewindFile();
    }
  }
}

void DemoInterface::mapToVolumeCallback(Widget , void * , void * )
{

  if (VolumeMapper == NULL) {
    VolumeMapper = widgetReader.createWidget("MapToVolume.wcf");
    VolumeMapper->setBlocking(1);
  }
  
  SW = VolumeMapper;

}


void DemoInterface::mapToPitchCallback(Widget , 
					      void * ,
					      void * )
{

  if (PitchMapper == NULL) {
    PitchMapper =  widgetReader.createWidget("MapToPitch.wcf");
    PitchMapper->setBlocking(1);
  }
  
  SW = PitchMapper;

}

void DemoInterface::mapToTimbreCallback(Widget , 
					      void * ,
					      void * )
{

  if (TimbreMapper == NULL) {
    TimbreMapper =  widgetReader.createWidget("MapToTimbre.wcf");
    TimbreMapper->setBlocking(1);
  }
  
  SW = TimbreMapper;

}

void DemoInterface::mapToDurationCallback(Widget , 
					      void * ,
					      void * )
{

  if (DurationMapper == NULL) {
    DurationMapper =  widgetReader.createWidget("MapToDuration.wcf");
    DurationMapper->setBlocking(1);
  }
  
  SW = DurationMapper;

}

void DemoInterface::triggerAlarmsCallback(Widget , 
					      void * ,
					      void * )
{

  if (Alarms == NULL) {
    Alarms =  widgetReader.createWidget("TriggerAlarms.wcf");
    Alarms->setBlocking(1);
  }
  
  SW = Alarms;

}


void DemoInterface::runCallback(Widget , void * , void * )
{
  if (!running) {
    runLoop();
  }
}


void DemoInterface::stopCallback(Widget , void * , void * )
{
  running = False_;
}


void DemoInterface::registerMemberCallback(char *name, 
					   DemoInterfaceCallbackProc proc,
					   DemoInterface *data)
{
  XDemoInterfaceCBRec *rec = new XDemoInterfaceCBRec;

  rec->userData = data;
  rec->userProc = (DemoInterfaceCallbackProc) proc;

  WcRegisterCallback(app,
                     name,
                     (XtCallbackProc) generalXSWIMemberCallback,
                     rec);
}



