/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */


#include "BaseSonicWidget.h"
#include <stdarg.h>
						    
BaseSonicWidget::BaseSonicWidget(char *name) {
  myWidgetName = duplicateString(name);
  transformVal = new Val((int) 0);
  TF = NULL;
}

BaseSonicWidget::~BaseSonicWidget() {
  delete myWidgetName;
  delete transformVal;
}

/* virtual */
void BaseSonicWidget::writeWCF(ostream &os) const {
  os << myClassName() << NL;
  if (TF != NULL) {
    os << TF->printConfiguration("") << NL;
    os << SECTION << NL;
  }
  for(int i = 0; i < SCFlist.numberArgs(); i++) {
    ((SoundControlFile *)SCFlist.getElement(i))->writeSCF(os);
    os << SECTION << NL;
  }
}

/* virtual */
void BaseSonicWidget::writeSCF(ostream &os, int which) const {
  if (which >= SCFlist.numberArgs() ) {
    cerr << form("Error: %s::writeSCF: invalid SCF number %d\n", 
		 myClassName(), which);
  } else {
    ((SoundControlFile *)SCFlist.getElement(which))->writeSCF(os);
  }
}


/* virtual */
Bool_ BaseSonicWidget::initialize(SoundControlFile *widgetControlFile)
{
  SCFlist.addElement(widgetControlFile);
  return(True_);
}

/* virtual */
Bool_ BaseSonicWidget::initialize(SoundControlFile *widgetControlFile,
				  SoundControlFile *widgetControlFile2 ... )
{
  char *scfptr;

 SCFlist.addElement((void *) widgetControlFile);

  va_list ap;
  va_start( ap, widgetControlFile2 );
  SCFlist.addElement((void *) widgetControlFile2);
  while ((scfptr = va_arg(ap, char *)) != (char *) 0) {
    SCFlist.addElement((void *) scfptr);
  }
  va_end(ap);
  return(True_);
}
  



/* virtual */
char* BaseSonicWidget::writeParamsResourceFile(char *directory, int which)
{
//  cout << "calling BaseSonicWidget::writeParamsResourceFile\n";
  char *file = tempnam(directory, myWidgetName);

  if (which >= SCFlist.numberArgs()) {
    cerr << form("Error: %s::writeSCF: invalid SCF number %d\n", 
		 myClassName(), which);
    return NULL;
  } else {
//    cout << "There are " << SCFlist.numberArgs() << " elements in this list\n";
    if (((SoundControlFile *)SCFlist.getElement(which))->
	dumpParamsResourceFile(file,form("%sSCF%d", myWidgetName, which)) == False_) {
	  return NULL;
	} else {
	  return(file);
	}
  }
}
  

/* virtual */
void BaseSonicWidget::setBlocking(int ack) {
  for(int i=0; i < SCFlist.numberArgs(); i++) {
    ((SoundControlFile *)SCFlist.getElement(i))->setBlocking( (Bool_) ack );
  }
}

/* virtual */
Bool_ BaseSonicWidget::getHeader(char *soundControlFile, char *hostname, 
				 char *portname)
{
  filebuf fb;
  Bool_ status;
  SoundControlFile widgetControlFile;

  if (looksValid(soundControlFile) == False_) {
    return(False_);
  }

  if (fb.open(soundControlFile, input) == 0) {
    cerr << form("Error: %s::getHeader(): filename = %s,\
                  %s\n", myClassName(), soundControlFile, sys_errlist[errno]);
    return(False_);
  }

  istream from(&fb);
  status = widgetControlFile.readSoundDevice(from, hostname, portname);
  fb.close();
  return(status);
}  

Bool_ BaseSonicWidget::looksValid(char *soundControlFile) 
{
  char *tmp = soundControlFile;
  if (strcmp((tmp + (strlen(soundControlFile) - 4)), ".scf") != 0) {
    cerr << form("Error: %s::looksValid(): filename = %s,\
                  doesn't end in .scf\n", myClassName(), soundControlFile);
    return(False_);
  } else {
    return(True_);
  }
}



void BaseSonicWidget::printOn(ostream &os)
{
	os << form("%s Name: \"%s\"", myClassName(), myWidgetName);
}


