/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Roger J. Noe (noe@cs.uiuc.edu)
 * Contributing Author:  Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 *  SDDFparam.h:
 *	This file contains all the configurable parameters for
 *	the Pablo instrumentation interface library code which are
 *	dictated by the SDDF standard.
 */

/*
 *	SDDF packet types:
 *	   Constants dictated by the binary SDDF format to indicate
 *	   the packet type descriptor.  These are the members of the
 *	   PacketType enum in the file:
 *		Visual/Src/System/Includes/PacketHeader.h
 */

#define PIPE_EMPTY		0	/* "empty packet"		     */
#define PKT_ATTRIBUTE		1	/* stream attribute packet	     */
#define PKT_DESCRIPTOR		2	/* record descriptor		     */
#define PKT_DATA		3	/* record data			     */
#define PKT_COMMAND		4	/* command			     */
#define PKT_UNKNOWN		5	/* unknown packet type		     */

/*
 *	SDDF field types:
 *	   Constants dictated by the binary SDDF format to indicate
 *	   individual field types.  These are the members of the
 *	   MachineDataType enum in the file:
 *		Visual/Src/System/Includes/DataTraits.h
 */

#define CHARACTER		0	/* character type field		    */
#define INTEGER			1	/* integer type field		    */
#define FLOAT			2	/* float type field		    */
#define DOUBLE			3	/* double type field		    */
#define UNDEFINED		4	/* undefined type field		    */


/*
 *	SDDF header values:
 *	   Constants dictated by the binary SDDF format to indicate
 *	   the file header components.  These are the members of various
 *	   enums in the file:
 *		Visual/Src/System/Includes/DataCharacteristics.h
 */

					/* Byte ordering:		    */
#define	Sddf_BIG_ENDIAN		0	/* big endian			    */
#define	Sddf_LITTLE_ENDIAN	1	/* little endian		    */

					/* Integer format:		    */
#define	Sddf_TWOS_COMPLEMENT	0	/* two's complement		    */
#define	Sddf_ONES_COMPLEMENT	1	/* one's complement UNSUPPORTED	    */
#define	Sddf_SIGN_MAGNITUDE	2	/* sign-magnitude   UNSUPPORTED	    */

					/* Single-precision float format:   */
#define	Sddf_IEEE_S		0	/* IEEE				    */
#define	Sddf_VAX_S		1	/* VAX		    UNSUPPORTED	    */
#define	Sddf_IBM_S		2	/* IBM		    UNSUPPORTED	    */
#define	Sddf_CRAY_S		3	/* Cray		    UNSUPPORTED	    */

					/* Double-precision float format:   */
#define	Sddf_IEEE_D		0	/* IEEE				    */
#define	Sddf_VAX_D		1	/* VAX		    UNSUPPORTED	    */
#define	Sddf_IBM_D		2	/* IBM		    UNSUPPORTED	    */
#define	Sddf_CRAY_D		3	/* Cray		    UNSUPPORTED	    */

					/* Extra-precision float format:    */
#define	Sddf_IEEE_E		0	/* IEEE				    */
#define	Sddf_VAX_E		1	/* VAX		    UNSUPPORTED	    */
#define	Sddf_IBM_E		2	/* IBM		    UNSUPPORTED	    */
#define	Sddf_CRAY_E		3	/* Cray		    UNSUPPORTED	    */

					/* Character representation:	    */
#define	Sddf_ASCII		0	/* ASCII			    */
#define	Sddf_EBCDIC		1	/* EBCDIC	    UNSUPPORTED	    */
