/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Tara M. Madhyastha (tara@cs.uiuc.edu)
 * Contributing Author:  Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

#include "Assert.h"
#include "SystemDepend.h"
#include "SDDFparam.h"
#include "TraceParam.h"
#include "Trace.h"
#include "IOTrace.h"

initIOTrace()
{
	extern TR_RECORD	*readEventRecord();
	extern TR_RECORD	*writeEventRecord();
	extern TR_RECORD	*seekEventRecord();

	extern TR_RECORD        *openEventRecord();
	extern TR_RECORD        *closeEventRecord();

	/* Perform message-tracing extension pre-initialization, if not	    */
	/* already done.						    */

	preInitIOTrace();

	setEventRecordFunction( readBeginID, readEventRecord );
	setEventRecordFunction( freadBeginID, readEventRecord );
	setEventRecordFunction( writeBeginID, writeEventRecord );
	setEventRecordFunction( fwriteBeginID, writeEventRecord );
	setEventRecordFunction( fseekBeginID, seekEventRecord );
	setEventRecordFunction( lseekBeginID, seekEventRecord );
	setEventRecordFunction( fopenBeginID, openEventRecord );
	setEventRecordFunction( openBeginID, openEventRecord );

	setEventRecordFunction( readEndID, readEventRecord );
	setEventRecordFunction( freadEndID, readEventRecord );
	setEventRecordFunction( writeEndID, writeEventRecord );
	setEventRecordFunction( fwriteEndID, writeEventRecord );
	setEventRecordFunction( fseekEndID, seekEventRecord );
	setEventRecordFunction( lseekEndID, seekEventRecord );
	setEventRecordFunction( fopenEndID, openEventRecord );
	setEventRecordFunction( openEndID, openEventRecord );	


	setEventRecordFunction( fcloseBeginID, closeEventRecord );
	setEventRecordFunction( fcloseEndID, closeEventRecord );

	setEventRecordFunction( closeBeginID, closeEventRecord );
	setEventRecordFunction( closeEndID, closeEventRecord );

#ifdef DEBUG
	fprintf( debugFile, "ioTrace done\n" );
	fflush( debugFile );
#endif /* DEBUG */

	return SUCCESS;
}


/*
 *	ioSDDFdescriptor:
 *	   Generate a SDDF binary format record descriptor for the
 *	   full trace class of events in any of the IO families of
 *         events.
 */


TR_RECORD *
ioSDDFdescriptor( recordFamily, recordType, recordName, recordDescription )

int	recordFamily;
int	recordType;
char	*recordName;
char	*recordDescription;
{
	static TR_RECORD	traceRecord;
/* Make damn sure this buffer is big enough for largest trace record (with
comments) */
	static char		recordBuffer[ 2048 ];

	char			*recordPointer;
	char			*stringPointer;
	char s[256]; /* temporary string buffer */


	Assert( recordType == RECORD_TRACE );

	/* Allow space at the beginning of the record for the packet	    */
	/* length, which will be computed after the packet is complete.	    */

	recordPointer = recordBuffer;
	sddfWriteInteger( &recordPointer, 0 );

	/* Write the record type descriptor.				    */

	sddfWriteInteger( &recordPointer, PKT_DESCRIPTOR );

	/* Write the record tag descriptor.				    */

	sddfWriteInteger( &recordPointer, ( recordFamily | recordType ));

	/* Write the record name.					    */

	sddfWriteString( &recordPointer, recordName );

	/* Write the record attribute count.				    */

	sddfWriteInteger( &recordPointer, 1 );

	/* Write the record attribute string pair(s).			    */

	sddfWriteString( &recordPointer, "description" );

	sddfWriteString( &recordPointer, recordDescription );

	/* Write the record field count.				    */

/* I thought it would be a good idea to put the count of fields in
IOTrace.h and modifiy it there so that you don't forget to change this 
count -tara */

	switch ( recordFamily ) {
	case FAMILY_OPEN:
	  sddfWriteInteger( &recordPointer, OPEN_NUM_FIELDS);
	  break; 
	case FAMILY_READ:
	  sddfWriteInteger( &recordPointer, READ_NUM_FIELDS);
	  break;
	case FAMILY_WRITE:
	  sddfWriteInteger( &recordPointer, WRITE_NUM_FIELDS);
	  break;
	case FAMILY_SEEK:
	  sddfWriteInteger( &recordPointer, SEEK_NUM_FIELDS);
	  break;
	case FAMILY_CLOSE:
	  sddfWriteInteger( &recordPointer, CLOSE_NUM_FIELDS);
	  break;
	case FAMILY_SPACE_SUMMARY:
	  sddfWriteInteger( &recordPointer, SPACE_SUMMARY_NUM_FIELDS);
	  break;	  
	case FAMILY_TIME_SUMMARY:
	  sddfWriteInteger( &recordPointer, TIME_SUMMARY_NUM_FIELDS);
	  break;	  
	case FAMILY_LIFETIME:
	  sddfWriteInteger( &recordPointer, LIFETIME_NUM_FIELDS);
	  break;
	case FAMILY_HISTOGRAM:
	  sddfWriteInteger( &recordPointer, HISTOGRAM_NUM_FIELDS);
	  break;	  
	}



/* Helper macro to make this code easier */
#define dofield(name,attributeCount,attString1,attString2,type,dimension) \
	sddfWriteString( &recordPointer, name ); \
	sddfWriteInteger( &recordPointer, attributeCount ); \
	sddfWriteString( &recordPointer, attString1 ); \
	sddfWriteString( &recordPointer, attString2 ); \
	sddfWriteInteger( &recordPointer, type ); \
	sddfWriteInteger( &recordPointer, dimension ); 

	/* Having this be a switch statement makes it easy to change things
	   but you must be careful because some of this code is duplicated
	   in the other system dependent parts */

	switch (recordFamily) {
	case FAMILY_READ:
	case FAMILY_WRITE:
	  dofield("Timestamp",1,"Timestamp","Timestamp",INTEGER,1);
	  dofield("Seconds",1,"Seconds","Floating Point Timestamp",DOUBLE,0);
	  dofield("Duration",1,"Duration","Floating Point Duration",DOUBLE,0);
	  dofield("Event Identifier",1,"ID","Event ID", INTEGER,0);
	  dofield("Node Identifier",1,"Node","Node ID", INTEGER,0);	  
	  dofield("File Pointer",1,"FP","File Pointer", INTEGER, 0);
	  dofield("Number Bytes",1,"Bytecount","Number Bytes",INTEGER,0);
	  dofield("Number Variables",1,"Varcount","Number Variables",INTEGER,0);
	  dofield("Cause",1,"Cause","IO Cause (-1 if produced by automatic instrumentation)",INTEGER,0);
	  break;
	case FAMILY_SEEK:
	  dofield("Timestamp",1,"Timestamp","Timestamp",INTEGER,1);
	  dofield("Seconds",1,"Seconds","Floating Point Timestamp",DOUBLE,0);
	  dofield("Duration",1,"Duration","Floating Point Duration",DOUBLE,0);
	  dofield("Event Identifier",1,"ID","Event ID", INTEGER,0);
	  dofield("Node Identifier",1,"Node","Node ID", INTEGER,0);	  
	  dofield("File Pointer",1,"FP","File Pointer", INTEGER, 0);
	  dofield("Offset",1,"Offset","Offset",INTEGER,0);
	  dofield("Ptrname",1,"Ptrname","Ptrname",INTEGER,0);
	  break;
	case FAMILY_SPACE_SUMMARY:	
	  dofield("Timestamp",1,"Timestamp","Timestamp",INTEGER,1);
	  dofield("Seconds",1,"Seconds","Floating Point Timestamp",DOUBLE,0);
	  dofield("Event ID",1,"Event ID","Event Identifier", INTEGER,0);
	  dofield("Closed",1,"Closed","Flag is true if this record was generated due to a file close, implying file ID will be reused",INTEGER,0);
	  dofield("Node ID",1,"Node ID","Processor(node) identifier", INTEGER,0);
	  dofield("File ID",1,"File ID","File identifier (file descriptor or unit number) to which all fields in this record pertain", INTEGER,0);
	  dofield("Read Count",1,"Read Count","Number of Read calls made in this time period",INTEGER,0);
	  dofield("Read Number Bytes",1,"Read Number Bytes","Total number of bytes read in this space interval",INTEGER,0);
	  dofield("Read Time",1,"Read Time","Total time spent in reads within this space interval",FLOAT,0);
	  dofield("Write Count",1,"Write Count","Number of Write calls made within this space interval",INTEGER,0);
	  dofield("Write Number Bytes",1,"Write Number Bytes","Total number of bytes written in this space interval",INTEGER,0);
	  dofield("Write Time",1,"Write Time","Total time spent in writes within this space interval",FLOAT,0);
	  dofield("Seek Count",1,"Seek Count","Number of Seeks made within this space interval",INTEGER,0);
	  dofield("Seek Number Bytes",1,"Seek Number Bytes","Total distance, in bytes, seeked within this space interval",INTEGER,0);
	  dofield("Seek Time",1,"Seek Time","Total time spent seeking within this space interval",FLOAT,0);
	  dofield("First Byte",1,"First Byte","First byte accessed within this space interval",INTEGER,0);
	  dofield("Last Byte",1,"Last Byte","Last byte accessed within this space interval",INTEGER,0);
	  break;
	case FAMILY_LIFETIME:
	  dofield("Timestamp",1,"Timestamp","Timestamp",INTEGER,1);
	  dofield("Seconds",1,"Seconds","Floating Point Timestamp",DOUBLE,0);
	  dofield("Event ID",1,"Event ID","Event identifier", INTEGER,0);
	  dofield("File ID",1,"File ID","File identifier (file descriptor or unit number) to which all fields in this record pertain", INTEGER,0);
	  dofield("Node Identifier",1,"Node","Node ID", INTEGER,0);	  
	  dofield("Dummy Int",1,"Dummy","Dummy", INTEGER,0);
	  dofield("File Lifetime",1,"File Lifetime","Time between end of file open and begin of file close events",DOUBLE,0);
	  dofield("Overhead",1,"Overhead","Time spent in file open and file close",DOUBLE,0);
	  dofield("Read Count",1,"Read Count","Total number of reads during file lifetime",INTEGER,0);
	  dofield("Read Number Bytes",1,"Read Number Bytes","Total number of bytes read during file lifetime",INTEGER,0);
	  dofield("Read Time",1,"Read Time","Total time spent reading during file lifetime",DOUBLE,0);
	  dofield("Write Count",1,"Write Count","Total number of writes during file lifetime",INTEGER,0);
	  dofield("Write Number Bytes",1,"Write Number Bytes","Total number of bytes written during file lifetime",INTEGER,0);
	  dofield("Write Time",1,"Write Time","Total time spent writing during file lifetime",DOUBLE,0);
	  dofield("Seek Count",1,"Seek Count","Total number of seeks during file lifetime",INTEGER,0);
	  dofield("Seek Number Bytes",1,"Seek Number Bytes","Total distance, in bytes, seeked during file lifetime",INTEGER,0);
	  dofield("Seek Time",1,"Seek Time","Total time spent seeking during file lifetime",DOUBLE,0);
	  dofield("Mode",1,"Mode","Mode in which file was opened",INTEGER,0);  
	  dofield("File Name",1,"File Name","File name, as specified upon open", CHARACTER,1);
	  break;
	case FAMILY_TIME_SUMMARY:
	  dofield("Timestamp",1,"Timestamp","Timestamp",INTEGER,1);
	  dofield("Seconds",1,"Seconds","Floating Point Timestamp",DOUBLE,0);
	  dofield("Start",1,"Start","Time window supposedly began",DOUBLE,0);
	  dofield("Closed",1,"Closed","Flag is true if this record was generated due to a file close, implying file ID will be reused",INTEGER,0);
	  dofield("Event ID",1,"Event ID","Event Identifier", INTEGER,0);
	  dofield("Node ID",1,"Node ID","Processor/node Identifier", INTEGER,0);
	  dofield("File ID",1,"File ID","File identifier (file descriptor or unit number) to which all fields in this record pertain", INTEGER,0);
	  dofield("Read Count",1,"Read Count","Number of Read calls made in this time period",INTEGER,0);
	  dofield("Read Number Bytes",1,"Read Number Bytes","Number of bytes read in this time period",INTEGER,0);
	  dofield("Read Time",1,"Read Time","Total time spent reading in this time period",FLOAT,0);
	  dofield("Write Count",1,"Write Count","Number of write calls made in this time period",INTEGER,0);
	  dofield("Write Number Bytes",1,"Write Number Bytes","Number bytes written in this time period",INTEGER,0);
	  dofield("Write Time",1,"Write Time","Total time spent writing in this time period",FLOAT,0);
	  dofield("Seek Count",1,"Seek Count","Number of seeks made in this time period",INTEGER,0);
	  dofield("Seek Number Bytes",1,"Seek Number Bytes","Total distance (in bytes) seeked in this time period",INTEGER,0);
	  dofield("Seek Time",1,"Seek Time","Total time spent seeking during this time period",FLOAT,0);
	  dofield("First Byte",1,"First Byte","First byte accessed in this time period",INTEGER,0);
	  dofield("Last Byte",1,"Last Byte","Last byte accessed in this time period",INTEGER,0);
	  break;
	case FAMILY_OPEN:
	  dofield("Timestamp",1,"Timestamp","Timestamp",INTEGER,1);
	  dofield("Seconds",1,"Seconds","Floating Point Timestamp",DOUBLE,0);
	  dofield("Total IO Time",1,"Total Time","IO Time",DOUBLE,0);
	  sprintf(s, "Event identifier (%d = open, %d = fopen)", openBeginID,
		  fopenBeginID);
	  dofield("Event ID",1,"Event ID",s, INTEGER,0);
	  dofield("Node ID",1,"Node ID","Node Identifier", INTEGER,0);	  
	  dofield("File ID",1,"File ID","File identifier (file descriptor or unit number) to which all fields in this record pertain", INTEGER,0);	  
	  dofield("Flags",1,"Flags","Flags supplied at file open",INTEGER,0);  
	  dofield("Mode",1,"Mode","Mode supplied at file open",INTEGER,0);  
	  dofield("File Name",1,"File Name","Name of file supplied at file open", CHARACTER,1);
	  break; 
	case FAMILY_HISTOGRAM:
	  dofield("Timestamp",1,"Timestamp","Timestamp",INTEGER,1);
	  dofield("Seconds",1,"Seconds","Floating Point Timestamp",DOUBLE,0); 
	  dofield("Event Identifier",1,"ID","Event ID", INTEGER,0);
	  dofield("Node Identifier",1,"Node","Node ID", INTEGER,0);	  
	  dofield("Histogram Data",1,"Histogram", "Histogram", INTEGER,1);
	  break;
	case FAMILY_CLOSE:
	  dofield("Timestamp",1,"Timestamp","Timestamp",INTEGER,1);
	  dofield("Seconds",1,"Seconds","Floating Point Timestamp",DOUBLE,0);
	  dofield("Total IO Time",1,"Total Time","IO Time",DOUBLE,0);
	  dofield("Event Identifier",1,"ID","Event ID", INTEGER,0);
	  dofield("Node Identifier",1,"Node","Node ID", INTEGER,0);	  
	  dofield("File Identifier",1,"File ID","File ID", INTEGER,0);
	  break; 
	}

	/* The entire record descriptor packet has been written.	    */

	traceRecord.recordLength = recordPointer - recordBuffer;
	traceRecord.recordContents = recordBuffer;

	/* Finally, copy the completed packet length at the beginning	    */
	/* of the record itself.					    */

	recordPointer = recordBuffer;
	sddfWriteInteger( &recordPointer, traceRecord.recordLength );

	return & traceRecord;
}



/*
 *	writeIORecordDescriptors:
 *	   This function generates the record descriptors for the
 *	   I/O event families.  It will be invoked
 *	   by the instrumentation library initialization routines.
 *	   Patterned after instrumentation library internal function
 *	   writeRecordDescriptors.
 */

writeIORecordDescriptors()
{
  TR_RECORD	*recordPointer, *mesgSDDFdescriptor();

#ifdef DEBUG
  fprintf( debugFile, "writeIORecordDescriptors\n" );
  fflush( debugFile );
#endif /* DEBUG */

#define putbytes(FAMILY, TYPE, name1, name2)  \
  recordPointer = ioSDDFdescriptor( FAMILY, \
				     TYPE,\
				     name1,\
				     name2);\
       putBytes( recordPointer->recordContents,\
		(unsigned) recordPointer->recordLength );

  putbytes(FAMILY_READ, RECORD_TRACE, "Read", "IO Read");
  putbytes(FAMILY_WRITE, RECORD_TRACE, "Write", "IO Write");
  putbytes(FAMILY_SEEK, RECORD_TRACE, "Seek", "IO Seek");
  putbytes(FAMILY_OPEN, RECORD_TRACE, "Open", "IO Open");  
  putbytes(FAMILY_CLOSE, RECORD_TRACE, "Close", "IO File Close"); 
  putbytes(FAMILY_SPACE_SUMMARY, RECORD_TRACE, "Space Summary", "IO Space Summary");
  putbytes(FAMILY_TIME_SUMMARY, RECORD_TRACE, "Time Summary", "IO Time Window Summary");
  putbytes(FAMILY_LIFETIME, RECORD_TRACE, "File Lifetime Summary", 
	   "IO File lifetime summary ");
  putbytes(FAMILY_HISTOGRAM, RECORD_TRACE, "Histogram Data", 
	   "IO Histogram Data");
  return;
}



/* is the eventID an open/close? This is in the system dependent part
because event IDs and their meanings are system dependent, whereas the
portable code can be written using these routines */

int isOpenCloseEvent(eventID) 
     int eventID;
{
  return((eventID == fopenBeginID) ||
	 (eventID == fopenEndID) ||
	 (eventID == fcloseBeginID) ||
	 (eventID == fcloseEndID)||
	 (eventID == openBeginID) ||
	 (eventID == closeBeginID) ||
	 (eventID == openEndID) ||
	 (eventID == closeEndID));
}

/* the "is" routines below provide a portable way of checking the
"nature" of system dependent event ids, which sometimes can be treated
alike. A new event id should be added here and in similar calls in all
system dependent files, not in the portable part of the library */

/* is this eventID a close begin? */

int isCloseBeginEvent(eventID) 
     int eventID;
{
  return((eventID == closeBeginID) ||
	 (eventID == fcloseBeginID));
}

int isCloseEndEvent(eventID) 
     int eventID;
{
  return((eventID == closeEndID) ||
	 (eventID == fcloseEndID));
}
int isOpenBeginEvent(eventID)
     int eventID;
{
  return((eventID == openBeginID) ||
	 (eventID == fopenBeginID));
}

int isOpenEndEvent(eventID)
     int eventID;
{
  return((eventID == openEndID) ||
	 (eventID == fopenEndID));
}


int isReadEndEvent(eventID) 
     int eventID;
{
  return (eventID == readEndID   ||
	  eventID == freadEndID );
}

int isReadBeginEvent(eventID) 
     int eventID;
{
  return (eventID == readBeginID   ||
	  eventID == freadBeginID );
}

int isWriteEndEvent(eventID) 
     int eventID;
{
  return (eventID == writeEndID   ||
	  eventID == fwriteEndID );
}

int isWriteBeginEvent(eventID) 
     int eventID;
{
  return (eventID == writeBeginID   ||
	  eventID == fwriteBeginID );
}

int isSeekEndEvent(eventID)
     int eventID;
{
  return(eventID == fseekEndID ||
	 eventID == lseekEndID);
}

int isSeekBeginEvent(eventID)
     int eventID;
{
  return(eventID == fseekBeginID ||
	 eventID == lseekBeginID);
}

doFileSummariesSystemDependent()
{ };

doTimeSummariesSystemDependent()
{ };

doBlockSummariesSystemDependent()
{ };

