/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Keith A. Shields (shields@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 *
 */


#include "SubsetDialog.h"



/****************************************************************************
*****************************************************************************/
void addListScrollBarCallbacks(listVScroll)
     Widget listVScroll;
{
  XtAddCallback(listVScroll, XmNdragCallback, listVScrollMoved, 
		NULL);
  XtAddCallback(listVScroll, XmNincrementCallback, listVScrollMoved, 
		NULL);
  XtAddCallback(listVScroll, XmNdecrementCallback, listVScrollMoved, 
		NULL);
  XtAddCallback(listVScroll, XmNvalueChangedCallback, listVScrollMoved, 
		NULL);
  XtAddCallback(listVScroll, XmNpageIncrementCallback,listVScrollMoved, 
		NULL);
  XtAddCallback(listVScroll, XmNpageDecrementCallback,listVScrollMoved, 
		NULL);
  XtAddCallback(listVScroll, XmNtoTopCallback,listVScrollMoved, 
		NULL);
  XtAddCallback(listVScroll, XmNtoBottomCallback,listVScrollMoved, 
		NULL);
}



/**************************************************************************** 
*****************************************************************************/
Boolean addUniqueItemToSubsetList(stringToCompare, stringToAdd)
     char *stringToCompare;
     char *stringToAdd;
{
  XmString compareXStr, addXStr;
  Boolean success=False;
  
  compareXStr = XmStringCreateSimple(stringToCompare);
  addXStr = XmStringCreateSimple(stringToAdd);

  if ((XmStringCompare(SelectedRoutine, compareXStr)) &&
      (! XmListItemExists(SubsetList, addXStr))) {
    XmListAddItemUnselected(SubsetList, addXStr, 0);
    success=True;
  }
  
  XmStringFree(compareXStr);
  XmStringFree(addXStr);

  return(success);
}



/****************************************************************************
  This function specifies the dialog used to instrument a subset of calls.
  It is used whenever the user wishes to instrument a specific group of
  routines that call/are called by the currently selected routine in the
  main window list.  The functionality of the dialog is essentially the same
  in either case, so one is created and popped up/down as needed.  It will
  be popped up with its grabKind as exclusive, so only one is needed. Labels
  and some globals will be changed to indicate whether called/calling routines
  are under consideration
*****************************************************************************/
void createSubsetDialog(mainWin)
     Widget mainWin;
{
  Widget subsetPW; 

  ListSliderSize = 0;

  SubsetDialog = 
    XtCreatePopupShell("SubsetDialog", topLevelShellWidgetClass, mainWin, 
		       NULL, 0);
  subsetPW = 
    XtVaCreateWidget ("subsetPW", xmPanedWindowWidgetClass, SubsetDialog, 
		      XmNsashWidth, 1, XmNsashHeight, 1, NULL);

  makeSubsetPane1(subsetPW);
  makeSubsetPane2(subsetPW);

  XtManageChild(subsetPW);
}



/**************************************************************************** 
*****************************************************************************/
void destroySubsetSymbols()
{
  int i;

  for (i=0; i<ListSliderSize; i++) {
    if (ListInstrumentationSymbols[i] != NULL) {
      XtDestroyWidget(ListInstrumentationSymbols[i]);
      ListInstrumentationSymbols[i] = NULL;
    }
    free(ListData[i].item);
  }
  XmListDeleteAllItems(SubsetList);
  free(ListData);
  NumSubsetItems = 0;

  ListData = (listItemStruct *) malloc(sizeof(listItemStruct));
  initializeSubsetSymbols(0,0);
}



/**************************************************************************** 

*****************************************************************************/
void getUnselectedPos(numItems, numSelectedItems, selectedPositions, 
		      unselectedPositions)
     int numItems;
     int numSelectedItems;
     int *selectedPositions;
     int *unselectedPositions;
{
  int i, j, unselected_idx=0;
  Boolean match;
  
  for (i=1; i<=numItems; i++) {
    match = False;
    for (j=0; j<numSelectedItems; j++) {
      if (selectedPositions[j] == i) {
	match = True;
      }
    }

    if (! match) {
      unselectedPositions[unselected_idx] = i;
      unselected_idx++;
    }
  }
}



/**************************************************************************** 
*****************************************************************************/
void initializeSubsetSymbols(startSymNum, endSymNum)
     int startSymNum;
     int endSymNum;
{
  int i, sliderSize;
  XmFontList fontList;
  XmString tmpXStr;
  Dimension hiThick;

  XtVaGetValues(SubsetList, 
		XmNfontList, &fontList, 
		XmNhighlightThickness, &hiThick,
		NULL);

  tmpXStr = XmStringCreateSimple("N");
  ListLineHeight = (int) XmStringHeight(fontList, tmpXStr);

  for (i=startSymNum; i<=endSymNum; i++) {
    ListInstrumentationSymbols[i] = 
      XtVaCreateManagedWidget("label", xmLabelWidgetClass, SubsetSymForm, 
			      XmNborderWidth, 0, 
			      XmNwidth, null_width, 
			      XmNheight, null_height, 
			      XmNlabelType, XmPIXMAP, 
			      XmNlabelPixmap, NullPix,
			      XmNx, 5, 
			      XmNy, (null_height/2)+
			            i*(ListLineHeight+
				       2*hiThick),
			      NULL);
  }
}



/**************************************************************************** 
*****************************************************************************/
void instrumentExceptSelectedSubset(button, client_data, call_data)
     Widget button;
     XtPointer client_data;
     XtPointer call_data;
{
  INSTREC *tmpPtr = instrumentHead;
  XmString invokingXString, invokedXString;
  XmStringTable listItems;
  int *selected_positions, *unselected_positions, num_selected, num_unselected,
      numItems, i, j;

  if (!XmListGetSelectedPos(SubsetList, &selected_positions, &num_selected)) {
    num_selected = 0;
    selected_positions = NULL;
  }

  XtVaGetValues(SubsetList, XmNitems, &listItems, XmNitemCount, &numItems,
		NULL);

  if ((num_unselected = numItems - num_selected) != 0) {

    unselected_positions = (int *) malloc(num_unselected*sizeof(int));

    getUnselectedPos(numItems, num_selected, selected_positions, 
		     unselected_positions);

    while (tmpPtr != NULL) {
      invokingXString = XmStringCreateSimple(tmpPtr->invokingFunc);
      invokedXString = XmStringCreateSimple(tmpPtr->invokedFunc);

      switch (DialogType) {

      case subsetIn:
	if (XmStringCompare(SelectedRoutine, invokingXString)) {
	  for (i=0; i<num_unselected; i++) {
	    if (XmStringCompare(listItems[unselected_positions[i]-1],
				invokedXString)) {
	      tmpPtr->instrumentType = DialogInstrumentationType;
	      ListData[unselected_positions[i]-1].instrumentationType = 
		DialogInstrumentationType;
	      LineData[tmpPtr->beginLine-1].instrumentationType =
		DialogInstrumentationType;
	    }
	  }
	}
	break;

      case subsetTo:
	if (XmStringCompare(SelectedRoutine, invokedXString)) {
	  for (i=0; i<num_unselected; i++) {
	    if (XmStringCompare(listItems[unselected_positions[i]-1],
				invokingXString)) {
	      tmpPtr->instrumentType = DialogInstrumentationType;
	      ListData[unselected_positions[i]-1].instrumentationType = 
		DialogInstrumentationType;
	      LineData[tmpPtr->beginLine-1].instrumentationType =
		DialogInstrumentationType;
	    }
	  }
	}
	break;
      
      case multipleOnLine:
	for (i=0; i<num_unselected; i++) {
	  ListData[unselected_positions[i]-1].instrumentableStructure->
	    instrumentType = DialogInstrumentationType;
	  ListData[unselected_positions[i]-1].instrumentationType = 
	    DialogInstrumentationType;
	  LineData[tmpPtr->beginLine-1].instrumentationType =
	    DialogInstrumentationType;
	}
	break;
      }
      
      XmStringFree(invokingXString);
      XmStringFree(invokedXString);
      tmpPtr = tmpPtr->next;
    }

    free(selected_positions);
    free(unselected_positions);
  }

  updateListSymbols();
  updateTextSymbols();

  XmListDeselectAllItems(SubsetList);
  StateChangedSinceSave = True;
}



/**************************************************************************** 
*****************************************************************************/
void instrumentSelectedSubset(button, client_data, call_data)
     Widget button;
     XtPointer client_data;
     XtPointer call_data;
{
  INSTREC *tmpPtr = instrumentHead;
  XmString invokingXString, invokedXString;
  XmStringTable listItems;
  int *selected_positions, num_selected, i;

  if (XmListGetSelectedPos(SubsetList, &selected_positions, &num_selected)) {
    XtVaGetValues(SubsetList, XmNitems, &listItems, NULL);
    while (tmpPtr != NULL) {
      invokingXString = XmStringCreateSimple(tmpPtr->invokingFunc);
      invokedXString = XmStringCreateSimple(tmpPtr->invokedFunc);

      switch (DialogType) {

      case subsetIn:
	/* want to instrument calls in a certain routine, so we check
	   to see if that routine is the invoking routine for the
	   current item in the linked list.  If so, we set that item's
	   instrumentation type to none.  If the item's invoked routine
	   is one of the routines selected in the subset list, the item's
	   instrumentation type is set to the appropriate type depending on
	   which instrumentation type toggle button is currently set. */
	if (XmStringCompare(SelectedRoutine, invokingXString)) {
	  for (i=0; i<num_selected; i++) {
	    if (XmStringCompare(listItems[selected_positions[i]-1],
				invokedXString)) {
	      tmpPtr->instrumentType = DialogInstrumentationType;
	      ListData[selected_positions[i]-1].instrumentationType = 
		DialogInstrumentationType;
	      LineData[tmpPtr->beginLine-1].instrumentationType =
		DialogInstrumentationType;
	    }
	  }
	}
	break;
	
      case subsetTo:
	/* want to instrument calls to a certain routine, so we check
	   to see if that routine is the invoked routine for the
	   current item in the linked list.  If so, we set that item's
	   instrumentation type to none.  If the item's invoking routine
	   is one of the routines selected in the subset list, the item's
	   instrumentation type is set to the appropriate type depending on
	   which instrumentation type toggle button is currently set. */
	if (XmStringCompare(SelectedRoutine, invokedXString)) {
	  for (i=0; i<num_selected; i++) {
	    if (XmStringCompare(listItems[selected_positions[i]-1],
				invokingXString)) {
	      tmpPtr->instrumentType = DialogInstrumentationType;
	      ListData[selected_positions[i]-1].instrumentationType = 
		DialogInstrumentationType;
	      LineData[tmpPtr->beginLine-1].instrumentationType =
		DialogInstrumentationType;
	    }
	  }
	}
	break;

      case multipleOnLine:
	for (i=0; i<num_selected; i++) {
	  ListData[selected_positions[i]-1].instrumentableStructure->
	    instrumentType = DialogInstrumentationType;
	  ListData[selected_positions[i]-1].instrumentationType = 
	    DialogInstrumentationType;
	  LineData[tmpPtr->beginLine-1].instrumentationType =
	    DialogInstrumentationType;
	}
	break;
      }

      XmStringFree(invokingXString);
      XmStringFree(invokedXString);
      tmpPtr = tmpPtr->next;
    }

    free(selected_positions);
    XmListDeselectAllItems(SubsetList);
    StateChangedSinceSave = True;

  updateListSymbols();
  updateTextSymbols();
  }
}



/**************************************************************************** 
*****************************************************************************/
void listResizeHandler(list, client_data, event)
     Widget list;
     XtPointer client_data;
     XEvent *event;
{
  Widget listVScroll;
  int i, oldSliderSize;

  oldSliderSize = ListSliderSize;

  XtVaGetValues(XtParent(list), XmNverticalScrollBar, &listVScroll, NULL);
  XtVaGetValues(listVScroll, XmNsliderSize, &ListSliderSize, NULL);

  for (i=0; i<oldSliderSize; i++) {
    if (ListInstrumentationSymbols[i] != NULL) {
      XtDestroyWidget(ListInstrumentationSymbols[i]);
      ListInstrumentationSymbols[i] = NULL;
    }
  }

  initializeSubsetSymbols(0, ListSliderSize-1);

  updateListSymbols();
}


/**************************************************************************** 
*****************************************************************************/
void listVScrollMoved(listVScroll, client_data, call_data)
     Widget listVScroll;
     XtPointer client_data;
     XtPointer call_data;
{
  updateListSymbols();
}



/****************************************************************************
*****************************************************************************/
void makeSubsetInstrumentationTypeToggles(form)
     Widget form;
{
  Widget typeLabel, typeFrame, typeRB, traceTB, countTB, noneTB;

  typeLabel = 
    XtCreateManagedWidget("typeLabel", xmLabelWidgetClass, form, NULL, 0);

  typeFrame = 
    XtCreateWidget("typeFrame", xmFrameWidgetClass, form, NULL, 0);

  typeRB = 
    XmCreateRadioBox(typeFrame, "typeRB", NULL, 0);

  traceTB = 
    XtVaCreateManagedWidget("trace", xmToggleButtonWidgetClass, typeRB,
			    XmNset, True, NULL);
  
  countTB = 
    XtCreateManagedWidget("count", xmToggleButtonWidgetClass, typeRB, 
			  NULL, 0);

  noneTB = 
    XtCreateManagedWidget("none", xmToggleButtonWidgetClass, typeRB, 
			  NULL, 0);

  DialogInstrumentationType = InstrumentTrace;

  XtAddCallback(traceTB, XmNvalueChangedCallback, setDialogInstrumentationType,
		InstrumentTrace);
  XtAddCallback(countTB, XmNvalueChangedCallback, setDialogInstrumentationType,
		InstrumentCount);
  XtAddCallback(noneTB, XmNvalueChangedCallback, setDialogInstrumentationType,
		InstrumentOff);

  XtManageChild(typeRB);
  XtManageChild(typeFrame);
}



/****************************************************************************
*****************************************************************************/
void makeSubsetPane1(panedWin)
     Widget panedWin; 
{
  Widget pane1Form, frame, listVScroll, symbolVScroll, symbolHScroll;

  pane1Form = 
    XtCreateWidget ("pane1Form", xmFormWidgetClass, panedWin, NULL, 0);

  frame = 
    XtCreateWidget("frame", xmFrameWidgetClass, pane1Form, NULL, 0);

  ScrollForm = 
    XtCreateWidget("ScrollForm", xmFormWidgetClass, frame, NULL, 0);

  SubsetList = 
    XmCreateScrolledList(ScrollForm, "SubsetList", NULL, 0);

  SubsetSymForm = 
    XtCreateManagedWidget("SubsetSymForm", xmFormWidgetClass, 
			  ScrollForm, NULL, 0);

  XtVaSetValues(XtParent(SubsetList), 
		XmNleftWidget, SubsetSymForm, 
		XmNleftOffset, 4,
		NULL);

  XtVaGetValues(XtParent(SubsetList), 
		XmNverticalScrollBar, &listVScroll, 
                NULL);

  XtVaSetValues(SubsetList, XmNshadowThickness, 0, NULL);

  addListScrollBarCallbacks(listVScroll);

  CallingLabel = 
    XtCreateManagedWidget("CallingLabel", xmLabelWidgetClass, pane1Form, NULL, 
			  0);

  CurrentRoutineLabel =
    XtCreateManagedWidget("CurrentRoutineLabel", xmLabelWidgetClass, pane1Form,
			  NULL, 0);

  makeSubsetInstrumentationTypeToggles(pane1Form);
  makeSubsetSelectionButtons(pane1Form);

  XtAddEventHandler(SubsetList, ExposureMask, FALSE, listResizeHandler,
		    NULL);

  XtManageChild(SubsetList);
  XtManageChild(ScrollForm);
  XtManageChild(frame);
  XtManageChild(pane1Form);
}


/****************************************************************************
*****************************************************************************/
void makeSubsetPane2(panedWin)
     Widget panedWin; 
{
  Widget pane2Form, ok, help;
  Dimension h;

  pane2Form = 
    XtCreateWidget ("pane2Form", xmFormWidgetClass, panedWin, NULL, 0);

  ok = 
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, pane2Form, NULL, 0);

  help = 
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, pane2Form, NULL,
			  0);

  XtAddCallback(ok, XmNactivateCallback, subsetOKCallback, NULL);
  XtAddCallback(help, XmNactivateCallback, generateHelp, SUBSET_HELP_TEXT);

  XtVaGetValues(ok,XmNheight, &h, NULL);
  XtVaSetValues(pane2Form, XmNpaneMaximum, h, XmNpaneMinimum, h, NULL);

  XtManageChild(pane2Form);
}



/****************************************************************************
*****************************************************************************/
void makeSubsetSelectionButtons(form)
     Widget form;
{
  Widget buttonFrame, frameForm, selected, except;

  buttonFrame = 
    XtCreateWidget("buttonFrame", xmFrameWidgetClass, form, NULL, 0);

  frameForm = 
    XtCreateWidget("frameForm", xmFormWidgetClass, buttonFrame, NULL, 0);

  selected = 
    XtCreateManagedWidget("selected", xmPushButtonWidgetClass, frameForm, 
			  NULL, 0);
  except = 
    XtCreateManagedWidget("except", xmPushButtonWidgetClass, frameForm, NULL, 
			  0);

  XtAddCallback(selected, XmNactivateCallback, instrumentSelectedSubset, NULL);
  XtAddCallback(except, XmNactivateCallback, instrumentExceptSelectedSubset, 
		NULL);

  XtManageChild(frameForm);
  XtManageChild(buttonFrame);
}



/**************************************************************************** 

*****************************************************************************/
void popupSubsetDialog()
{

  XtVaSetValues(File, XmNsensitive, False, NULL);
  XtVaSetValues(Global, XmNsensitive, False, NULL);
  XtVaSetValues(Routine, XmNsensitive, False, NULL);
  XtVaSetValues(Help, XmNsensitive, False, NULL);
  XtVaSetValues(TraceButton, XmNsensitive, False, NULL);
  XtVaSetValues(CountButton, XmNsensitive, False, NULL);
  XtVaSetValues(ClearButton, XmNsensitive, False, NULL);

  XtPopup(SubsetDialog, XtGrabNone);
}


/**************************************************************************** 
*****************************************************************************/
void setDialogInstrumentationType(button, inst_type, call_data)
     Widget button;
     INSTTYPES inst_type;
     XtPointer call_data;
{
  DialogInstrumentationType = inst_type;
}



/**************************************************************************** 

*****************************************************************************/
void setSubsetDialogValues(subsetTitle, subsetItem, subsetCallLabel)
     char *subsetTitle;
     char *subsetItem;
     char *subsetCallLabel;

{
  XmString tmpStr, tmpStr2;

  tmpStr = XmStringCreateSimple(subsetCallLabel);
  tmpStr2 = XmStringCreateSimple(subsetItem);

  XtVaSetValues(SubsetDialog, XmNtitle, subsetTitle, NULL);
  XtVaSetValues(CallingLabel, XmNlabelString, tmpStr, NULL);
  XtVaSetValues(CurrentRoutineLabel, XmNlabelString, tmpStr2, NULL);

  XmStringFree(tmpStr);
  XmStringFree(tmpStr2);
}



/**************************************************************************** 
*****************************************************************************/
void subsetOKCallback(button, client_data, call_data)
     Widget button;
     XtPointer client_data;
     XtPointer call_data;
{
  XtPopdown(SubsetDialog);
  destroySubsetSymbols();

  XtVaSetValues(File, XmNsensitive, True, NULL);
  XtVaSetValues(Global, XmNsensitive, True, NULL);
  XtVaSetValues(Routine, XmNsensitive, True, NULL);
  XtVaSetValues(Help, XmNsensitive, True, NULL);
  XtVaSetValues(TraceButton, XmNsensitive, True, NULL);
  XtVaSetValues(CountButton, XmNsensitive, True, NULL);
  XtVaSetValues(ClearButton, XmNsensitive, True, NULL);
}



/**************************************************************************** 
*****************************************************************************/
void updateListSymbols()
{
  int i, sliderSize, topPos;
  Pixmap pixmap_to_use;

  XtVaGetValues(SubsetList,
		XmNtopItemPosition, &topPos,
		NULL);

  for(i=0; i<ListSliderSize; i++) {
    pixmap_to_use = 
      getPixmapToUse(ListData[(topPos-1)+i].instrumentationType);

    XtVaSetValues(ListInstrumentationSymbols[i],
		  XmNlabelPixmap, pixmap_to_use,
		  NULL);
  }
}





