/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Keith A. Shields (shields@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 *
 */


#ifndef Main_h
#define Main_h

#include <X11/Intrinsic.h>
#include <Xm/Xm.h>

#include <Xm/CascadeB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>

#include <dirent.h>     
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "../Parser.h"

extern char	*strdup();

typedef enum dialogType {subsetTo, subsetIn, multipleOnLine } dialogType;

typedef struct lineInfoStruct {int startCharPos; 
 			       INSTTYPES instrumentationType;
			       INSTREC *firstInstrumentableStructure;
			       Boolean isLineSelected;} 
                               lineInfoStruct;

typedef struct listItemStruct {INSTTYPES instrumentationType;
			       char *item;
			       INSTREC *instrumentableStructure;}
                               listItemStruct;

lineInfoStruct *LineData;
listItemStruct *ListData;

INSTTYPES DialogInstrumentationType;
dialogType DialogType;

Widget CallingLabel, CurrentRoutineLabel, RoutineList, SubsetList, 
       SourceViewer, SourceForm, MainSymForm, ScrollForm, SubsetSymForm,
       File, Global, Routine, Help, SubsetDialog, ErrorDialog, FileNameLabel,
       TraceButton, CountButton, ClearButton, InstrumentSource, InfoDialog,
       OptionsDialog, InstrumentationSymbols[100], LineSelectedSymbols[100],
       ListInstrumentationSymbols[100];

Display *display;
Pixmap TracePix, CountPix, NullPix, MixedPix, LineSelectedPix;
XmString SelectedRoutine;

XtAppContext App;

int TextLineHeight, NumSourceLines, ListLineHeight, NumSubsetItems,
     CurrentLineNum;

Boolean FSD_Exists, StateChangedSinceSave;

#include "MenuBar.h"
#include "OptionsDialog.h"

void parseArgs();

#endif Main_h



