
      subroutine print_results(name, class, n1, n2, n3, niter, 
     >                  nprocs_compiled, nprocs_total,
     >                  t, mflops, verified, npbversion, compiletime,
     >                  cs1, cs2, cs3, cs4, cs5, cs6)
      
      implicit none
      character*2 name
      character*1 class
      integer n1, n2, n3, niter, nprocs_compiled, nprocs_total
      double precision t, mflops
      logical verified
      character*(*) npbversion, compiletime, 
     >              cs1, cs2, cs3, cs4, cs5, cs6

         write (*, 2) name 
 2       format(//, ' ', A2, ' Benchmark Completed.')

         write (*, 3) Class
 3       format(' Class           = ', a12)

         write (*, 4) n1,n2,n3
 4       format(' Size            =  ', i3,'x',i3,'x',i3)

         write (*, 5) niter
 5       format(' Iterations      = ', i12)
         
         write (*, 6) t
 6       format(' Time in seconds = ',f12.2)
         
         
         write (*,7) nprocs_total
 7       format(' Total processes = ', i12)
         
         write (*,8) nprocs_compiled
 8       format(' Compiled procs  = ', i12)

         write (*,9) mflops
 9       format(' Mflop/s total   = ',f12.2)

         write (*,10) mflops/float( nprocs_total )
 10       format(' Mflop/s/process = ',f12.2)        
         
         if (verified) then
            write(*,11) '  SUCCESSFUL'
         else
            write(*,11) 'UNSUCCESSFUL'
         endif
 11      format(' Verification    = ', a)

         write(*,12) npbversion
 12      format(' Version         = ', a12)

         write(*,13) compiletime
 13      format(' Compile date    = ', a12)


         write (*,121) cs1
 121     format(/, ' Compile options:', /, '    F77     = ', A)

         write (*,122) cs2
 122     format('    LOAD    = ', A)

         write (*,123) cs3
 123     format('    MPI_LIB = ', A)

         write (*,124) cs4
 124     format('    MPI_INC = ', A)

         write (*,125) cs5
 125     format('    FFLAGS  = ', A)

         write (*,126) cs6
 126     format('    LDFLAGS  = ', A, //)

         write (*,127)
 127     format(//' Please send the results of this run to:'//
     >            ' NPB Development Team '/
     >            ' Internet: npb@nas.nasa.gov'/
     >            ' '/
     >            ' If email is not available, send this to:'//
     >            ' MS T27A-1'/
     >            ' NASA Ames Research Center'/
     >            ' Moffett Field, CA  94035-1000'//
     >            ' Fax: 415-604-3957'//)


         return
         end

