#!/usr/local/bin/perl -w
# occam library entry point lister
# liblist.pl 1.2 96/05/21
# by Richard Beton
# (C) Roke Manor Research Limited (May 1996)
#{{{  Disclaimer
#
# This software is provided by Roke Manor Research Limited ``as is''
# and any express or implied warranties, including, but not limited to,
# the implied warranties of merchantability and fitness for a
# particular purpose are disclaimed.  In no event shall the
# regents or contributors be liable for any direct, indirect,
# incidental, special, exemplary, or consequential damages
# (including, but not limited to, procurement of substitute
# goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability,
# whether in contract, strict liability, or tort (including
# negligence or otherwise) arising in any way out of the use of
# this software, even if advised of the possibility of such
# damage.
#
#}}}  

foreach $file (@ARGV)
{
    open (IN, $file) || die "Cannot read from $file.\n";

    while ($line = <IN>)
    {
        $line =~ tr/\0-\11\13-\37\177-\377/./;
        chop ($line);
        $proc = index ($line, "PROC ");

        if ($proc >= 0)
        {
            @args = ();
            %in   = ();
            %out  = ();
            #{{{  get entry name and initialise args

            $entry = $first = substr ($line, $proc, 1024);
            $entry =~ s/\(.*//;
            $first =~ s/.*\(//;
            $first =~ s/\)$//;
            @args = split (/,/, $first);

            # $spaces is used to indent subsequent lines
            $spaces = $entry;
            $spaces =~ tr/A-Za-z0-9./ /;

            #}}}  
            #{{{  read as far as 'SEQ'

            while ($line = <IN>)
            {
                $line =~ tr/\0-\11\13-\37\177-\377/./;
                chop ($line);
                last if ($line =~ /^SEQ/);
                $line =~ s/\)$//;
                @extra = split (/,/, $line);
                push (@args, @extra);
            }

            #}}}  
            #{{{  read as far as ':'

            while ($line = <IN>)
            {
                $line =~ tr/\0-\11\13-\37\177-\377/./;
                chop ($line);
                if ($line =~ /^:/)
                {
                    last;
                }
                elsif ($line =~ /\?$/)
                {
                    chop ($line);
                    $in{$line} = 1;
                }
                elsif ($line =~ /\!$/)
                {
                    chop ($line);
                    $out{$line} = 1;
                }
            }

            #}}}  
            #{{{  print the results

            print "$entry (";
            for ($a = 0; $a <= $#args; $a++)
            {
                $arg = $args[$a];
                $id = $arg;
                $id =~ s/^.* //;
                if ($a > 0) { print "\n$spaces  "; }
                print "$arg";
                if ($a < $#args) { print ","; }
                else             { print ")"; }
                if ($id eq 'in') { }
                elsif ($id eq 'out') { }
                elsif ($id =~ /\.in/) { }
                elsif ($id =~ /\.out/) { }
                elsif ($in{$id})
                {
                    print " -- in";
                }
                elsif ($out{$id})
                {
                    print " -- out";
                }
            }
            print "\n\n";

            #}}}  
        }
    }

    close (IN);
}
