# Examples.mk 1.4 96/05/22
# yacht makefile
# Richard Beton 1995

#OPT=-z
EXAMPLES=chain dchain1 dchain2 comstime bufd2 bufd4 mux1 mux2 cf_mux mux_demux
TESTS=mxn dup_name amb_name dang

MODEL=RDB_Learning

default: cdif $(EXAMPLES)

cdif:   $(EXAMPLES:%=%.cdif)
	cd tests; $(MAKE) $(TESTS:%=%.cdif)

test:
	$(MAKE) cdif
	@echo
	cd tests; $(MAKE) OPT=$(OPT) $(TESTS:%=%.occ)

retest:
	$(MAKE) cdif
	@echo
	@rm -f tests/*.occ
	cd tests; $(MAKE) OPT=$(OPT) $(TESTS:%=%.occ)

#{{{  main examples

chain: chain.occ chain.cdif
	yacht -f chain.cdif $(OPT) -o chain_core.occ -i chain.occ
	@echo
	kroc chain.occ
	@echo

dchain1: dchain1.occ dchain1.cdif
	yacht -f dchain1.cdif $(OPT) -o dchain1_core.occ -i dchain1.occ
	@echo
	kroc dchain1.occ
	@echo

dchain2: dchain2.occ dchain2.cdif
	yacht -f dchain2.cdif $(OPT) -o dchain2_core.occ -i dchain2.occ
	@echo
	kroc dchain2.occ
	@echo

comstime: comstime.occ comstime.cdif
	yacht -f comstime.cdif $(OPT) -o comstime_core.occ -i comstime.occ
	@echo
	kroc comstime.occ -lconvert
	@echo

bufd2: bufd2.occ bufd2.cdif
	yacht -f bufd2.cdif $(OPT) -o bufd2_core.occ
	@echo
	kroc bufd2.occ
	@echo

bufd4: bufd4.occ bufd4.cdif
	yacht -f bufd4.cdif $(OPT) -o bufd4_core.occ
	@echo
	kroc bufd4.occ
	@echo

mux1: mux1.occ mux1.cdif
	yacht -f mux1.cdif $(OPT) -o mux1_core.occ -i mux1.occ
	@echo
	kroc mux1.occ
	@echo

mux2: mux2.occ mux2.cdif
	yacht -f mux2.cdif $(OPT) -o mux2_core.occ -i mux2.occ
	@echo
	kroc mux2.occ
	@echo

cf_mux: cf_mux.occ cf_mux.cdif
	yacht -f cf_mux.cdif $(OPT) -o cf_mux_core.occ -i cf_mux.occ
	@echo
	kroc cf_mux.occ
	@echo

mux_demux: mux_demux.occ mux_demux.cdif
	yacht -f mux_demux.cdif $(OPT) -o mux_demux_core.occ -i mux_demux.occ
	@echo
	kroc mux_demux.occ
	@echo

#}}}  
#{{{  tests

mxn.occ: mxn.cdif
	@echo '+++ mxn: should raise 2d array error +++'
	-yacht -f mxn.cdif -o $@
	@touch $@.occ
	@echo

dup_name.occ: dup_name.cdif
	@echo '+++ dup_name: should complain about duplicate names +++'
	-yacht -f dup_name.cdif -o $@
	@touch $@.occ
	@echo

amb_name.occ: amb_name.cdif
	@echo '+++ amb_name: should complain about ambiguous replicate names +++'
	-yacht -f amb_name.cdif -o $@
	@touch $@.occ
	@echo

dang.occ: dang.cdif
	@echo '+++ dang: should complain about dangling channel +++'
	-yacht -f dang.cdif -o $@
	@touch $@.occ
	@echo

#}}}  
#{{{  yacht configuration
# this runs the configure script if yacht is older than yacht.pl.
#
# WARNING: this will fail if perl is not located in one of the
# standard directories (see configure script).

../yacht: ../yacht.pl
	cd ..; echo | ./configure

#}}}  
#{{{  CDIF Files for examples

chain.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 10 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 10 > chain.ps
	@echo

dchain1.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 11 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 11 > dchain1.ps
	@echo

dchain2.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 12 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 12 > dchain2.ps
	@echo

comstime.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 13 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 13 > comstime.ps
	@echo

bufd2.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 30 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 30 > bufd2.ps
	@echo

bufd4.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 40 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 40 > bufd4.ps
	@echo

mux1.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 50 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 50 > mux1.ps
	@echo

mux2.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 51 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 51 > mux2.ps
	@echo

cf_mux.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 52 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 52 > cf_mux.ps
	@echo

mux_demux.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 53 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 53 > mux_demux.ps
	@echo

#}}}  
#{{{  CDIF Files for tests

mxn.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 90 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 90 > mxn.ps
	@echo

dup_name.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 91 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 91 > dup_name.ps
	@echo

amb_name.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 92 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 92 > amb_name.ps
	@echo

dang.cdif:
	twk_get -model $(MODEL) -config $(TWK_CONFIG) \
	  -object 93 -type DFD -noheader -no_notes > $@
	twk_image -dfd -m $(MODEL) -c $(TWK_CONFIG) \
	  -o 93 > dang.ps
	@echo

#}}}  

clean:
	rm -f *_core.occ *.tco *.t core $(EXAMPLES)
	rm -f tests/*.occ tests/core

veryclean: clean
	rm -f *.cdif tests/*.cdif *.ps tests/*.ps
