--{{{  copyright notice
--
-- Resource channel library
--
-- $Source: /u3/proj/kroc/develop/examples/syncs/RCS/resource.inc,v $
--
-- $Id: resource.inc,v 1.1 1996/10/30 11:36:05 djb1 Exp $
--
-- (C) Copyright 1996 P.H.Welch <P.H.Welch@ukc.ac.uk> and
--                    D.C. Wood <D.C.Wood@ukc.ac.uk>
-- University of Kent at Canterbury, England
--
--}}}

--{{{  DATA TYPE RESOURCE
DATA TYPE RESOURCE
  RECORD
    INT channel.id:      -- index or pointer
    INT Fptr, Bptr:      -- queue of RESOURCE.NODE
    INT granter:         -- process descriptor
:
--}}}
--{{{  DATA TYPE RESOURCE.NODE
DATA TYPE RESOURCE.NODE
  RECORD
    INT channel.id:      -- index or pointer
    INT link:            -- to RESOURCE or next RESOURCE.NODE
    INT claimant:        -- process descriptor
:
--}}}

--{{{  Local constants
-- Local constants prefixed by RESOURCE. to prevent clashes

VAL INT RESOURCE.NotProcess.p IS MOSTNEG INT:

-- offsets into DATA TYPE RESOURCE in words
VAL INT RESOURCE.channel.id IS 0:
VAL INT RESOURCE.Fptr       IS 1:
VAL INT RESOURCE.Bptr       IS 2:
VAL INT RESOURCE.granter    IS 3:

-- offsets into DATA TYPE RESOURCE.NODE in words
VAL INT RESOURCE.NODE.channel.id IS 0:
VAL INT RESOURCE.NODE.link       IS 1:
VAL INT RESOURCE.NODE.claimant   IS 2:
--}}}

--{{{  PROC initialise.resource (RESOURCE resource)
INLINE PROC initialise.resource (RESOURCE resource)
  --{{{  
  resource := [RESOURCE.NotProcess.p, RESOURCE.NotProcess.p,
               RESOURCE.NotProcess.p, RESOURCE.NotProcess.p]
  --}}}
:
--}}}

--{{{  PROC mark.resource.node (RESOURCE.NODE node, VAL INT channel, ...
INLINE PROC mark.resource.node (RESOURCE.NODE node, VAL INT channel,
                                RESOURCE resource)
  --{{{  node := [channel, &resource, NotProcess.p]
  ASM
    LD    channel                -- node := [channel, &resource, NotProcess.p]
    ST    node[channel.id]
    LD    ADDRESSOF resource
    ST    node[link]
    MINT
    ST    node[claimant]
  --}}}
:
--}}}

--{{{  PROC mark.resource.indices ([]RESOURCE.NODE node, RESOURCE resource)
INLINE PROC mark.resource.indices ([]RESOURCE.NODE node, RESOURCE resource)
  --{{{  
  SEQ i = 0 FOR SIZE node
    mark.resource.node (node[i], i, resource)
  --}}}
:
--}}}

--{{{  PROC mark.resource.pointers ([]INT pointer, []RESOURCE.NODE node, ...
INLINE PROC mark.resource.pointers ([]RESOURCE.NODE node, []INT pointer,
                                    RESOURCE resource)
  --{{{  
  -- ASSERT : (SIZE pointer) = (SIZE node)
  SEQ i = 0 FOR SIZE node
    mark.resource.node (node[i], pointer[i], resource)
  --}}}
:
--}}}

--{{{  PROC claim.resource (RESOURCE.NODE node)
INLINE PROC claim.resource (RESOURCE.NODE node)
  --{{{  
  -- ASSERT : node[claimant] = NotProcess.p
  INT resource.ptr:
  SEQ
    resource.ptr := node[link]
    ASM
      --{{{  no waiting granter ==> (L1)
      LD     resource.ptr        -- resource.ptr^[granter] <> NotProcess.p?
      LDNL   RESOURCE.granter
      MINT
      DIFF
      CJ     :L1                 -- yes
      --}}}
  
      --{{{  schedule granter
      LD     resource.ptr        -- LDL resource.ptr^[granter]
      LDNL   RESOURCE.granter
      RUNP
      --}}}
      --{{{  clear granter from resource
      MINT                       -- resource.ptr^[granter] := NotProcess.p
      LD     resource.ptr
      STNL   RESOURCE.granter
      --}}}
      --{{{  leave id in resource
      LD     node[channel.id]    -- resource.ptr^[channel.id] := node[channel.id]
      LD     resource.ptr
      STNL   RESOURCE.channel.id
      --}}}
      --{{{  ==> (L4)
      J      :L4
      --}}}
  
      --{{{  (L1) enqueue node on resource & yield
      :L1
      --{{{  resource queue empty ==> (L2)
      LD     resource.ptr        -- resource.ptr^[Fptr] = NotProcess.p?
      LDNL   RESOURCE.Fptr
      MINT
      DIFF
      CJ     :L2                 -- yes
      --}}}
      
      --{{{  attach node on back of resource queue
      LD     ADDRESSOF node                -- resource.ptr^[Bptr]^[link] := &node
      LD     resource.ptr
      LDNL   RESOURCE.Bptr
      STNL   RESOURCE.NODE.link
      --}}}
      --{{{  ==> (L3)
      J      :L3
      --}}}
      
      --{{{  (L2) point front of resource queue at node
      :L2
      LD     ADDRESSOF node                -- resource.ptr^[Fptr] := &node
      LD     resource.ptr
      STNL   RESOURCE.Fptr
      --}}}
      --{{{  (L3) point back of resource queue at node
      :L3
      LD     ADDRESSOF node                -- resource.ptr^[Bptr] := &node
      LD     resource.ptr
      STNL   RESOURCE.Bptr
      --}}}
      --{{{  save claimant descriptor in node
      LDLP   0                   -- node[claimant] := Wptr
      ST     node[claimant]
      --}}}
      --{{{  schedule next process
      STOPP
      --}}}
      --}}}
      --{{{  (L4)
      :L4
      --}}}
  --}}}
:
--}}}

--{{{  PROC grant.resource (RESOURCE resource)
INLINE PROC grant.resource (RESOURCE resource)
  --{{{  
  -- ASSERT : resource[granter] = NotProcess.p
  IF
    --{{{  empty resource queue
    resource[Fptr] = RESOURCE.NotProcess.p
    --}}}
      --{{{  leave process descriptor & yield
      ASM
        LDLP   0                          -- resource[granter] := Wptr
        ST    resource[granter]
        STOPP
      --}}}
    TRUE
      INT node.ptr:
      SEQ
        node.ptr := resource[Fptr]
        --{{{  dequeue node from resource queue
        IF
          --{{{  resource queue has only one node
          node.ptr = resource[Bptr]
          --}}}
            --{{{  make resource queue empty
            resource[Fptr] := RESOURCE.NotProcess.p
            --}}}
          TRUE
            --{{{  detach first node of resource queue
            ASM
              LD     node.ptr    -- resource[Fptr] := node.ptr^[link]
              LDNL   RESOURCE.NODE.link
              ST    resource[Fptr]
            --}}}
        --}}}
        --{{{  schedule claimant
        ASM
          LD     node.ptr        -- LDL node.ptr^[claimant]
          LDNL   RESOURCE.NODE.claimant
          RUNP
          MINT                   -- node.ptr^[claimant] := NotProcess.p
          LD     node.ptr
          STNL   RESOURCE.NODE.claimant
        --}}}
        --{{{  put channel id into resource
        ASM
          LD    node.ptr        -- resource[channel.id] := node.ptr^[channel.id]
          LDNL  RESOURCE.NODE.channel.id
          ST    resource[channel.id]
        --}}}
        --{{{  point node back to resource
        ASM
          LD     ADDRESSOF resource        -- node.ptr^[link] := &resource
          LD     node.ptr
          STNL   RESOURCE.NODE.link
        --}}}
  --}}}
:
--}}}
