/*  XLIB Macros interfaced by routines for Occam */

MACRO_ConnectionNumber(dpy) 	((dpy)->fd)
MACRO_RootWindow(dpy, scr) 	(((dpy)->screens[(scr)]).root)

int  MACRO_DefaultScreen(Display *dpy);
 	((dpy)->default_screen)

MACRO_DefaultRootWindow(dpy) 	(((dpy)->screens[(dpy)->default_screen]).root)
MACRO_DefaultVisual(dpy, scr) (((dpy)->screens[(scr)]).root_visual)
MACRO_DefaultGC(dpy, scr) 	(((dpy)->screens[(scr)]).default_gc)
MACRO_BlackPixel(dpy, scr) 	(((dpy)->screens[(scr)]).black_pixel)
MACRO_WhitePixel(dpy, scr) 	(((dpy)->screens[(scr)]).white_pixel)
MACRO_AllPlanes 		((unsigned long)~0L)
MACRO_QLength(dpy) 		((dpy)->qlen)
MACRO_DisplayWidth(dpy, scr) 	(((dpy)->screens[(scr)]).width)
MACRO_DisplayHeight(dpy, scr) (((dpy)->screens[(scr)]).height)
MACRO_DisplayWidthMM(dpy, scr)(((dpy)->screens[(scr)]).mwidth)
MACRO_DisplayHeightMM(dpy, scr)(((dpy)->screens[(scr)]).mheight)
MACRO_DisplayPlanes(dpy, scr) (((dpy)->screens[(scr)]).root_depth)
MACRO_DisplayCells(dpy, scr) 	(DefaultVisual((dpy), (scr))->map_entries)
MACRO_ScreenCount(dpy) 	((dpy)->nscreens)
MACRO_ServerVendor(dpy) 	((dpy)->vendor)
MACRO_ProtocolVersion(dpy) 	((dpy)->proto_major_version)
MACRO_ProtocolRevision(dpy) 	((dpy)->proto_minor_version)
MACRO_VendorRelease(dpy) 	((dpy)->release)
MACRO_DisplayString(dpy) 	((dpy)->display_name)
MACRO_DefaultDepth(dpy, scr) 	(((dpy)->screens[(scr)]).root_depth)
MACRO_DefaultColormap(dpy, scr)(((dpy)->screens[(scr)]).cmap)
MACRO_BitmapUnit(dpy) 	((dpy)->bitmap_unit)
MACRO_BitmapBitOrder(dpy) 	((dpy)->bitmap_bit_order)
MACRO_BitmapPad(dpy) 		((dpy)->bitmap_pad)
MACRO_ImageByteOrder(dpy) 	((dpy)->byte_order)
MACRO_NextRequest(dpy)	((dpy)->request + 1)
MACRO_LastKnownRequestProcessed(dpy)	((dpy)->last_request_read)

/* macros for screen oriented applications (toolkit) */
MACRO_ScreenOfDisplay(dpy, scr)(&((dpy)->screens[(scr)]))
MACRO_DefaultScreenOfDisplay(dpy) (&((dpy)->screens[(dpy)->default_screen]))
MACRO_DisplayOfScreen(s)	((s)->display)
MACRO_RootWindowOfScreen(s)	((s)->root)
MACRO_BlackPixelOfScreen(s)	((s)->black_pixel)
MACRO_WhitePixelOfScreen(s)	((s)->white_pixel)
MACRO_DefaultColormapOfScreen(s)((s)->cmap)
MACRO_DefaultDepthOfScreen(s)	((s)->root_depth)
MACRO_DefaultGCOfScreen(s)	((s)->default_gc)
MACRO_DefaultVisualOfScreen(s)((s)->root_visual)
MACRO_WidthOfScreen(s)	((s)->width)
MACRO_HeightOfScreen(s)	((s)->height)
MACRO_WidthMMOfScreen(s)	((s)->mwidth)
MACRO_HeightMMOfScreen(s)	((s)->mheight)
MACRO_PlanesOfScreen(s)	((s)->root_depth)
MACRO_CellsOfScreen(s)	(DefaultVisualOfScreen((s))->map_entries)
MACRO_MinCmapsOfScreen(s)	((s)->min_maps)
MACRO_MaxCmapsOfScreen(s)	((s)->max_maps)
MACRO_DoesSaveUnders(s)	((s)->save_unders)
MACRO_DoesBackingStore(s)	((s)->backing_store)
MACRO_EventMaskOfScreen(s)	((s)->root_input_mask)
