--{{{  copyright notice
--
-- Event buckets library
--
-- $Source: /u3/proj/kroc/develop/examples/syncs/RCS/semaphore.inc,v $
--
-- $Id: semaphore.inc,v 1.1 1996/10/30 11:36:21 djb1 Exp $
--
-- (C) Copyright 1996 P.H.Welch <P.H.Welch@ukc.ac.uk> and
--                    D.C. Wood <D.C.Wood@ukc.ac.uk>
-- University of Kent at Canterbury, England
--
--}}}

--{{{  DATA TYPE SEMAPHORE
DATA TYPE SEMAPHORE
  RECORD
    INT Fptr, Bptr:
    INT count:
:
--}}}

--{{{  Local constants
-- Local constants prefixed with SEMAPHORE to prevent clashes
VAL INT SEMAPHORE.NotProcess.p IS 0: -- MOSTNEG INT:
VAL INT SEMAPHORE.pw.Link IS -2:
--}}}

--{{{  PROC initialise.semaphore (SEMAPHORE s, VAL INT count)
INLINE PROC initialise.semaphore (SEMAPHORE s, VAL INT count)
  s := [SEMAPHORE.NotProcess.p, SEMAPHORE.NotProcess.p, count]
:
--}}}

--{{{  PROC claim.semaphore (SEMAPHORE s)
INLINE PROC claim.semaphore (SEMAPHORE s)
  ASM
    --{{{  (s[count] > 0) ?
    LD      s[count]          -- s[count] > 0?
    LDC     0
    GT
    --}}}
    --{{{  no  --> :L1
    CJ      :L1               -- no
    --}}}
    --{{{  yes --> s[count] := s[count] - 1 --> :L4
    LD      s[count]          -- yes -- s[count] := s[count] - 1
    ADC     -1
    ST      s[count]
    J       :L4
    --}}}

    :L1
    --{{{  (s[Fptr] = NotProcess.p) ?
    LD      s[Fptr]           -- s[Fptr] = NotProcess.p?
    LDC     SEMAPHORE.NotProcess.p
    --MINT
    DIFF
    --}}}
    --{{{  yes --> :L2
    CJ      :L2               -- yes
    --}}}
    --{{{  no  --> s[Bptr]^[pw.Link] := Wptr --> :L3
    LDLP    0                 -- no  -- s[Bptr]^[pw.Link] := Wptr
    LD      s[Bptr]
    STNL    SEMAPHORE.pw.Link
    J       :L3
    --}}}

    :L2
    --{{{  s[Fptr] := Wptr
    LDLP    0                 -- s[Fptr] := Wptr
    ST      s[Fptr]
    --}}}

    :L3
    --{{{  s[Bptr] := Wptr
    LDLP    0                 -- s[Bptr] := Wptr
    ST      s[Bptr]
    --}}}
    --{{{  STOPP
    STOPP
    --}}}

    :L4
:
--}}}

--{{{  PROC release.semaphore (SEMAPHORE s)
INLINE PROC release.semaphore (SEMAPHORE s)
  INT temp:
  ASM
    --{{{  (s[Fptr] = NotProcess.p) ?
    LD      s[Fptr]           -- s[Fptr] = NotProcess.p?
    LDC     SEMAPHORE.NotProcess.p
    --MINT
    DIFF
    --}}}
    --{{{  yes --> :L2
    CJ      :L2               -- yes
    --}}}
    --{{{  no  --> temp := s[Fptr]^[pw.Link]
    LD      s[Fptr]           -- no  -- s[Fptr] := s[Fptr]^[pw.Link]
    LDNL    SEMAPHORE.pw.Link
    ST      temp
    --}}}
    --{{{  schedule s[Fptr]
    LD      s[Fptr]
    RUNP
    --}}}
    --{{{  (s[Fptr] = s[Bptr]) ?
    LD      s[Fptr]           -- s[Fptr] = s[Bptr]?
    LD      s[Bptr]
    DIFF
    --}}}
    --{{{  yes --> :L1
    CJ      :L1               -- yes
    --}}}
    --{{{  no  --> s[Fptr] := temp --> :L3
    LD      temp              -- no
    ST      s[Fptr]
    J       :L3
    --}}}

    :L1
    --{{{  s[Fptr] := NotProcess.p --> :L3
    LDC     SEMAPHORE.NotProcess.p
    --MINT                      -- s[Fptr] := NotProcess.p
    ST      s[Fptr]
    J       :L3
    --}}}

    :L2
    --{{{  s[count] := s[count] + 1
    LD      s[count]          -- s[count] := s[count] + 1
    ADC     1
    ST      s[count]
    --}}}

    :L3
    --{{{  reschedule this process
    LDLP    0                 -- reschedule
    RUNP
    STOPP
    --}}}
:
--}}}
