--{{{  copyright notice
--
-- Event buckets library
--
-- $Source: /u3/proj/kroc/develop/examples/syncs/RCS/bucket.inc,v $
--
-- $Id: bucket.inc,v 1.1 1996/10/30 11:35:26 djb1 Exp $
--
-- (C) Copyright 1996 P.H.Welch <P.H.Welch@ukc.ac.uk> and
--                    D.C. Wood <D.C.Wood@ukc.ac.uk>
-- University of Kent at Canterbury, England
--
--}}}

#INCLUDE "event.inc"
DATA TYPE BUCKET IS EVENT:

--{{{  PROC initialise.bucket (BUCKET b)
INLINE PROC initialise.bucket (BUCKET b)
  EVENT b RETYPES b:
  initialise.event (b, MOSTPOS INT)
:
--}}}

--{{{  INT FUNCTION number.in.bucket (VAL BUCKET b)
INT FUNCTION number.in.bucket (VAL BUCKET b)
  VAL EVENT b RETYPES b:
  VALOF
    SKIP
    RESULT (MOSTPOS INT) - b[count]
:
--}}}

--{{{  PROC fall.into.bucket (BUCKET b)
INLINE PROC fall.into.bucket (BUCKET b)
  EVENT b RETYPES b:
  synchronise.event (b)
:
--}}}

--{{{  PROC flush.bucket (BUCKET b)
INLINE PROC flush.bucket (BUCKET b)
  EVENT b RETYPES b:
  SEQ
    b[count] := 1
    synchronise.event (b)
:
--}}}
