/*
 * C Support for Dynamic String library -- example of UDOs
 *
 * $Id: c_dstr.c,v 1.1 1997/03/31 11:57:31 djb1 Exp $
 *
 * $Source: /proj/kroc/develop/examples/udo/RCS/c_dstr.c,v $
 *
 * (C) Copyright 1997 Jim Moores <jm40@ukc.ac.uk>
 * University of Kent at Canterbury
 */


#include <stdio.h>
#include <string.h>

void create_dstring(char **str_pointer, char dstring[], int size)
{
  /*printf("dstring passed to create_dstring:%s\n",(char *)dstring);*/
  *str_pointer = strdup((char *)dstring);
}

void _create_dstring (int w[3])
{
  create_dstring ((char **)w[0], (char *)w[1], w[2]);
}

void dstring_to_oc_buffer(char *str_pointer, char oc_buffer[],int oc_buffer_size)
{
  int i;
  /*for (i=0; i<(oc_buffer_size*4); oc_buffer[i++]=0);*/
  strcpy(oc_buffer, str_pointer);
}

void _dstring_to_oc_buffer (int w[3])
{
  dstring_to_oc_buffer ((char *)w[0], (char *)w[1], w[2]);
}

void remove_dstring(char *str_pointer)
{
  free(str_pointer);
}
void _remove_dstring(int w[1])
{
  remove_dstring((char *)w[0]);
}

void concat_dstrings(char **ret,char *str_pointer1, char *str_pointer2)
{
  int length1 = strlen((char *)str_pointer1);
  int length2 = strlen((char *)str_pointer2);
  char *temp = (char *)malloc(length1+length2+1); /* waste - change */
  strcpy(temp, (char *)str_pointer1);
  strcat(temp, (char *)str_pointer2);
  *ret=temp;
}

void _concat_dstrings(int w[3])
{
  concat_dstrings((char **)w[0],(char *)w[1],(char *)w[2]);
} 

compare_dstrings(int *ret, char *str_pointer1, char *str_pointer2)
{
  *ret=strcmp(str_pointer1, str_pointer2);
}

void _compare_dstrings(int w[3])
{
  compare_dstrings((int *)w[0],(char *)w[1],(char *)w[2]);
}

void length_of_dstring(int *ret,char *str_pointer)
{
  *ret = strlen(str_pointer);
}

void _length_of_dstring(int w[2])
{
  length_of_dstring((int *)w[0],(char *)w[1]);
}

char *copy_dstring(char **ret,char *str_pointer)
{
  *ret = strdup(str_pointer);
}

void _copy_dstring(int w[2])
{
  copy_dstring((char **)w[0],(char *)w[1]);
}

void _print_dstring(int w[1])
{
  fputs((char *)w[0], stdout);
}
