'\" t
.\"
.\" Manual page for string.lib - INMOS occam toolset string library
.\"
.\" $Source: /u0/src/local/bin/oc2man/RCS/string-lib.man,v $
.\"
.\" $Id: string-lib.man,v 1.3 1993/03/09 11:03:26 djb1 Exp $
.\"
.\" Copyright (C) 1993 David Beckett, University of Kent at Canterbury
.\"
.\" This was derived from string.lib (the library) using ilist and the
.\" perl program fixilist.pl which cleaned up the output.
.\"
.de tt \" Begin tt definition [.ttype]
.ft CR
.nf
..     \" End tu definition
.de tu \" Begin tu definition [.tu End ttype]
.fi
.ft P
..     \" End tu definition
.de ve \" Begin ve definition [.verb]
.ft CR
\\$1
.ft P
..
.TH STRINGLIB 3L "8 March 1993" STRINGLIB "OCCAM LIBRARIES" STRINGLIB
.SH NAME
string.lib \- INMOS occam toolset string library
.SH SYNOPSIS
.tt
#USE "string.lib"
.tu
.SH SUMMARY
The occam toolset library string.lib provides various string handling
functions and procedures.
.LP
.SH OVERVIEW
To use the functions in this library do the following:
.LP
.tt
#USE "string.lib"
.tu
.LP
.SH Procedures
.LP
.tt
PROC append.char (INT len, []BYTE str, VAL BYTE char)
PROC append.hex.int (INT len, []BYTE str, VAL INT number,
                     VAL INT width)
PROC append.hex.int64 (INT len, []BYTE str, VAL INT64 number,
                       VAL INT width)
PROC append.int (INT len, []BYTE str, VAL INT number,
                 VAL INT field)
PROC append.int64 (INT len, []BYTE str, VAL INT64 number,
                   VAL INT field)
PROC append.real32 (INT len, []BYTE str, VAL REAL32 number,
                    VAL INT Ip, VAL INT Dp)
PROC append.real64 (INT len, []BYTE str, VAL REAL64 number,
                    VAL INT Ip, VAL INT Dp)
PROC append.text (INT len, []BYTE str, VAL []BYTE text)
.tu
.IP
Append the given data type to an array \f(CRstr\fP at position
\f(CRlen\fP using formatting where necessary and possibly padding
with spaces to a given field \f(CRwidth\fP or printing \f(CRIp\fP
integer places and \f(CRDp\fP decimal places for \f(CRREAL32\fP and
\f(CRREAL64\fP types.  Hex numbers are formatted prefixed by a '#'.
STOPs if the array overflows.  \f(CRlen\fP is updated to the new
position.
.LP
.tt
INT FUNCTION char.pos (VAL BYTE search, VAL []BYTE str)
.tu
.IP
Return the position of the first occurence of character
\f(CRsearch\fP in \f(CRstr\fP or -1 if not found.  See also
\f(CRstring.pos\fP.
.LP
.tt
INT FUNCTION compare.strings (VAL []BYTE str1, VAL []BYTE str2)
.tu
.IP
Return result of comparsion:
.TS
rf(CR) l.
-2	if str1 is earlier than str2
-1	if str1 is a leading substring of str2
 0	if the strings are identical
 1	if str2 is a leading substring of str1
 2	if str2 is earlier than str1
.TE
.LP
.tt
PROC delete.string (INT len, []BYTE str, VAL INT start,
                    VAL INT size, BOOL not.done)
.tu
.IP
Delete \f(CRsize\fP characters from position \f(CRstart\fP of string
\f(CRstr\fP of size \f(CRlen\fP characters.  \f(CRnot.done\fP is
\f(CRTRUE\fP if the range is invalid.  See also \f(CRstr.shift\fP.
.LP
.tt
BOOL FUNCTION eqstr (VAL []BYTE s1, VAL []BYTE s2)
.tu
.IP
Return \f(CRTRUE\fP if the strings are identical.
.LP
.tt
PROC insert.string (VAL []BYTE new.str, INT len, []BYTE str,
                    VAL INT start, BOOL not.done)
.tu
.IP
Insert \f(CRnew.str\fP into \f(CRstr\fP of size \f(CRlen\fP
characters at position \f(CRstart\fP. \f(CRnot.done\fP is
\f(CRTRUE\fP if the range is invalid.  See also \f(CRstr.shift\fP.
.LP
.tt
BOOL FUNCTION is.digit (VAL BYTE char)
BOOL FUNCTION is.hex.digit (VAL BYTE char)
.tu
.IP
\f(CRTRUE\fP if the given character is a valid decimal or hex digit
respectively.
.LP
.tt
BOOL FUNCTION is.id.char (VAL BYTE char)
.tu
.IP
\f(CRTRUE\fP if the given character can be part of an occam identifier.
.LP
.tt
BOOL FUNCTION is.in.range (VAL BYTE char, VAL BYTE bottom, VAL BYTE top)
.tu
.IP
Return \f(CRTRUE\fP if \f(CRbottom\fP <= \f(CRchar\fP <= \f(CRtop\fP.
.LP
.tt
BOOL FUNCTION is.lower (VAL BYTE char)
BOOL FUNCTION is.upper (VAL BYTE char)
.tu
.IP
Return \f(CRTRUE\fP if the given character is an upper or lower case
letter.
.LP
.tt
PROC next.int.from.line (VAL []BYTE line, INT ptr,
                         INT number, BOOL ok)
PROC next.word.from.line (VAL []BYTE line, INT ptr,
                          INT len, []BYTE word, BOOL ok)
.tu
.IP
Return the next white-space separated integer/word from the array
\f(CRline\fP, using \f(CRptr\fP as a index into it.  Updates
\f(CRptr\fP and sets \f(CRok\fP to \f(CRFALSE\fP if the operation
fails.  \f(CRlen\fP is the returned length of \f(CRword\fP or zero
on end of line.
.LP
.tt
INT,BYTE FUNCTION search.match (VAL []BYTE possibles, VAL []BYTE str)
.tu
.IP
Search \f(CRstr\fP for any of the character in \f(CRpossibles\fP.
Return the position and character or -1,255\f(CR(BYTE)\fP if none are
found.
.LP
.tt
INT,BYTE FUNCTION search.no.match (VAL []BYTE possibles, VAL []BYTE str)
.tu
.IP
Search \f(CRstr\fP for any character \fInot\fP in \f(CRpossibles\fP.
Return the position and character or -1,255\f(CR(BYTE)\fP if none are
found.
.LP
.tt
PROC str.shift ([]BYTE str, VAL INT start, VAL INT len, VAL INT shift,
                BOOL not.done)
.tu
.IP
Move the substring \f(CR[str FROM start FOR len\fP right
\f(CRshift\fP places. \f(CRnot.done\fP is \f(CRTRUE\fP if the
operation is invalid.  See also \f(CRdelete.string\fP and
\f(CRinsert.string\fP. 
.LP
.tt
INT FUNCTION string.pos (VAL []BYTE search, VAL []BYTE str)
.tu
.IP
Return the position of the string \f(CRsearch\fP in \f(CRstr\fP or -1
if not found.  See also \f(CRchar.pos\fP.
.LP
.tt
PROC to.lower.case ([]BYTE str)
PROC to.upper.case ([]BYTE str)
.tu
.IP
Convert the given string to lower/upper case respectively.
.LP
.SH SEE ALSO
INMOS  occam 2 toolset user manual - part 2 (occam libraries and
appendices) INMOS document number 72 TDS 276 02.
.SH AUTHOR
This document is Copyright (C) 1993 David Beckett, University of Kent
at Canterbury.
.LP
The library contents are Copyright (C) 1991 INMOS Limited.
