--{{{  LIB 
--{{{  specifications of all the system defined constants
-- In this fold are the specifications of names for constants
-- whose values are defined by the TDS or underlying hardware
-- Note that the user may change the names but not the values.
-- A further set of constants for filing system access, etc are given elsewhere
--{{{  common array sizes
VAL max.record.size IS 512 :
VAL max.string.size IS 256 :
VAL abs.id.size IS 63:            -- used by obsolete msdos library
--}}}  
--{{{  clock ticks
--VAL tptr.h.ticks.per.second IS 1000000(INT32) : -- high priority process
--VAL tptr.l.ticks.per.second IS 15625(INT32) :   -- low priority process
--VAL tptr.a.ticks.per.second IS 625000(INT32) :  -- rev A silicon
VAL ticks.per.second IS 1000(INT32) :      -- ocg386/DOS
--}}}  

--   term.p protocol (keyboard and screen)
--{{{  terminal definitions
VAL VT220 IS 1:
VAL VT100 IS 2:
VAL TVi920 IS 3:
VAL WYS50 IS 4:
VAL UNKNOWN IS 5 :
--}}}  
--{{{  ITERM table sizes and values
VAL max.entries.per.screen.line   IS 10 :
VAL max.entries.per.keyboard.line IS 10 :
--{{{  ITERM screen codes
VAL iterm.up.code        IS  1 :
VAL iterm.down.code      IS  2 :
VAL iterm.left.code      IS  3 :
VAL iterm.right.code     IS  4 :
VAL iterm.goto.code      IS  5 :
VAL iterm.ins.char.code  IS  6 :
VAL iterm.del.char.code  IS  7 :
VAL iterm.clear.eol.code IS  8 :
VAL iterm.clear.eos.code IS  9 :
VAL iterm.ins.line.code  IS 10 :
VAL iterm.del.line.code  IS 11 :
VAL iterm.beep.code      IS 12 :
VAL iterm.cls.code       IS 13 :
--}}}  
--}}}  
--{{{  screen cursor addressing
VAL first.screen.col  IS 0 :
VAL first.screen.line IS 0 :
VAL first.text.col    IS first.screen.col :
--{{{  screen size dependent non-constants (debugger assumes constant width)
-- avoid these by using tt.initialise
VAL last.screen.col   IS 79 :
VAL last.screen.line  IS 23 :
VAL last.text.col     IS last.screen.col :
--}}}  
--}}}  
--{{{  ascii visible characters
VAL min.visible.char  IS 32 :        -- space
VAL max.visible.char  IS 126 :       -- '~'
--}}}  
--{{{  message tags for screen protocol (to.term.p)
-- these correspond to the tags of the SS protocol declared in strmhdr
VAL tt.reset      IS BYTE 0 :
VAL tt.up         IS BYTE 1 :
VAL tt.down       IS BYTE 2 :
VAL tt.left       IS BYTE 3 :
VAL tt.right      IS BYTE 4 :
VAL tt.goto       IS BYTE 5 :
VAL tt.ins.char   IS BYTE 6 :
VAL tt.del.char   IS BYTE 7 :
VAL tt.out.string IS BYTE 8 :
VAL tt.clear.eol  IS BYTE 9 :
VAL tt.clear.eos  IS BYTE 10 :
VAL tt.ins.line   IS BYTE 11 :
VAL tt.del.line   IS BYTE 12 :
VAL tt.beep       IS BYTE 13 :
VAL tt.terminate  IS BYTE 15 :
VAL tt.help       IS BYTE 16 :
VAL tt.initialise IS BYTE 17 :
VAL tt.out.byte   IS BYTE 18 :
VAL tt.out.int    IS BYTE 19 :
VAL tt.key.raw    IS BYTE 20 :
VAL tt.key.cooked IS BYTE 21 :
VAL tt.release    IS BYTE 22 :  -- not for general use
VAL tt.claim      IS BYTE 23 :  -- not for general use
VAL tt.endstream  IS BYTE 24 :
VAL tt.set.poll   IS BYTE 25 :  -- used inside TDS only
--}}}  
--{{{  values for "cooked" keys
VAL tab            IS '*t' :

VAL return         IS INT '*c' :
VAL delete         IS 127 :       -- may also receive tt.del.chl
VAL ft.tag         IS 200 :
VAL ft.return      IS ft.tag + 0 :
VAL ft.up          IS ft.tag + 1 :
VAL ft.down        IS ft.tag + 2 :
VAL ft.left        IS ft.tag + 3 :
VAL ft.right       IS ft.tag + 4 :
VAL ft.del.chl     IS ft.tag + 5 :
VAL ft.del.chr     IS ft.tag + 6 :
VAL ft.del.line    IS ft.tag + 7 :
VAL ft.undel.line  IS ft.tag + 8 :
VAL ft.sol         IS ft.tag + 9 :
VAL ft.eol         IS ft.tag + 10 :
VAL ft.move        IS ft.tag + 11 :
VAL ft.copy        IS ft.tag + 12 :
VAL ft.line.up     IS ft.tag + 13 :
VAL ft.line.down   IS ft.tag + 14 :
VAL ft.page.up     IS ft.tag + 15 :
VAL ft.page.down   IS ft.tag + 16 :
VAL ft.create.fold IS ft.tag + 17 :
VAL ft.remove.fold IS ft.tag + 18 :
VAL ft.open.fold   IS ft.tag + 19 :
VAL ft.close.fold  IS ft.tag + 20 :
VAL ft.enter.fold  IS ft.tag + 21 :
VAL ft.exit.fold   IS ft.tag + 22 :
VAL ft.refresh     IS ft.tag + 23 :
VAL ft.file.fold   IS ft.tag + 24 :
VAL ft.unfile      IS ft.tag + 25 : -- not now used by TDS
VAL ft.finish      IS ft.tag + 26 :
VAL ft.edit.parms  IS ft.tag + 27 :
VAL ft.fold.info   IS ft.tag + 28 :
VAL ft.help        IS ft.tag + 29 :
VAL ft.locate      IS ft.tag + 30 : -- not now used by TDS
VAL ft.get.code    IS ft.tag + 31 :
VAL ft.put.code    IS ft.tag + 32 : -- not now used by TDS
VAL ft.save.macro  IS ft.tag + 32 :
VAL ft.clear.code  IS ft.tag + 33 : -- not now used by TDS
VAL ft.get.macro   IS ft.tag + 33 :
VAL ft.run         IS ft.tag + 34 :
VAL ft.tool0       IS ft.tag + 35 :
VAL ft.tool1       IS ft.tag + 36 :
VAL ft.tool2       IS ft.tag + 37 :
VAL ft.tool3       IS ft.tag + 38 :
VAL ft.tool4       IS ft.tag + 39 :
VAL ft.tool5       IS ft.tag + 40 :
VAL ft.tool6       IS ft.tag + 41 :
VAL ft.tool7       IS ft.tag + 42 :
VAL ft.tool8       IS ft.tag + 43 :
VAL ft.tool9       IS ft.tag + 44 :
VAL ft.word.left   IS ft.tag + 45 :
VAL ft.word.right  IS ft.tag + 46 :
VAL ft.del.wordl   IS ft.tag + 47 :
VAL ft.del.wordr   IS ft.tag + 48 :
VAL ft.delto.eol   IS ft.tag + 49 :
VAL ft.top.of.fold IS ft.tag + 50 :
VAL ft.bottom.of.fold  IS ft.tag + 51 :
VAL ft.select.param IS ft.tag + 52 :
VAL ft.code.info   IS ft.tag + 53 :
VAL ft.pick        IS ft.tag + 54 :
VAL ft.copy.pick   IS ft.tag + 55 :
VAL ft.put         IS ft.tag + 56 :
VAL ft.next.util   IS ft.tag + 57 :
VAL ft.clear.util  IS ft.tag + 58 :
VAL ft.autoload    IS ft.tag + 59 :
VAL ft.next.exe    IS ft.tag + 60 :
VAL ft.clear.exe   IS ft.tag + 61 :
VAL ft.clear.all   IS ft.tag + 62 :
VAL ft.browse      IS ft.tag + 63 :
VAL ft.suspend.tds IS ft.tag + 64 :
VAL ft.define.macro IS ft.tag + 65 :
VAL ft.call.macro  IS ft.tag + 66 :
VAL ft.make.comment IS ft.tag + 67 :
VAL ft.copy.move   IS ft.tag + 68 :  -- reserved for possible future use
VAL ft.delto.sol   IS ft.tag + 69 :  -- reserved for possible future use
VAL ft.bad         IS ft.tag + 70 :
--}}}  
--{{{  special codes from the keyboard channel (from.term.p)
VAL ft.lines.prefix     IS -1 :
VAL ft.columns.prefix   IS -2 :
VAL ft.nolineops.prefix IS -3 :   -- TRUE if no line insert/delete ops
VAL ft.end.init         IS -4 :
VAL ft.table.error      IS -5 :   -- read error
VAL ft.noncom.table     IS -6 :   -- non-compatable table
VAL ft.nocharops.prefix IS -7 :   -- TRUE if no char insert/delete ops
VAL ft.terminated       IS -8 :
VAL ft.released         IS -9 :
VAL ft.claimed          IS -10 :
VAL ft.number.error     IS -11 :
VAL ft.cooked           IS -12 :
VAL ft.raw              IS -13 :
--}}}  
--}}}  
--}}}  
