--{{{  transputer header v12
--{{{  genact lexemes
VAL maxregs       IS 3 :
VAL maxfpuregs    IS 3 :

VAL l.loadpointer IS l.actbase + 0 :
VAL l.dummy       IS l.actbase + 1 :
VAL l.byteabbrev  IS l.actbase + 2 :
VAL l.byteplace   IS l.actbase + 3 :
VAL m.place       IS l.actbase + 4 :
VAL l.int16abbrev IS l.actbase + 5 :
VAL l.int16place  IS l.actbase + 6 :
--}}}  
--{{{  Lexemes for kernel operations generated by trans
VAL m.enablechan      IS l.actbase + 20 :
VAL m.enabletimeafter IS l.actbase + 21 :
VAL m.enableskip      IS l.actbase + 22 :
VAL m.disablechan     IS l.actbase + 23 :
VAL m.disabletimeafter IS l.actbase + 24 :
VAL m.disableskip     IS l.actbase + 25 :
VAL m.var             IS l.actbase + 26 :
VAL m.indx            IS l.actbase + 27 :
VAL m.opcode          IS l.actbase + 28 :
VAL m.secopcode       IS l.actbase + 29 :
VAL m.disdiff         IS l.actbase + 30 :    -- difference between labels
VAL m.ldcasescale     IS l.actbase + 31 :    -- size of table element
VAL m.jumptable       IS l.actbase + 32 :
VAL m.endtable        IS l.actbase + 33 :
VAL m.stepcode        IS l.actbase + 34 :
--}}}  
--{{{  transputer instructions
VAL l.ibase IS l.actbase + 50:
--{{{  primaries
VAL m.j       IS l.ibase + #00:        -- jump
VAL m.ldlp    IS l.ibase + #01:        -- load local pointer
VAL m.pfix    IS l.ibase + #02:
VAL m.ldnl    IS l.ibase + #03:       -- load non-local
VAL m.ldc     IS l.ibase + #04:       -- load constant
VAL m.ldnlp   IS l.ibase + #05:       -- load non-local pointer
VAL m.nfix    IS l.ibase + #06:
VAL m.ldl     IS l.ibase + #07:       -- load local
VAL m.adc     IS l.ibase + #08:       -- add constant
VAL m.call    IS l.ibase + #09:       -- call
VAL m.cj      IS l.ibase + #0A:       -- conditional jump
VAL m.ajw     IS l.ibase + #0B:       -- adjust workspace
VAL m.eqc     IS l.ibase + #0C:       -- equals constant
VAL m.stl     IS l.ibase + #0D:       -- store local
VAL m.stnl    IS l.ibase + #0E:       -- store non-local
VAL m.opr     IS l.ibase + #0F:       -- operate
--}}}  
--{{{  secondaries
-- these must be kept ordered according to op code
--{{{  short secondaries
VAL l.sbase IS l.ibase + 20:
VAL m.rev     IS l.sbase + #00:        -- reverse
VAL m.lb      IS l.sbase + #01:        -- load byte
VAL m.bsub    IS l.sbase + #02:        -- byte subscript
VAL m.endp    IS l.sbase + #03:        -- end process
VAL m.diff    IS l.sbase + #04:        -- difference
VAL m.add     IS l.sbase + #05:
VAL m.gcall   IS l.sbase + #06:        -- general call
VAL m.in      IS l.sbase + #07:
VAL m.prod    IS l.sbase + #08:
VAL m.gt      IS l.sbase + #09:        -- greater than
VAL m.wsub    IS l.sbase + #0A:        -- word subscript
VAL m.out     IS l.sbase + #0B:
VAL m.sub     IS l.sbase + #0C:
VAL m.startp  IS l.sbase + #0D:        -- start process
VAL m.outbyte IS l.sbase + #0E:
VAL m.outword IS l.sbase + #0F:
--}}}  
--{{{  10 - 1F
VAL m.seterr  IS l.sbase + #10:
-- VAL        IS l.sbase + #11:        -- not used
VAL m.resetch IS l.sbase + #12:
VAL m.csub0   IS l.sbase + #13:        -- check subscript from 0
-- VAL        IS l.sbase + #14:        -- not used
VAL m.stopp   IS l.sbase + #15:
VAL m.ladd    IS l.sbase + #16:        -- long arithmetic to generate
VAL m.stlb    IS l.sbase + #17:
VAL m.sthf    IS l.sbase + #18:
VAL m.norm    IS l.sbase + #19:
VAL m.ldiv    IS l.sbase + #1A:
VAL m.ldpi    IS l.sbase + #1B:        -- load pointer to instruction
VAL m.stlf    IS l.sbase + #1C:
VAL m.xdble   IS l.sbase + #1D:
VAL m.ldpri   IS l.sbase + #1E:        -- load current priority
VAL m.rem     IS l.sbase + #1F:
--}}}  
--{{{  20 - 2F
VAL m.ret        IS l.sbase + #20:         -- return
VAL m.lend       IS l.sbase + #21:        -- loop end
VAL m.ldtimer    IS l.sbase + #22:        -- load timer
-- VAL           IS l.sbase + #23:        -- not used
-- VAL           IS l.sbase + #24:        -- not used
-- VAL           IS l.sbase + #25:        -- not used
-- VAL           IS l.sbase + #26:        -- not used
-- VAL           IS l.sbase + #27:        -- not used
-- VAL           IS l.sbase + #28:        -- not used
VAL m.testerr    IS l.sbase + #29:        -- test error
VAL m.testpranal IS l.sbase + #2A:
VAL m.tin        IS l.sbase + #2B:        -- timer input
VAL m.div        IS l.sbase + #2C:
-- VAL           IS l.sbase + #2D:        -- not used
VAL m.dist       IS l.sbase + #2E:        -- disable timer
VAL m.disc       IS l.sbase + #2F:        -- disable channel
--}}}  
--{{{  30 - 3F
VAL m.diss    IS l.sbase + #30:        -- disable skip
VAL m.lmul    IS l.sbase + #31:
VAL m.not     IS l.sbase + #32:
VAL m.xor     IS l.sbase + #33:
VAL m.bcnt    IS l.sbase + #34:        -- byte count
VAL m.lshr    IS l.sbase + #35:
VAL m.lshl    IS l.sbase + #36:
VAL m.lsum    IS l.sbase + #37:       -- in line predefined PROCs
VAL m.lsub    IS l.sbase + #38:
VAL m.runp    IS l.sbase + #39:        -- run process
VAL m.xword   IS l.sbase + #3A:
VAL m.sb      IS l.sbase + #3B:
VAL m.gajw    IS l.sbase + #3C:        -- general adjust workspace
VAL m.savel   IS l.sbase + #3D:
VAL m.saveh   IS l.sbase + #3E:
VAL m.wcnt    IS l.sbase + #3F:        -- word count
--}}}  
--{{{  40 - 4F
VAL m.shr     IS l.sbase + #40:
VAL m.shl     IS l.sbase + #41:
VAL m.mint    IS l.sbase + #42:        -- mimimum integer
VAL m.alt     IS l.sbase + #43:
VAL m.altwt   IS l.sbase + #44:
VAL m.altend  IS l.sbase + #45:        -- alt end
VAL m.and     IS l.sbase + #46:        -- bit and
VAL m.enbt    IS l.sbase + #47:
VAL m.enbc    IS l.sbase + #48:        -- enable channel
VAL m.enbs    IS l.sbase + #49:        -- enable skip
VAL m.move    IS l.sbase + #4A:        -- move message
VAL m.or      IS l.sbase + #4B:        -- bit or
VAL m.csingl  IS l.sbase + #4C:        -- convert double to single
VAL m.ccnt1   IS l.sbase + #4D:        -- check subscript form 1
VAL m.talt    IS l.sbase + #4E:
VAL m.ldiff   IS l.sbase + #4F:
--}}}  
--{{{  50 - 5F
VAL m.sthb    IS l.sbase + #50:
VAL m.taltwt  IS l.sbase + #51:
VAL m.sum     IS l.sbase + #52:
VAL m.mul     IS l.sbase + #53:
VAL m.sttimer IS l.sbase + #54:
VAL m.stoperr IS l.sbase + #55:
VAL m.cword   IS l.sbase + #56:

VAL m.dup        IS l.sbase + #5A:
VAL m.move2dinit IS l.sbase + #5B:
VAL m.move2dall  IS l.sbase + #5C:
VAL m.move2dnonzero  IS l.sbase + #5D:
VAL m.move2dzero     IS l.sbase + #5E:
--}}}  
--{{{  60 - 6F
VAL m.unpacksn    IS l.sbase + #63 :
VAL m.postnormsn  IS l.sbase + #6C :
VAL m.roundsn     IS l.sbase + #6D :
--}}}  
--{{{  70 - 79
VAL m.ldinf       IS l.sbase + #71:
VAL m.fmul        IS l.sbase + #72:
VAL m.crcword     IS l.sbase + #74:
VAL m.crcbyte     IS l.sbase + #75:
VAL m.bitcnt      IS l.sbase + #76:
VAL m.bitrevword  IS l.sbase + #77:
VAL m.bitrevnbits IS l.sbase + #78:
VAL m.rot         IS l.sbase + #79:
--}}}  
--{{{  80 - 8F
-- 80 :
VAL m.wsubdb       IS l.sbase + #81 :
VAL m.fpldnldbi    IS l.sbase + #82 :
VAL m.fpchkerr     IS l.sbase + #83 :
VAL m.fpstnldb     IS l.sbase + #84 :
-- 85 :
VAL m.fpldnlsni    IS l.sbase + #86 :
VAL m.fpadd        IS l.sbase + #87 :
VAL m.fpstnlsn     IS l.sbase + #88 :
VAL m.fpsub        IS l.sbase + #89 :
VAL m.fpldnldb     IS l.sbase + #8A :
VAL m.fpmul        IS l.sbase + #8B :
VAL m.fpdiv        IS l.sbase + #8C :
-- 8D
VAL m.fpldnlsn     IS l.sbase + #8E :
VAL m.fpremfirst   IS l.sbase + #8F :
--}}}  
--{{{  90 - 9F
VAL m.fpremstep    IS l.sbase + #90 :
VAL m.fpnan        IS l.sbase + #91 :
VAL m.fpordered    IS l.sbase + #92 :
VAL m.fpnotfinite  IS l.sbase + #93 :
VAL m.fpgt         IS l.sbase + #94 :
VAL m.fpeq         IS l.sbase + #95 :
VAL m.fpi32tor32   IS l.sbase + #96 :
VAL m.fpi32tor64   IS l.sbase + #98 :
-- 98
-- 99
VAL m.fpb32tor64   IS l.sbase + #9A :
VAL m.fptesterr    IS l.sbase + #9C :
VAL m.fprtoi32     IS l.sbase + #9D :
VAL m.fpstnli32    IS l.sbase + #9E :
VAL m.fpldzerosn   IS l.sbase + #9F :
--}}}  
--{{{  A0 - AF
VAL m.fpldzerodb   IS l.sbase + #A0 :
VAL m.fpint        IS l.sbase + #A1 :
-- A2
VAL m.fpdup        IS l.sbase + #A3 :
VAL m.fprev        IS l.sbase + #A4 :
VAL m.fpldnladddb   IS l.sbase + #A6 :
-- A7
VAL m.fpldnlmuldb  IS l.sbase + #A8 :
-- A9
VAL m.fpldnladdsn   IS l.sbase + #AA :
VAL m.fpentry      IS l.sbase + #AB :
VAL m.fpldnlmulsn  IS l.sbase + #AC :

-- These instructions are call using the fentry instruction.

--}}}  
--{{{  FPU entry instructions
VAL l.fentbase IS l.sbase + #B0 :

VAL m.fpusqrtfirst  IS l.fentbase + #01 :
VAL m.fpusqrtstep   IS l.fentbase + #02 :
VAL m.fpusqrtlast   IS l.fentbase + #03 :
VAL m.fpurp         IS l.fentbase + #04 :
VAL m.fpurm         IS l.fentbase + #05 :
VAL m.fpurz         IS l.fentbase + #06 :
VAL m.fpur32tor64   IS l.fentbase + #07 :
VAL m.fpur64tor32   IS l.fentbase + #08 :
VAL m.fpuexpdec32   IS l.fentbase + #09 :
VAL m.fpuexpinc32   IS l.fentbase + #0A :
VAL m.fpuabs        IS l.fentbase + #0B :

VAL m.fpunoround    IS l.fentbase + #0D :
VAL m.fpuchki32     IS l.fentbase + #0E :
VAL m.fpuchki64     IS l.fentbase + #0F :

VAL m.fpudivby2     IS l.fentbase + #11 :
VAL m.fpumulby2     IS l.fentbase + #12 :


VAL m.fpuseterr     IS l.fentbase + #23 :
VAL m.fpuclrerr     IS l.fentbase + #9C :

VAL m.fputogglesign IS l.fentbase + #61 :
--}}}  
VAL top.instruction IS m.fpldnlmulsn :
--}}}  
--}}}  
--}}}  
