/* Copyright 1990 INMOS Limited */

#include <stdio.h>
#ifdef STD_C
#include <stdlib.h>
#endif
#include <string.h>
#include "toolkit.h"

#ifdef STD_C
extern int dis_get_char (void);
#else
extern int dis_get_char ();
#endif

/*{{{   PUBLIC void hexdump (pos, fs)   */
PUBLIC void hexdump (pos, fs)
const long int pos;
FILE *fs;
{
  long int posn;
  char string[17], *ptr;
  int c, i, k;
  posn = pos;
  c = dis_get_char ();
  while (c != EOF)
  {
    fprintf (fs, "%08lX", posn);
    ptr = string;
    for (k = 0; k < 4; k++)
    {
      fprintf (fs, " ");
      for (i = 0; i < 4; i++)
      {
        /*{{{   print char   */
        if ((c >= ' ') && (c <= '~')) /* printable */
        {
          *ptr++ = (char) c;
          fprintf (fs, "%02X", c);
        }
        else if (c == EOF)            /* eof */
        {
          *ptr++ = ' ';
          fprintf (fs, "  ");
        }
        else                          /* non printable */
        {
          *ptr++ = '.';
          fprintf (fs, "%02X", c);
        }
        /*}}}*/
        posn++;
        if (c != EOF) c = dis_get_char ();
      }
    }
    *ptr = '\0';
    fprintf (fs, "      %s\n", string);
  }
}
/*}}}*/
