/* Copyright 1990 INMOS Limited */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "toolkit.h"

#if TARG==PC
#define ERR_STREAM stdout
#else
#define ERR_STREAM stderr
#endif

PUBLIC int error (int level, char const *progname, char const *filename, char const *fmt, ...)
{
  va_list args;
  int stop;
  switch (level)
  {
    case (ERR_WARNING): fprintf (ERR_STREAM,"Warning-"); stop = FALSE; break;
    case (ERR_ERROR):   fprintf (ERR_STREAM,"Error-");   stop = FALSE; break;
    case (ERR_SERIOUS): fprintf (ERR_STREAM,"Serious-"); stop = TRUE;  break;
    case (ERR_FATAL):   fprintf (ERR_STREAM,"Fatal-");   stop = TRUE;  break;
    default: fprintf (ERR_STREAM,"Fatal-%s-unknown-error-type\n",progname);
             exit (EXIT_FAILURE);
             break;
  }

  if (*progname != '\0') fprintf (ERR_STREAM,"%s-", progname);
  if (*filename != '\0') fprintf (ERR_STREAM,"%s-", filename);

  va_start (args, fmt);
  vfprintf (ERR_STREAM, fmt, args);
  fprintf (ERR_STREAM,"\n");
  va_end (args);

  if (stop) exit (EXIT_FAILURE);
  return (EXIT_FAILURE);
}
