/* Copyright 1990 INMOS Limited */

#include <stdio.h>
#include <string.h>
#ifdef STD_C
#include <stdlib.h>
#endif
#include "toolkit.h"

/*{{{   PRIVATE int check (c)   */
PRIVATE int check (c)
const char c;
{
  switch (c)
  {
    case '/':
    case '\\':
    case ':':
    case ']':
        return(TRUE);
        break;
    default:
        return (FALSE);
        break;
  }
}
/*}}}*/
/*{{{   PUBLIC char *strip_path (string)   */
PUBLIC char *strip_path (string)
char const *string;
{
  int i, len;
  char *ptr, *start, *temp;

  /* copy string into temp so I can fiddle with it */
  len = 0;
  while (string[len++] != '\0');
  temp = malloc_chk (len * sizeof (char));
  for (i = 0; i < len; i++) temp[i] = string[i];

  /* find the start of the file name */
  ptr = &temp[len - 1];
  while ((ptr != temp) && !check (*ptr)) ptr--;
  if (check (*ptr)) start = ++ptr;
  else start = temp;
  start = str_duplicate (start);
  free_chk (temp);
  return (start);
}
/*}}}*/
/*{{{   PUBLIC char *derive_string (string, full, extension)   */
PUBLIC char *derive_string (string, full, extension)
char const *string, *extension;
int full;
{
  int i, len;
  char *ptr, *start, *temp;

  if (!full) temp = strip_path (string);
  else 
  {
    len = 0;
    while (string[len++] != '\0');
    temp = malloc_chk (len * sizeof (char));
    for (i = 0; i < len; i++) temp[i] = string[i];
  
  }

  start = temp; 


  /* knock off the extension - if any */
  len = strlen (start);
  ptr = &start[len - 1];
  while ((ptr != start) && (*ptr != '.') && !check(*ptr)) ptr--;
  if (*ptr == '.') *ptr = '\0';

  /* glue on new extension */
  ptr = str_concat (start, extension);
  free_chk (temp);
  return (ptr);
}
/*}}}*/

