#define DEBUG
/*****************************************************************************
 *
 *  use2 - usage checker for occam 2
 *
 *****************************************************************************/
/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
******************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include "includes.h"
# include "useerror.h"
# include "lexconst.h"
# include "usehdr.h"
# include "use1def.h"
# include "use2def.h"
# include "syndef.h"
# include "chkdef.h"
/*}}}*/

/*{{{  static variables*/
PRIVATE SOURCEPOSN lastloc = (BIT32) 0;
/*}}}*/

/*{{{  DEBUG_MSG*/
#undef DEBUG_MSG
#ifdef DEBUG
  #define DEBUG_MSG(X) { if (debuguse) printf X; }
#else
  #define DEBUG_MSG(X)
#endif
/*}}}*/

/*{{{  PRIVATE int accesses_overlap (slist1, slist2)*/
/*****************************************************************************
 *
 *  Test whether any of the accesses specified in the two lists of accessed
 *  subscripts 'slist1' and 'slist2' overlap.
 *
 *****************************************************************************/
PRIVATE int accesses_overlap ( subscrlist *slist1 , subscrlist *slist2 )
{
  while (slist1 != NULL)
    {
      if (subscr_overlaps(slist2, SLFirstOf(slist1), SLLastOf(slist1)))
        return(TRUE);
      slist1 = SLNextOf(slist1);
    }
  return(FALSE);
}
/*}}}*/
/*{{{  PUBLIC void check_no_overlaps (vlist1, vlist2, loc)*/
/*****************************************************************************
 *
 *  Check that accesses do not overlap.  If they do generate the appropriate
 *  error message.
 *  Written variables must not overlap with the same variable being read or
 *  written in the other list.
 *  Channel input usage must not overlap
 *  Channel output usage must not overlap
 *  SHC, 3-Jan-89: Timers are not checked.
 *
 *****************************************************************************/
PUBLIC void check_no_overlaps ( varlist *vlist1 , varlist *vlist2 , SOURCEPOSN loc )
{
  while (vlist1 != NULL)
    {
      treenode *n = VLNameOf(vlist1);
      if (basetype(NTypeOf(n)) != S_TIMER
#if 1 /*SHARED_VARS*/
      /* EXPERIMENTAL way to prevent usage checking of some variables
         CON 5/2/91 */
          && !NVSharedOf(n)
#endif
         )
        /*{{{  do check*/
        {
          varlist *list;
          for (list = vlist2; (list != NULL) && (VLNameOf(list) != n); list = VLNextOf(list))
            ; /* skip */
          if (list != NULL)
            {
              if (accesses_overlap(VLWrittenOf(vlist1), VLWrittenOf(list)))
                usereport(USE_WRITTEN_IN_PAR, loc, n);
              if (accesses_overlap(VLWrittenOf(vlist1), VLReadOf(list)) ||
                  accesses_overlap(VLReadOf(vlist1), VLWrittenOf(list))   )
                usereport(USE_READ_AND_WRITTEN_IN_PAR, loc, n);
              if (accesses_overlap(VLInputOf(vlist1), VLInputOf(list)))
                usereport(USE_INPUT_IN_PAR, loc, n);
              if (accesses_overlap(VLOutputOf(vlist1), VLOutputOf(list)))
                usereport(USE_OUTPUT_IN_PAR, loc, n);
            }
        }
        /*}}}*/
      vlist1 = VLNextOf(vlist1);
    }
}
/*}}}*/
/*{{{  PUBLIC varlist *use_freevarsin (n, scope, vlist)*/
/*****************************************************************************
 *
 *  use_freevarsin takes a treenode, 'n', a scope level, 'scope', and a list of
 *  free variables, 'vlist', and adds to 'vlist' any variables used in tree
 *  'n' of scope less than 'scope', which aren't already in vlist.
 *  for the special cases not handled by the general freevarsin in use1.c
 *
 *****************************************************************************/

PUBLIC varlist *use_freevarsin ( treenode *n , int scope , varlist *vlist )
{
  DEBUG_MSG(("use_freevarsin: %s\n", usetagstring(n)));
  switch(TagOf(n))
    {
      /*{{{  ASS*/
      /* Added here to fix bug 278 in buglist */
      case S_ASS :
        if (TagOf(LHSOf(n)) == S_LIST)
          {
            /* Check for overlap of LHS of multiple assignment */
            varlist *vars_used = NULL;
            varlist *uses_vars;
            SOURCEPOSN oldloc = lastloc;
            lastloc = LocnOf(n);
            n = LHSOf(n);
            while (!EndOfList(n))
              {
                uses_vars = freevarsinexp(ThisItem(n), -1, NULL, EXP_WRITTEN, TRUE);
                check_no_overlaps(vars_used, uses_vars, lastloc);
                vars_used = merge(uses_vars, -1, vars_used);
                release_varlist(uses_vars);
                n = NextItem(n);
              }
            vlist = merge(vars_used, scope, vlist);
            release_varlist(vars_used);
            lastloc = oldloc;
          }
        break;
      /*}}}*/
      /*{{{  PAR PRIPAR PLACEDPAR*/
      case S_PAR: case S_PRIPAR: case S_PLACEDPAR: case S_DO:
        {
          varlist *vars_used = NULL;
          varlist *uses_vars;
          SOURCEPOSN save_lastloc = lastloc;
          lastloc = LocnOf(n);
          n = CBodyOf(n);
          while (!EndOfList(n))
            {
              uses_vars = freevarsin(ThisItem(n), -1, NULL, TRUE);
              check_no_overlaps(vars_used, uses_vars, lastloc);
              vars_used = merge(uses_vars, -1, vars_used);
              release_varlist(uses_vars);
              n = NextItem(n);
            }
          vlist = merge(vars_used, scope, vlist);
          release_varlist(vars_used);
          lastloc = save_lastloc;
        }
        break;
      /*}}}*/
      /*{{{  REPLPAR PRIREPLPAR PLACEDREPLPAR*/
      case S_REPLPAR: case S_PRIREPLPAR: case S_PLACEDREPLPAR: case S_REPLDO:
        {
          SOURCEPOSN save_lastloc = lastloc;
          if (scope < 0)
            scope = NScopeOf(ReplCNameOf(n));
          vlist = freevarsinexp(ReplCStartExpOf(n), scope, vlist, EXP_READ, TRUE);
          vlist = freevarsinexp(ReplCLengthExpOf(n), scope, vlist, EXP_READ, TRUE);
          lastloc = LocnOf(n);
          lexlevel++; /* bug 1008 9/10/90 */
          DEBUG_MSG(("use_freevarsin: incrementing lexlevel\n"));
          if (is_evaluable(ReplCStartExpOf(n)) &&
              is_evaluable(ReplCLengthExpOf(n)))
            /*{{{  base and count both known*/
            {
              varlist *vars_used = NULL;
              varlist *uses_vars;
              INT32 base = evaluate(ReplCStartExpOf(n));
              INT32 count = evaluate(ReplCLengthExpOf(n));
              treenode *name = ReplCNameOf(n);
              n = ReplCBodyOf(n);
              SetNReplKnown(name, TRUE);
              while (count > 0)
                {
                  DEBUG_MSG(("use_freevarsin: repl %s set to %ld\n", WNameOf(NNameOf(name)), base));
                  SetNReplValue(name, base);
                  uses_vars = freevarsin(n, NScopeOf(name), NULL, TRUE);
                  check_no_overlaps(vars_used, uses_vars, lastloc);
                  vars_used = merge(uses_vars, -1, vars_used);
                  release_varlist(uses_vars);
                  base++;
                  count--;
                }
              vlist = merge(vars_used, scope, vlist);
              release_varlist(vars_used);
              SetNReplKnown(name, FALSE);
            }
            /*}}}*/
          else
            /*{{{  base not known*/
            /* replicator base is unknown so no access to free vars */
            {
              varlist *uses_vars;
              SetNReplKnown(ReplCNameOf(n), FALSE);
              n = ReplCBodyOf(n);
              uses_vars = freevarsin(n, -1, NULL, TRUE);
              check_no_overlaps(uses_vars, uses_vars, lastloc); /* ie check no free vars */
              vlist = merge(uses_vars, scope, vlist); /* just in case there were any */
              release_varlist(uses_vars);
            }
            /*}}}*/
          DEBUG_MSG(("use_freevarsin: decrementing lexlevel\n"));
          lexlevel--;
          lastloc = save_lastloc;
        }
        break;
      /*}}}*/
    }
  return vlist;
}
/*}}}*/
/*{{{  PUBLIC int goes_par (n)*/
PRIVATE int goes_par_result;
/*{{{  PRIVATEPARAM int do_goes_par (n)*/
/*****************************************************************************
 *
 *  Test whether a process goes PAR at all.  PROC and FUNCTION calls
 *  are not expanded.
 *
 *****************************************************************************/
PRIVATEPARAM int do_goes_par ( treenode *n )
{
  if (!goes_par_result)
    {
      DEBUG_MSG(("do_goes_par: %s\n", usetagstring(n)));
      switch(TagOf(n))
        {
          case S_PAR: case S_PRIPAR: case S_PLACEDPAR:
          case S_REPLPAR: case S_PRIREPLPAR: case S_PLACEDREPLPAR:
          case S_DO: case S_REPLDO:
            goes_par_result = TRUE;
            break;
          case S_ASS :
            /* Added so that replicators are checked inside multi-assign */
            /* (fixing bug 278 in buglist) */
            goes_par_result = (TagOf(LHSOf(n)) == S_LIST);
            break;
        }
    }
  return goes_par_result;
}
/*}}}*/
/*{{{  PUBLIC int goes_par (n)*/
/*****************************************************************************
 *
 *  Test whether a process goes PAR at all.  PROC and FUNCTION calls
 *  are not expanded.
 *
 *****************************************************************************/
PUBLIC int goes_par ( treenode *n )
{
  goes_par_result = FALSE;
  prewalkproctree(n, do_goes_par);
  return goes_par_result;
}
/*}}}*/
/*}}}*/
/*{{{  PUBLIC void usagecheck (n)*/
/*{{{  PRIVATEPARAM int do_usagecheck (n)*/
/*****************************************************************************
 *
 *  Perform usage check of variables and channels inside a routine.
 *  Expand replicators where possible and necessary.
 *
 *****************************************************************************/
PRIVATEPARAM int do_usagecheck ( treenode *n )
{
  DEBUG_MSG(("do_usagecheck: %s\n", usetagstring(n)));
  switch(TagOf(n))
    {
      /*{{{  PAR PRIPAR PLACEDPAR + repl versions*/
      case S_REPLPAR: case S_PRIREPLPAR: case S_PLACEDREPLPAR:
      case S_PAR: case S_PRIPAR: case S_PLACEDPAR: case S_DO: case S_REPLDO:
      case S_ASS: /* Added to allow usage check on multiple assignments (bug 278) */
        {
          varlist *vars_used;
          vars_used = use_freevarsin(n, -1, NULL);
          release_varlist(vars_used);
        }
        return STOP_WALK;
      /*}}}*/
      /*{{{  REPLSEQ REPLIF REPLALT PRIREPLALT*/
      case S_REPLSEQ: case S_REPLIF: case S_REPLALT: case S_PRIREPLALT:
        /* N.B. no need to expand replicator if process doesn't go PAR */
        if (is_evaluable(ReplCStartExpOf(n)) &&
            is_evaluable(ReplCLengthExpOf(n)) &&
            goes_par(ReplCBodyOf(n)))
          /*{{{  base & count both known & body goes PAR; return TRUE*/
          {
            INT32 base = evaluate(ReplCStartExpOf(n));
            INT32 count = evaluate(ReplCLengthExpOf(n));
            treenode *name = (treenode *) ReplCNameOf(n);
            n = ReplCBodyOf(n);
            SetNReplKnown(name, TRUE);
            while (count > 0)
              {
                SetNReplValue(name, base);
                prewalkproctree(n, do_usagecheck);
                base++;
                count--;
              }
            SetNReplKnown(name, FALSE);
            return STOP_WALK;
          }
          /*}}}*/
        else
          /*{{{  otherwise ...*/
          {
            SetNReplKnown(ReplCNameOf(n), FALSE);
          }
          /*}}}*/
        break;
      /*}}}*/
    }
  return CONTINUE_WALK;
}
/*}}}*/
/*{{{  PRIVATEPARAM int do_usagecheck_tree (n)*/
/*****************************************************************************
 *
 * look for PROCs and FUNCTIONs.
 * call do_usagecheck on each.
 *
 *****************************************************************************/
PRIVATEPARAM int do_usagecheck_tree ( treenode *n )
{
  switch(TagOf(n))
    {
      /*{{{  proc def*/
      case S_PROCDEF:        /* N.B. Functions can't go PAR */
      CASE_CONFIG_SPEC
        if (!separatelycompiled(DNameOf(n)))
          {
            lexlevel++; /* bug 1008 9/10/90 */
            DEBUG_MSG(("do_usagecheck_tree: incrementing lexlevel\n"));
            prewalkproctree(DValOf(n), do_usagecheck_tree);  /* do nested stuff */
            DEBUG_MSG(("do_usagecheck_tree: now checking %s\n", usetagstring(n)));
            prewalkproctree(DValOf(n), do_usagecheck);
            DEBUG_MSG(("do_usagecheck_tree: decrementing lexlevel\n"));
            lexlevel--;
          }
        break;
      /*}}}*/
      #if 0
      /*{{{  PROCESSOR*/
      case S_PROCESSOR:
        return STOP_WALK;
      /*}}}*/
      #endif
    }
  return CONTINUE_WALK;
}
/*}}}*/
/*{{{  PUBLIC void usagecheck (n)*/
/*****************************************************************************
 *
 *  Walk tree looking for PROCs and FUNCTIONs,
 *  then usage check each one.
 *
 *****************************************************************************/
PUBLIC void usagecheck ( treenode *n )
{
  prewalkproctree(n, do_usagecheck_tree);
  return;
}
/*}}}*/
/*}}}*/
