/*#define DEBUG*/
/****************************************************************************
 *
 *  Occam two syntax analyser
 *
 ****************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
******************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include "includes.h"
# include "lexconst.h"
# include "synerror.h"
# include "syndef.h"
# include "lexdef.h"
# include "lex1def.h"
# include "desc1def.h"
# include "syn1def.h"
# include "chkdef.h"
/*}}}*/

/*{{{  global variables*/
PUBLIC treenode *skipp;
PUBLIC int lexlevel;

/* linebreakindent gives the minimum indentation at which the continuation
   of a line must be. A value of -1 means take the current line indentation.
   It is preserved across a VALOF, as these may have nested line breaks. */
PUBLIC int linebreakindent;

/* Init.ed to FALSE, set TRUE when a PROC or FUNCTION is read */
PUBLIC int foundroutine;

/* If this is TRUE, only warn (not error) for badly indented comments */
PUBLIC int warn_comment_indent = FALSE; /* bug 853 18/1/91 */
/*}}}*/

/*{{{  check for symbol*/
/* return TRUE if required token not found */
/*{{{  PUBLIC void ignore (s)*/
/* The symbol to be ignored */
PUBLIC void ignore ( int s )
{
  if (symb == s)
    nextsymb ();
}
/*}}}*/
/*{{{  PUBLIC void ignorecomments(i)*/
/* Throw away any comments with an indentation >= i */
PUBLIC void ignorecomments ( int i )
{
  while ((symb == S_COMMENT) && (symbindent >= i))
    /* Throw away the comment */
    nextline ();
}
/*}}}*/
/*{{{  PUBLIC int checkfor (s)*/
PUBLIC int checkfor ( int s )
{
  if (symb == s)
    {
      nextsymb ();
      return FALSE;
    }
  else
    {
      synetoken (s);
      return TRUE;
    }
}
/*}}}*/
/*{{{  PRIVATE int badindenterr*/
PRIVATE int badindenterr(void)
/* returns TRUE if a real error, FALSE if just a warning */
{
#if 0
  synerr(SYN_BAD_INDENT, flocn);
  return TRUE;
#else
  const int warn = warn_comment_indent && (symb == S_COMMENT);
  DEBUG_MSG(("badindenterr: warn?:%d\n", warn));
  msg_out(warn ? SEV_WARN : SEV_ERR,
          SYN, SYN_BAD_INDENT, flocn); /* modified bug 853 18/1/91 */
  if (warn) ignorecomments(0); /* ignore all following comments */
  return !warn;
#endif
}
/*}}}*/
/*{{{  PUBLIC int checkindent (i)*/
PUBLIC int checkindent ( int i )
{
  ignorecomments (i);
  if ((symb != S_END) && (symbindent != i))
    {
      const int err = badindenterr();
      DEBUG_MSG(("checkindent: err?%d\n", err));
      if (err) skiplines(i);
      return (err);
    }
  else
    return (FALSE);
}
/*}}}*/
/*{{{  PUBLIC void checknewline ()*/
PUBLIC void checknewline ( void )
{
  if (symb == S_COMMENT)
    nextsymb ();
  if (symb != S_NEWLINE)
    synerr_e(SYN_E_NEWLINE, flocn, symb);
  nextline ();
}
/*}}}*/
/*{{{  PUBLIC int checknlindent (i)*/
/* Check next lexical token is a newline, ignore any following comments
at an indent >= i, check that the first token after the ignored comments
has an indent of i. */
PUBLIC int checknlindent ( int i )
{
  checknewline ();
  return checkindent (i);
}
/*}}}*/
/*{{{  PUBLIC int checklinebreak ()*/
/* Returns TRUE if line appears to be split, and next line under indented */
PUBLIC int checklinebreak ( void )
{
  if (symb == S_COMMENT)
    nextsymb ();
  if (symb == S_NEWLINE)
    {
      if (linebreakindent < 0)
        linebreakindent = lineindent;
      nextline ();
      ignorecomments(linebreakindent);
      if (symbindent < linebreakindent)
        {
          DEBUG_MSG(("checklinebreak\n"));
          return badindenterr();
        }
    }
  return FALSE;
}
/*}}}*/
/*}}}*/
/*{{{  PRIVATE int namenodetag (tag)*/
/*****************************************************************************
 *
 *  namenodetag takes a name node tag, 'tag', and converts it to the
 *              appropriate tag for the file it is declared in
 *              (ie. SC, library, standard library, predefined name)
 *
 *****************************************************************************/
PRIVATE int namenodetag ( int tag )
{
  switch (lexmode)
    {
      case LEX_SOURCE: return tag;
      case LEX_LIB:    
      case LEX_EXTERNAL: return (tag == N_PROCDEF) ? N_LIBPROCDEF : N_LIBFUNCDEF;
      case LEX_SC:     return (tag == N_PROCDEF) ? N_SCPROCDEF : N_SCFUNCDEF;
      case LEX_STDLIB: return (tag == N_PROCDEF) ? N_STDLIBPROCDEF :
                                                   N_STDLIBFUNCDEF;
      case LEX_PREDEFS:return (tag == N_PROCDEF) ? N_PREDEFPROC :
                                                   N_PREDEFFUNCTION;
      default:           return (0); /* Not reached */
    }
}
/*}}}*/
/*{{{  PUBLIC treenode *declare (stype, locn, t, name, e)*/
/* Mode of declaration */
/* Location of declaration */
/* Tree representing type of declared object */
/* Pointer to node containing text of name */
/* Value of declaration, eg. rhs of abbrev */
PUBLIC treenode *declare ( int stype , SOURCEPOSN locn , treenode *t ,
                           wordnode *name , treenode *e )
{
  treenode *tptr, *nptr;
  int ntype;
  /*{{{  set up ntype*/
  switch (stype)
    {
      case S_VALABBR:   ntype = N_VALABBR;               break;
      case S_VALRETYPE: ntype = N_VALRETYPE;             break;
      case S_DECL:      ntype = N_DECL;                  break;
      case S_ABBR:      ntype = N_ABBR;                  break;
      case S_RETYPE:    ntype = N_RETYPE;                break;
      case S_TPROTDEF:  ntype = N_TPROTDEF;              break;
      case S_SPROTDEF:  ntype = N_SPROTDEF;              break;
      case S_LABELDEF:  ntype = N_LABELDEF;              break;
      case S_PROCDEF:   ntype = namenodetag(N_PROCDEF);  break;
      case S_SFUNCDEF:  ntype = namenodetag(N_SFUNCDEF); break;
      case S_LFUNCDEF:  ntype = namenodetag(N_LFUNCDEF); break;
  #ifdef CONFIG
      case S_NETWORK:   ntype = N_NETWORK;               break;
      case S_CONFIG:    ntype = N_CONFIG;                break;
      case S_MAPPING:   ntype = N_MAPPING;               break;
  #endif
      default:
        /* internal error */
        msg_out_i(SEV_INTERNAL, SYN, SYN_ILLEGAL_DECL_TYPE, locn, stype);
    }
  /*}}}*/
  nptr = newnamenode(ntype, locn, name, t, NULL, lexlevel, 0, NM_DEFAULT);
  tptr = newdeclnode (stype, locn, nptr, e, NULL);
  SetNDecl(nptr, tptr);
  /*{{{  add a separately compiled routine to the entrypointlist*/
  if (separatelycompiled(nptr))
    addtoentrypointlist(nptr);
  /*}}}*/
  return (tptr);
}
/*}}}*/
/*{{{  PUBLIC treenode *declname (ntype, locn, name, type, spec)*/
/* Type of declaration - N_ABBR, N_VALABBR, N_DECL etc. */
/* Pointer to node containing text of name */
/* A tree structure representing type of declaration */
/* Pointer to the specification of the name on parse tree */
PUBLIC treenode *declname ( int ntype , SOURCEPOSN locn ,
          wordnode *name , treenode *type , treenode *spec )
{
  return newnamenode(ntype, locn, name, type, spec, lexlevel, 0, NM_DEFAULT);
}
/*}}}*/
/*{{{  void syninit ()*/
void syninit ( void )
  {
    lexlevel = 0;
    linebreakindent = (-1);
    foundroutine = FALSE;
    skipp = newleafnode(S_SKIP,0);
    nextsymb ();
  }
/*}}}*/
