/****************************************************************************
 *
 *  Error reporting definitions
 *
 ****************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
******************************************************************************/
/*}}}*/

#include <setjmp.h>
#include <assert.h>

#define ANY_MODULE  1
#define SYN   2
#define CHK   3
#define USE   4
#define VTI   5
/*#define VCONF 6*/
#define GEN 7

#define SEV_INFO     0 /* Info ... */
#define SEV_WARN     1 /* Warning... */
#define SEV_ERR      2 /* Error..., but returns ok */
#define SEV_ERR_JMP  3 /* Error..., but does a longjmp to 'env' */
#define SEV_FATAL    4 /* Fatal..., and does a longjmp to 'env' */
#define SEV_ABORT    5 /* Fatal..., calls end_compiler */
#define SEV_INTERNAL 6 /* Fatal..., assert(FALSE); */

extern int errors;
extern jmp_buf env;
extern int comp_error;

SOURCEPOSN sourcefileof PARMS((SOURCEPOSN locn));
void msg_out    PARMS((int severity, int module, int errnum, SOURCEPOSN locn));
void msg_out_c  PARMS((int severity, int module, int errnum, SOURCEPOSN locn,
                      char c));
void msg_out_i  PARMS((int severity, int module, int errnum, SOURCEPOSN locn,
                      BIT32 d));
void msg_out_s  PARMS((int severity, int module, int errnum, SOURCEPOSN locn,
                      const char *s));
/*void msg_out_ii PARMS((int severity, int module, int errnum, SOURCEPOSN locn,
                      BIT32 d1, BIT32 d2));*/
void msg_out_is PARMS((int severity, int module, int errnum, SOURCEPOSN locn,
                      BIT32 d, const char *s));
void msg_out_ss PARMS((int severity, int module, int errnum, SOURCEPOSN locn,
                      const char *s1, const char *s2));
void msg_out_e  PARMS((int severity, int module, int errnum, SOURCEPOSN locn,
                      int tag));

#define ferrorprint(S,N,L,P,Q)    msg_out(SEV_ERR,    (S),(N),(L),(P),(Q))
#define fwarningprint(S,N,L,P,Q)  msg_out(SEV_WARN,   (S),(N),(L),(P),(Q))
#define berrorreport(M,N,L,R,P,Q) msg_out((R)?SEV_WARN:SEV_FATAL,(M),(N),(L),(P),(Q))


#define lexerr(N,L)      synerr((N),(L))
#define lexerr_s(N,L,S)  synerr_s((N),(L),(S))
#define lexerr_i(N,L,I)  synerr_i((N),(L),(I))

#define lexfatal(N,L)      msg_out  (SEV_ERR_JMP,SYN,(N),(L))
#define lexfatal_s(N,L,S)  msg_out_s(SEV_ERR_JMP,SYN,(N),(L),(S))
#define lexfatal_i(N,L,I)  msg_out_i(SEV_ERR_JMP,SYN,(N),(L),(I))

#define synwarn_i(N,L,I) msg_out_i(SEV_WARN,SYN,(N),(L),(I))
#define synwarn_s(N,L,S) msg_out_s(SEV_WARN,SYN,(N),(L),(S))
#define synerr(N,L)      msg_out  (SEV_ERR,SYN,(N),(L))
#define synerr_s(N,L,S)  msg_out_s(SEV_ERR,SYN,(N),(L),(S))
#define synerr_i(N,L,I)  msg_out_i(SEV_ERR,SYN,(N),(L),(I))
#define synerr_e(N,L,T)  msg_out_e(SEV_ERR,SYN,(N),(L),(T))

#define chkerr(N,L)      msg_out  (SEV_ERR,CHK,(N),(L))
#define chkerr_s(N,L,S)  msg_out_s(SEV_ERR,CHK,(N),(L),(S))
#define chkerr_i(N,L,I)  msg_out_i(SEV_ERR,CHK,(N),(L),(I))
#define chkerr_ss(N,L,S,T) msg_out_ss(SEV_ERR,CHK,(N),(L),(S),(T))

/*#define chkfatal(N,L,P,Q)        msg_out(SEV_INTERNAL,CHK,(N),(L),(P),(Q))*/

/*#define chkwarning(N,L,P)        chkwarn1((N),(L),(P))*/
/*#define chkrecoverreport(N,L,P)  chkerr1((N),(L),(P))*/
#define chkreport(N,L)           msg_out  (SEV_ERR_JMP,CHK,(N),(L))
#define chkreport_i(N,L,P)       msg_out_i(SEV_ERR_JMP,CHK,(N),(L),(P))
#define chkreport_s(N,L,S)       msg_out_s(SEV_ERR_JMP,CHK,(N),(L),(S))
/*#define chkreport2(N,L,P,Q)      msg_out(SEV_ERR_JMP,CHK,(N),(L),(P),(Q))*/

void chk_invtype PARMS((SOURCEPOSN locn, int tag));

#define genwarn(N)         msg_out  (SEV_WARN, GEN, (N), genlocn)
#define genwarn_i(N,I)     msg_out_i(SEV_WARN, GEN, (N), genlocn,(I))
#define genwarn_s(N,S)     msg_out_s(SEV_WARN, GEN, (N), genlocn,(S))

#define generr(N)          msg_out  (SEV_FATAL, GEN, (N),genlocn)
#define generr_i(N,I)      msg_out_i(SEV_FATAL, GEN, (N),genlocn,(I))
#define generr_s(N,S)      msg_out_s(SEV_FATAL, GEN, (N),genlocn,(S))

#define geninternal(N)     msg_out  (SEV_INTERNAL, GEN, (N),genlocn)
#define geninternal_i(N,I) msg_out_i(SEV_INTERNAL, GEN, (N),genlocn,(I))
#define geninternal_s(N,S) msg_out_s(SEV_INTERNAL, GEN, (N),genlocn,(S))
#define geninternal_is(N,I,S) msg_out_is(SEV_INTERNAL, GEN, (N),genlocn,(I),(S))

#if 0
#define genwarn0(N,L)            msg_out(SEV_WARN,   GEN,(N),(L),ZERO32,ZERO32)
#define genwarn1(N,L,P)          msg_out(SEV_WARN,   GEN,(N),(L),(P),ZERO32)
#define genwarn2(N,L,P,Q)        msg_out(SEV_WARN,   GEN,(N),(L),(P),(Q))
#define generr0(N,L)             msg_out(SEV_FATAL,  GEN,(N),(L),ZERO32,ZERO32)
#define generr1(N,L,P)           msg_out(SEV_FATAL,  GEN,(N),(L),(P),ZERO32)
#define generr2(N,L,P,Q)         msg_out(SEV_FATAL,  GEN,(N),(L),(P),(Q))
#define genfatal(N,L,P,Q)        msg_out(SEV_INTERNAL,GEN,(N),(L),(P),(Q))
#endif

#define vtiabort(N,L)      msg_out(SEV_ABORT,  VTI,(N),(L))

/*#define genwarning(N,P,Q)        msg_out(SEV_WARN,   GEN,(N),genlocn,(P),(Q))*/
/*#define genreport(N,P,Q)         msg_out(SEV_FATAL,  GEN,(N),genlocn,(P),(Q))*/
/*#define geninternal(N,P,Q)       msg_out(SEV_INTERNAL,GEN,(N),genlocn,(P),(Q))*/

#define badtag(L,T,R)      msg_out_ss(SEV_INTERNAL,ANY_MODULE,ANY_BAD_TAG,(L),itagstring((T)),(R))

void synetoken PARMS((int token));

/*#define lexerror(N,L,P) synerror((N),(L),(P))*/
/*void lexfatal PARMS((int n, SOURCEPOSN locn, BIT32 p1));*/

/* Error messages for all modules */
#define ANY_BAD_TAG 1

#define MAX_ERR_SIZE 256    /* same as MAXSTRING_SIZE */
