/****************************************************************************
 *
 *  Occam two descriptor file constants
 *
 ****************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
******************************************************************************/
/*}}}*/

#define OBJ_FILE_NO_IMPORT_ORIGINS      0x01
#define OBJ_FILE_NO_EXPORT_ORIGINS      0x02
#define OBJ_FILE_PRI_TEXT_SECTION       0x04
#define OBJ_FILE_OCCAM_HARNESS          0x08
#define OBJ_FILE_READ_INCOMPATIBLE_LIBS 0x10
#define OBJ_FILE_NO_HASH_VERSION        0x20
#define OBJ_FILE_DEFAULT                0  /* All off */

struct module_s  /* used for matching symbols to their origin modules */
  {
    struct module_s       *m_next;     /* next on chain for this file */
    struct wordnodestruct *m_name;     /* ptr to origin symbol name */
    BIT32         m_instr, m_attr;     /* processor type and attributes */
    long int               m_seek_ptr; /* position in file */
    int                    m_id_val;   /* id of origin, or special value */
    int                    m_filenum;  /* Number of file in filetable */
    INT32                  m_size;     /* module code size */
  #ifdef CONFIG
    void                  *m_config;   /* Used by the configurer */
    void                  *m_filestr;  /* Used to cache a filename string */
  #endif
  };
typedef struct module_s module_t;
#define ORIGIN_NOT_FOUND (-1)          /* m_id_val special value */
#define ORIGIN_FOUND     (-2)          /* m_id_val special value */

struct procdef_s /* One definition of a PROC from a library */
  {
    struct procdef_s *p_next;
    module_t         *p_module;        /* module which this declaration is in */
    INT32             p_ws;            /* ws usage */
    INT32             p_vs;            /* vs usage */
  #ifdef CONFIG
    INT32             p_offset;        /* entry offset in that module */
  #endif
  };
typedef struct procdef_s procdef_t;
#define ORIGIN_WS (-1)  /* ws value used in a descriptor to indicate
                           that this symbol is an ORIGIN */

